<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class Page extends Model
{
    use Notifiable;
    use Sortable;

    protected $primaryKey = 'id';
    protected $table = 'pages';

    public $sortable = ['id',
                        'locater_id',
                        'title',
                        'content',
                        'created_at',
                        'updated_at'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title', 'content','status','locater_id'
    ];

    
    public function locaterlists()
    {
        return $this->hasone('App\Locater','id','locater_id')->select('*');
    }

    public function fetchCreatedByUser()
    {
        return $this->hasone('App\User','id','created_by')->select('*');
    }

    public function fetchModifiedByUser()
    {
        return $this->hasone('App\User','id','modified_by')->select('*');
    }

    
    
}
