<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminController;
use App\Locater;
use App\Page;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;

class PageController extends AdminController
{
    const RECORD_PER_PAGE = 10;

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function pageslist(Request $request) {
        $admin_id = $request->session()->get('id');

        $pageNo = trim($request->input('page', 1));

        DB::enableQueryLog();

        $keyword = strtolower(trim($request->input('keyword')));
        $pageList = Page::where('pages.is_deleted', '=', '0')
                ->with(array('locaterlists' => function ($query){
                    $query->select(['locater_identity', 'id']);
                }));
        $count = Page::where('pages.is_deleted', '=', '0')
                ->with(array('locaterlists' => function ($query){
                    $query->select(['locater_identity', 'id']);
                }))
                ->count();

        if($keyword)
        {
            $pageList = $pageList->where(function ($query) use ($keyword) {
                $query->orwhere('pages.title', 'like', '%'.$keyword);
                $query->orwhere('pages.contents', 'like', '%'.$keyword);
            });
        }
        
        $records = $pageList->sortable(['id'=>'desc'])->paginate(Self::RECORD_PER_PAGE);
        
        $queries = DB::getQueryLog();
        
        return view('admin.pages.pages_mng', ['records' => $records,'pageNo' => @$pageNo, 'record_per_page' => Self::RECORD_PER_PAGE,'request'=>$request]);
    }

    public function createPage(){
        $locater_identity = Locater::where('locaters.status', '=', '1')->get();
        return view('admin.pages.add', compact('locater_identity'));
    }

    public function savePage(Request $request) {
        $user_id = auth()->user('id');
        if ($request->all()) { 
            
            $title = trim($request->title);
            $locater_id = trim($request->locater_id);
            if(!empty($request->slug)){
                $slug = trim($request->slug);
            }else{
                $slug = str_replace(' ','_',$title);
            }
            $contents = trim($request->contents);
            $meta_title = trim($request->meta_title);
            $meta_keyword = trim($request->meta_keyword);
            $meta_description = trim($request->meta_description);
            $banner_content = trim($request->banner_content);
            $created_by = trim($user_id->id);
            $status = trim($request->status);
            
            $validator = Validator::make($request->all(), [
                'locater_id' => 'required',
                'title' => 'required',
                'contents' => 'required',
                'banner_image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);

            if ($validator->fails()) {
                return redirect()->route('admin.pages.add')
                            ->withErrors($validator)
                            ->withInput();
            } else {
                $page = new Page;
                $page->created_by = $user_id->id;
                $page->title = $title;
                $page->locater_id = $locater_id;
                $page->contents = $contents;
                $page->slug = $slug;
                $page->meta_title = $meta_title;
                $page->meta_keyword = $meta_keyword;
                $page->meta_description = $meta_description;
                
                if(!empty($request->banner_image)){
                    $page->banner_image = $request->file('banner_image')->store('image');
                }
                
                $page->banner_content = $banner_content;
                $page->status = $status;
                $page->save();

                $msg = 'Page has been added successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.pages');
            }
        }
    }

    public function editPage(Request $request, $id){
        if(!empty($id)){
            $data = Page::find($id);
        }
        $locater_identity = Locater::where('locaters.status', '=', '1')->get();
        return view('admin.pages.edit', compact(array('data','locater_identity')));
    }

    public function updatePage(Request $request, $id) {
        $user_id = auth()->user('id');
        $data = array();
        if(!empty($id)){
            $data = Page::find($id);
        }
        if ($request->all()) { 
            
            $title = trim($request->title);
            $locater_id = trim($request->locater_id);
            $slug = trim($request->slug);
            $contents = trim($request->contents);
            $meta_title = trim($request->meta_title);
            $meta_keyword = trim($request->meta_keyword);
            $meta_description = trim($request->meta_description);
            $banner_content = trim($request->banner_content);
            $created_by = trim($user_id->id);
            $status = trim($request->status);

            $validator = Validator::make($request->all(), [
                    'locater_id' => 'required',
                    'title' => 'required',
                    'contents' => 'required',
                    'banner_image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                ]);
                $messages = $validator->messages();

            if ($validator->fails()) {
                return redirect()->route('admin.pages.edit',['id'=>$id])
                            ->withErrors($validator)
                            ->withInput(); 
            } else {

                $page = Page::find($id);
                $modified_by = trim($user_id->id);
                $page->modified_by = $modified_by;

                $page->title = $title;
                $page->locater_id = $locater_id;
                $page->contents = $contents;
                $page->slug = $slug;
                $page->meta_title = $meta_title;
                $page->meta_keyword = $meta_keyword;
                $page->meta_description = $meta_description;
                if(!empty($request->banner_image)){
                    $page->banner_image = $request->file('banner_image')->store('image');
                }
                $page->banner_content = $banner_content;
                $page->status = $status;
                $page->save();
                
                $msg = 'Page has been updated successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.pages');
            }
        }
    }

    /**
    * Function add_page
    *
    * function to add page
    *
    * @Created Date: 28 June,2019
    * @Modified Date: 28 June,2019
    * @param  ARRAY
    * @return STRING
    */
    public function add_page(Request $request, $id = '') {
        $user_id = auth()->user('id');
        $data = array();
        if(!empty($id)){
            //echo"<pre>";
            //$data = Page::find($id)->with('fetchCreatedByUser')->with('fetchModifiedByUser')->first();
            $data = Page::find($id);
            //print_r($data);
            //die;
        }
        if ($request->all()) { //post
            $title = trim($request->title);
            $locater_id = trim($request->locater_id);
            if(!empty($request->slug)){
                $slug = trim($request->slug);
            }else{
                $slug = str_replace(' ','_',$title);
            }
            $contents = trim($request->contents);
            $meta_title = trim($request->meta_title);
            $meta_keyword = trim($request->meta_keyword);
            $meta_description = trim($request->meta_description);
            $banner_content = trim($request->banner_content);
            $created_by = trim($user_id->id);
            $status = trim($request->status);
            if ($id) {
                //Validate the input
                $validator = Validator::make($request->all(), [
                    'locater_id' => 'required',
                    'title' => 'required',
                    'contents' => 'required',
                    'banner_image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                ]);
                $messages = $validator->messages();
            }else {
                //Validate the input
                $validator = Validator::make($request->all(), [
                    'locater_id' => 'required',
                    'title' => 'required',
                    'contents' => 'required',
                    'banner_image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                ]);
            }
            if ($validator->fails()) {
                if($id) {
                   return redirect()->route('admin-editpage',['id'=>$id])
                            ->withErrors($validator)
                            ->withInput(); 
                } else {
                    return redirect()->route('admin-addpage')
                            ->withErrors($validator)
                            ->withInput();
                }
            } else {
                if ($id) { //update case
                    $page = Page::find($id);//->with('userlists');
                    $modified_by = trim($user_id->id);
                    $page->modified_by = $modified_by;
                } else {
                    $page = new Page;
                    $page->created_by = $user_id->id;
                }
                $page->title = $title;
                $page->locater_id = $locater_id;
                $page->contents = $contents;
                $page->slug = $slug;
                $page->meta_title = $meta_title;
                $page->meta_keyword = $meta_keyword;
                $page->meta_description = $meta_description;
                if(!empty($request->banner_image)){
                    $page->banner_image = $request->file('banner_image')->store('image');
                }
                $page->banner_content = $banner_content;
                $page->status = $status;
                $page->save();
                if ($id) {
                    $msg = 'Page has been updated successfully.';
                    $request->session()->flash('add_message', $msg);
                    return redirect()->route('admin-pages');
                } else if (!empty($id)){
                    try{
                        $msg = 'Page has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin-pages');
                    }
                    catch(\Exception $e){
                        //
                    
                    }
                } else {
                    try{
                        $msg = 'Page has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin-pages');
                    }
                    catch(\Exception $e){
                        //
                    }
                }
            }
        }
        else {
            $locater_id_url = Locater::where('locaters.status', '=', '1')->get();
            return view('admin.pages.add_page', ['data' => $data, 'locater_id_url'=> $locater_id_url,'request' => $request]);
        }
    }

    public function page_delete($id, Request $request) {
        if ($id) {
            $page = Page::find($id);
            $page->is_deleted = '1';
            if($page->save()){
                $msg = 'Page has been deleted successfully.';
                $request->session()->flash('message', $msg);
            }
        }
        return redirect()->route('admin-pages');
    }

}