<!--search count and filter start-->
@if(empty($finalData))
<div class="row result_head">
    <div class="col-6">
        <span class="result_head-counts">
        No data found!</span>
    </div>
<div>
<div class="row no-gutters">
</div>
<div class="pagination-wrapper justify-content-center">
</div>
@else
<div class="row result_head">
    <div class="col-6">
        <span class="result_head-counts">
        {{ $meta['total'] }} locations found</span>
    </div>
    <div class="col-6 text-right">
        <div class="dropdown">
            <div class="btn btn-secondary dropdown-toggle custom-dropdown" id="reviewbyfilter" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                Most Newest
            </div>
            <div class="dropdown-menu" aria-labelledby="reviewbyfilter">
                <a class="dropdown-item" href="javascript:void(0);">Highest rating</a>
                <a class="dropdown-item" href="javascript:void(0);">Lowest rating</a>
            </div>
        </div>
    </div>
</div>
<!--location listing start-->
<div class="row no-gutters">
    <div class=" mt-4 location_data-listing">
        <?php foreach($finalData as $key=>$data){ ?>
            <div class="card">
                <div class="card-body">
                    <div class="location_data-img">
                        <img src="vendor/frontend/img/location-img.png" />
                    </div>
                    <div class="location_data-content">
                        <h5 class="title">
                            @if(empty($data['slug']))
                            {{$data['name']}}
                            @else
                            <a href="{{route('detail',['slug'=>$data['slug']])}}"><?php echo $data['name']; ?></a>    
                            @endif
                        </h5>
                        <span class="ratings">
                        <?php for($i=1; $i<=5; $i++){ 
                            $rating = round($data['averageRating']);
                            if($rating >= $i){ 
                                echo'<i class="mdi mdi-star"></i>';
                            }else{
                                echo '<i class="mdi mdi-star-outline"></i>';
                            }
                            ?>
                        <?php } ?>
                            <br>
                            <span class="counts">({{ $data['reviewCounts'] }})</span>
                        </span>
                        <p class="address">
                        <?php echo $data['fullAddress']['addressLines'][0]; ?>
                        <?php if(!empty($data['fullAddress']['addressLines'][1])){ ?>
                            <br> {{ $data['fullAddress']['addressLines'][1] }}</p>
                        <?php } ?>
                        </p>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>                
</div>
<!--pagination start-->
@if($meta['total'] > 15)
<div class="pagination-wrapper justify-content-center">
    <nav>
        <ul class="pagination">
            <?php 
                $links['first'] = explode('page=',$links['first']);
                if(!empty($links['last'])){
                    $links['last'] = explode('page=',$links['last']);
                }else{
                    $links['last'] = '';
                }
                if(!empty($links['prev'])){
                    $links['prev'] = explode('page=',$links['prev']);
                }else{
                    $links['prev'] = '';
                }
                if(!empty($links['next'])){
                    $links['next'] = explode('page=',$links['next']);
                }else{
                    $links['next'] = '';
                }
            ?>

            <li class="page-item">
                <a class="page-link" id="first" title="First" data-page="{{ $links['first'][1] }}" href="javascript:void(0);">
                    <i class="mdi mdi-chevron-double-left"></i>
                </a>
            </li>
            <li class="page-item">
                <a class="page-link" title="Prev" href="javascript:void(0);" id="prev" data-page="@if(@$links['prev']) {{ $links['prev'][1] }} @else @endif" aria-label="Previous">
                    <i class="mdi mdi-chevron-left"></i>
                </a>
            </li>
            <li class="page-item">
                <a class="page-link" title="Next" href="javascript:void(0);" id="next" data-page="@if(@$links['next']) {{ $links['next'][1] }} @else @endif" name="next" aria-label="Next">
                    <i class="mdi mdi-chevron-right"></i>
                </a>
            </li>
            <li class="page-item">
                <a class="page-link" title="Last" id="last" data-page="{{ $links['last'][1] }}" href="javascript:void(0);"><i class="mdi mdi-chevron-double-right"></i></a>
            </li>
        </ul>
    </nav>
</div>
@endif
@endif
