@extends('adminlte::page')

@section('content')

<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>Locater</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Create Locater</li>
            </ol>
        </div>
    </div>
</div><!-- /.container-fluid -->

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"></h3>
                            <div class="alert alert-success alert-dismissible groputitle" style="display:none">
                        </div>
                        @if(Session::has('add_message'))
                        <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {!! session('add_message') !!} 
                        </div>
                        @endif

                        <form class="form-horizontal" id="add-locaterform" action="{{route('admin.locaters.save')}}" method="POST" enctype="multipart/form-data">

                        {{ csrf_field() }}
                        <div class="box-body">
                       
                            <div class="form-group @if($errors->first('locater_identity')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Locater ID<em>*</em></label>
                            <div class="col-sm-10">
                                <input type="text" name="locater_identity" class="form-control" placeholder="Locater ID">
                                <?php if(@$errors->first('locater_identity')) { ?> <span class="help-block">{{@$errors->first('locater_identity')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('locater_code')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Locater Code</label>
                            <div class="col-sm-10">
                                <input type="text" name="locater_code" class="form-control" placeholder="Locater Code">
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('name')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Name<em>*</em></label>
                            <div class="col-sm-10">
                                <input type="text" name="name" class="form-control" placeholder="Name" value="{{old('name',@$data->name)}}">
                                <?php if(@$errors->first('name')) { ?> <span class="help-block">{{@$errors->first('name')}}</span> <?php } ?>
                            </div>
                            </div>
                            <div class="form-group @if($errors->first('description')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Description</label>
                            <div class="col-sm-10">
                                <input type="text" name="description" class="form-control" placeholder="Description">
                            </div>
                            </div>

                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer">
                            <input type="submit" value="Submit" class="btn btn-info">
                            <a href="{{route('admin.locaters')}}" class="btn btn-default">Cancel</a>
                        </div>
                        <!-- /.box-footer -->
                        </form>
                        
                    </div>
                    
                </div>
                <!--/.col (right) -->
            </div>
        </div>
    </div>
        
                
    <style>
        .help-block{
            color:red;
        }
        .error{
            color:red;
        }
    </style>

<script type="text/javascript">
    $( document ).ready(function() {
    
      $.validator.addMethod('filesize', function(value, element, param) {
        return this.optional(element) || (element.files[0].size <= param)
      });
         
      $.validator.addMethod("alphanumspecial", function (value, element) {
        return this.optional(element) || /^(?=.*[a-z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{6,})/i.test(value);
      }, "Combination of alphabets,special characters & numeric values required.");
      $('#add-locaterform').validate({
            ignore: ".ignore",
            rules: {
                locater_identity: {
                    required:true,
                    remote: {
                        url: '{{route("check_locater_identity")}}'+'?id='+'{{@$data->id}}',
                        type: "get",
                        data: {
                            title: function() {
                                return $("#locater_identity").val();
                            }
                        },
                    },
                },
                name: "required",
            },
            // Specify validation error messages
            messages: {
                locater_identity:
                {
                    required:"Please enter Locater ID.",
                    remote:"Locater ID already exist."
                },
                name: "Please enter Name.",
            },
        });
    });
  
</script>

@endsection        