<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*Route::get('/', function () {
    return view('welcome');
});*/

Route::get('/', 'SearchController@index')->name('search');
Route::post('searchlocater', 'SearchController@searchlocater')->name('searchlocater');
Route::get('autocomplete', 'SearchController@autocomplete')->name('autocomplete');
Route::get('detail/{slug}', 'SearchController@detail')->name('detail');
Route::post('reviewpaginate', 'SearchController@reviewpaginate')->name('reviewpaginate');

/* Cron Routes */
Route::get('cron/getLocaterListData', 'CronController@getLocaterListData')->name('getLocaterListData');
/** End Cron Routes */

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

Route::get('/check_email', 'HomeController@check_email')->name('check_email');
Route::get('/check_locater_identity', 'HomeController@check_locater_identity')->name('check_locater_identity');

Route::group(['middleware' => ['auth'], 'prefix' => 'admin', 'namespace' => 'Admin'], function () {
    /* For manage dashboard */
    Route::get('/dashboard', 'AdminController@index')->name('admin-dashboard');

    /* For manage users */
    Route::get('users', 'UserController@usersList')->name('admin.users');
    Route::get('users/create', 'UserController@createUser')->name('admin.user.add');
    Route::post('users/create', 'UserController@saveUser')->name('admin.user.save');
    Route::get('users/{id}/edit', 'UserController@editUser')->name('admin.user.edit');
    Route::post('users/{id}/edit', 'UserController@updateUser')->name('admin.user.update');
    Route::get('users/{id}/delete', 'UserController@deleteUser')->name('admin.user.delete');

    /* For manage locaters */
    Route::get('locaters', 'LocaterController@locatersList')->name('admin.locaters');
    Route::get('locaters/create', 'LocaterController@createLocater')->name('admin.locaters.add');
    Route::post('locaters/create', 'LocaterController@saveLocater')->name('admin.locaters.save'); 
    Route::get('locaters/{id}/edit', 'LocaterController@editLocater')->name('admin.locaters.edit');
    Route::post('locaters/{id}/edit', 'LocaterController@updateLocater')->name('admin.locaters.update');   
    Route::get('locaters/{id}/delete', 'LocaterController@deleteLocater')->name('admin.locaters.delete');

    /* For manage pages */
    Route::any('pages', 'PageController@pagesList')->name('admin.pages');
    Route::get('pages/create', 'PageController@createPage')->name('admin.pages.add');
    Route::post('pages/create', 'PageController@savePage')->name('admin.pages.save'); 
    Route::get('pages/{id}/edit', 'PageController@editPage')->name('admin.pages.edit');
    Route::post('pages/{id}/edit', 'PageController@updatePage')->name('admin.pages.update');   
    Route::get('pages/{id}/delete', 'PageController@deletePage')->name('admin.pages.delete');

    /* For manage offers */
    Route::any('offers', 'OfferController@offersList')->name('admin.offers');
    Route::get('offers/create', 'OfferController@createOffer')->name('admin.offers.add');
    Route::post('offers/create', 'OfferController@saveOffer')->name('admin.offers.save'); 
    Route::get('offers/{id}/edit', 'OfferController@editOffer')->name('admin.offers.edit');
    Route::post('offers/{id}/edit', 'OfferController@updateOffer')->name('admin.offers.update');   
    Route::get('offers/{id}/delete', 'OfferController@deleteOffer')->name('admin.offers.delete');

    /* For manage homepages */
    Route::any('homepages', 'HomepageController@homepagesList')->name('admin.homepages');
    Route::get('homepages/create', 'HomepageController@createHomepage')->name('admin.homepages.add');
    Route::post('homepages/create', 'HomepageController@saveHomepage')->name('admin.homepages.save'); 
    Route::get('homepages/{id}/edit', 'HomepageController@editHomepage')->name('admin.homepages.edit');
    Route::post('homepages/{id}/edit', 'HomepageController@updateHomepage')->name('admin.homepages.update');   
    Route::get('homepages/{id}/delete', 'HomepageController@deleteHomepage')->name('admin.homepages.delete');

});
