<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Validator;
use App\Traits\Apitraits;
use App\Locater;
use Illuminate\Support\Facades\Hash;


class CronController extends Controller
{
    use Apitraits;

    public function getLocaterListData(Request $request){
        $api_url = config('app.api_list');
        
        $getLocaterListMetaData = $this->cronList($api_url);
        
        for($i=$getLocaterListMetaData['current_page']; $i<=$getLocaterListMetaData['last_page']; $i++){
            
            $getLocaterListDataNew = $this->call_api_page($api_url, '', $i);

            $finalData = array_map(function ($data) use ($getLocaterListDataNew) {

                $checkLocaterData = Locater::find($data['id']);
                
                if(empty($checkLocaterData)){
                
                    $locater = new Locater;
                    $locater->locater_identity = $data['id'];
                    $locater->locater_code = $data['code'];
                    $locater->name = $data['name'];
                    $locater->created_by = 1;
                    $locater->save();
                
                }
                
            }, $getLocaterListDataNew['data']);
        }
        return response()->json([
            'status' => 'success',
            'data' => 'Updated Sucessfully'
        ]);
    }

}