<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Validator;
use App\Traits\Apitraits;
use App\Locater;
use App\Page;
use App\City;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;



class CronController extends Controller
{
    use Apitraits;

    public function getLocaterListData(Request $request){
        $api_url = config('app.api_list');
        
        $getLocaterListMetaData = $this->cronList($api_url);
        
        for($i=$getLocaterListMetaData['current_page']; $i<=$getLocaterListMetaData['last_page']; $i++){
            
            $getLocaterListDataNew = $this->call_api_page($api_url, '', $i);

            $finalData = array_map(function ($data) use ($getLocaterListDataNew) {

                $checkLocaterData = Locater::find($data['id']);
                
                if(empty($checkLocaterData)){
                    
                    $locater = new Locater;
                    $locater->locater_identity = $data['id'];
                    $locater->locater_code = $data['code'];
                    $locater->name = $data['name'];
                    $locater->created_by = 1;
                    $locater->save();
                    
                    $page = new Page;
                    $page->locater_id = $locater->id;
                    $page->title = $data['name'];
                    $page->slug = str_slug($data['name']);
                    $page->created_by = 1;
                    $page->save();
                
                }
                
            }, $getLocaterListDataNew['data']);
        }
        return response()->json([
            'status' => 'success',
            'data' => 'Updated Sucessfully'
        ]);
    }


    public function getCity(){
        $file = Storage::disk('public')->exists('city.json');
        $body = Storage::get('city.json');
        $cityData = json_decode($body, true);
        foreach($cityData as $data){
            $city = new City;
            $city->name = $data['name'];
            $city->state = $data['state'];
            $city->save();
        }
        return response()->json([
            'status' => 'success',
            'data' => 'Updated Sucessfully'
        ]);
    }

}