<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminController;
use App\User;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;

class UserController extends AdminController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->record_per_page=10;
    }

    public function userslist(Request $request) {
        $admin_id = $request->session()->get('id');
        $pageNo = trim($request->input('page', 1));
        DB::enableQueryLog();
        $keyword = strtolower(trim($request->input('keyword')));
        //$group = strtolower(trim($request->input('group')));
        $field_name = strtolower(trim($request->input('field_name'))); 
        $order_by = strtolower(trim($request->input('order_by'))); 
        $usersList = User::where('users.email', '!=', '')->where('users.status', '=', '1');
        $count = User::where('users.email', '!=', '')->where('users.status', '=', '1')->count();
        if($keyword)
        {
            $usersList = $usersList->where(function ($query) use ($keyword) {
            $query->orwhere('users.name', 'like', '%'.$keyword);
            $query->orwhere('users.email', 'like', '%'.$keyword);
            });
        }
        
        $this->data['records'] = $usersList->sortable(['id'=>'desc'])->paginate($this->record_per_page);
        $queries = DB::getQueryLog();
        //dd($queries);
        return view('admin.users.users_mng', ['data' => $this->data,'pageNo' => @$pageNo, 'record_per_page' => $this->record_per_page,'request'=>$request]);
    }

    /**
    * Function add_user
    *
    * function to add user
    *
    * @Created Date: 27 June,2019
    * @Modified Date: 27 June,2019
    * @param  ARRAY
    * @return STRING
    */
    public function add_user(Request $request, $id = '') {
        $data = array();
        if(!empty($id)){
            $data = User::find($id);
        }
        if ($request->all()) { //post
            //dd($request->all());
            $email = strtolower(trim($request->email)); 
            $name = strtolower(trim($request->name));
            $new_password = trim($request->new_password);
            $confirm_password = trim($request->confirm_password);
            
            if ($id) {
                //Validate the input
                $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    'email' => 'required|email',
                ]);
                $messages = $validator->messages();
            }else {
                //Validate the input
                $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    'email' => 'required|email|unique:users,email,null,null,id,!'.$id,
                ]);
            }
            if ($validator->fails()) {
                if($id) {
                   return redirect()->route('admin-edituser',['id'=>$id])
                            ->withErrors($validator)
                            ->withInput(); 
                } else {
                    return redirect()->route('admin-adduser')
                            ->withErrors($validator)
                            ->withInput();
                }
            } else {
                if ($id) { //update case
                    $user = User::find($id);
                    if($new_password)
                        $user->password = Hash::make($new_password);
                } else {
                    if(!$new_password)
                        $password = _makePassword(6);
                    else
                    $password = $new_password;
                    $user = new User;
                    $user->password = Hash::make($password);
                }
                $user->name = $name;
                $user->email = strtolower($email);
                $user->save();
                if ($id  && empty($request->new_password)) {
                    $msg = 'User has been updated successfully.';
                    $request->session()->flash('add_message', $msg);
                    return redirect()->route('admin-users');
                } else if (!empty($id) && !empty($request->new_password)){
                    try{
                        //Mail::to('info@clixmedia.io')->send(new SendMailable($request));
                        //Mail::to($request->email)->send(new SendMailableNewUser($request));
                        $msg = 'User has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin-users');
                    }
                    catch(\Exception $e){
                        //
                    
                    }
                } else {
                ######### Here I am creating a Agency user with all privillages ######
                    try{
                        //Mail::to($request->email)->send(new SendMailableNewUser($request));
                        $msg = 'User has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin-users');
                    }
                    catch(\Exception $e){
                        //
                    }
                }
            }
        }
        else {
            return view('admin.users.add_user', ['data' => $data, 'request' => $request]);
        }
    }

    public function user_delete($id, Request $request) {
        if ($id) {
            $user = User::find($id);
            $user->status = '0';
            if($user->save()){
                $msg = 'User has been deleted successfully.';
                $request->session()->flash('message', $msg);
            }
        }
        return redirect()->route('admin-users');
    }

}