<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class Offer extends Model
{
    use Notifiable;
    use Sortable;

    protected $primaryKey = 'id';
    protected $table = 'offers';

    public $sortable = ['id',
                        'locater_id',
                        'offer_name',
                        'start_date',
                        'end_date',
                        'offer_type',
                        'offer_link',
                        'offer_image',
                        'created_at',
                        'updated_at'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'offer_name', 'start_date','end_date','offer_type','status','locater_id',
    ];

    public function locaterlists()
    {
        return $this->hasone('App\Locater','id','locater_id')->select('*');
    }

    public function fetchCreatedByUser()
    {
        return $this->hasone('App\User','id','created_by')->select('*');
    }

    public function fetchModifiedByUser()
    {
        return $this->hasone('App\User','id','modified_by')->select('*');
    }

    
    
}
