<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*Route::get('/', function () {
    return view('welcome');
});*/

Route::any('/', 'SearchController@index')->name('search');
Route::any('/searchlocator', 'SearchController@searchlocator')->name('searchlocator');
Route::get('autocomplete', 'SearchController@autocomplete')->name('autocomplete');
Route::any('/detail/{slug}', 'SearchController@detail')->name('detail');

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

//Auth::routes();

//Route::get('/home', 'HomeController@index')->name('home');


Route::any('/check_email', 'HomeController@check_email')->name('check_email');
Route::any('/check_locater_id_url', 'HomeController@check_locater_id_url')->name('check_locater_id_url');

Route::group(['middleware' => ['auth'], 'prefix' => 'admin', 'namespace' => 'Admin'], function () {
    /* For manage users */
    Route::get('/dashboard', 'AdminController@index')->name('admin-dashboard');
    Route::any('/users', 'UserController@userslist')->name('admin-users');
    Route::any('/add-user', 'UserController@add_user')->name('admin-adduser');
    Route::any('/users/user_edit/{id}', 'UserController@add_user')->name('admin-usersedit');
    Route::get('/user_delete/{id}', 'UserController@user_delete')->name('admin-deleteuser');

    /* For manage locaters */
    Route::any('/locaters', 'LocaterController@locaterslist')->name('admin-locaters');
    Route::any('/add-locater', 'LocaterController@add_locater')->name('admin-addlocater');
    Route::any('/locaters/locater_edit/{id}', 'LocaterController@add_locater')->name('admin-locatersedit');
    Route::get('/locater_delete/{id}', 'LocaterController@locater_delete')->name('admin-deletelocater');

    /* For manage pages */
    Route::any('/pages', 'PageController@pageslist')->name('admin-pages');
    Route::any('/add-page', 'PageController@add_page')->name('admin-addpage');
    Route::any('/pages/page_edit/{id}', 'PageController@add_page')->name('admin-pagesedit');
    Route::get('/page_delete/{id}', 'PageController@page_delete')->name('admin-deletepage');

    /* For manage offers */
    Route::any('/offers', 'OfferController@offerslist')->name('admin-offers');
    Route::any('/add-offer', 'OfferController@add_offer')->name('admin-addoffer');
    Route::any('/offers/offer_edit/{id}', 'OfferController@add_offer')->name('admin-offersedit');
    Route::get('/offer_delete/{id}', 'OfferController@offer_delete')->name('admin-deleteoffer');

    /* For manage homepages */
    Route::any('/homepages', 'HomepageController@homepageslist')->name('admin-homepages');
    Route::any('/add-homepage', 'HomepageController@add_homepage')->name('admin-addhomepage');
    Route::any('/homepages/homepage_edit/{id}', 'HomepageController@add_homepage')->name('admin-homepagesedit');
    Route::get('/homepage_delete/{id}', 'HomepageController@homepage_delete')->name('admin-deletehomepage');

});
