@extends('layouts.frontend')

@section('content')
    <section class="container-fluid hero-space">
        <picture>
            <?php $detailBannerImage = asset('storage/'.$pageData->banner_image); ?>
            <source media="(max-width: 767px)" srcset="<?php echo $detailBannerImage; ?>">
            <img src="{{ $detailBannerImage }}" alt="Flowers" style="width:auto;">
        </picture>
    </section>
    <section class="container address-box">

        <section class="address-box_inner">
            <h2 class="title">{{ $locationDetailAPIdata->data->name }}</h2>
            <span class="ratings">
                        <i class="mdi mdi-star"></i>
                        <i class="mdi mdi-star"></i>
                        <i class="mdi mdi-star"></i>
                        <i class="mdi mdi-star"></i>
                        <i class="mdi mdi-star-outline"></i>
                        <span class="counts">{{ $locationDetailAPIdata->data->averageRating }}</span>
            </span>
            <div class="share dropdown">
                <span class="share-btn" id="address-box_social" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-share-variant icon-grey"></i></span>
                <div class="share-option dropdown-menu dropdown-menu-right" aria-labelledby="address-box_social">
                    <ul>
                        <li><a href="#"><i class="mdi mdi-facebook-box"></i> Facebook</a></li>
                        <li><a href="#"><i class="mdi mdi-twitter-box"></i> Twitter</a></li>
                        <li><a href="#"><i class="mdi mdi-whatsapp"></i> Whatsapp</a></li>

                    </ul>
                </div>
            </div>
            <div class="row">
                <div class="col-md-5">
                    <p>
                    {{ $locationDetailAPIdata->data->fullAddress->addressLines[0] }}
                    <br>
                    {{ $locationDetailAPIdata->data->fullAddress->addressLines[1] }}
                    @if(!empty($locationDetailAPIdata->data->fullAddress->addressLines[2]))
                    <br>
                    {{ $locationDetailAPIdata->data->fullAddress->addressLines[2] }}
                    @endif
                    </p>
                </div>
                <div class="col-md-3 ">
                    <p class="d-flex align-items-center"><i class="mdi mdi-phone icon-grey mr-3"></i>
                    {{ $locationDetailAPIdata->data->phone }}</p>
                </div>
                <div class="col-md-4 ">
                    <p class="dropdown d-flex align-items-center" id="address-box_openinghours" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-clock icon-grey mr-3"></i>Open Now<i class="mdi mdi-chevron-down icon-grey ml-2"></i></p>
                    <div class="openinghours dropdown-menu" aria-labelledby="address-box_openinghours">
                        <ul>
                            @foreach($locationDetailAPIdata->data->regularHours as $regularHours)
                            <li>
                            <span>{{ $regularHours->openDay }}</span> 
                            {{ $regularHours->openTime }} am - {{ $regularHours->closeTime }} pm
                            </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </section>

    </section>
    <section class="container-fluid about">
        <div class="row">
            <div class="col-12">
                <div class="content">

                    <h2 class="title">About Global Desi</h2>
                    <div class="content_paragraph">
                        <p>Founded in 1995 by Anita Dongre, Meena Sehra and Mukesh Sawlani, House of Anita Dongre Limited is one of India’s leading fashion houses today—a well-recognised, well-respected and well-loved name. The company owns and operates four brands each with their own distinct identity. AND with its line of chic contemporary western wear for women; Global Desi, a vibrant and free-spirited brand of boho-chic ensembles; Anita Dongre offering exquisite bridal couture and a prêt line for men & women along with Pinkcity, handcrafted jadau jewellery; and Grassroot by Anita Dongre which is a tribute to the handcrafted traditions of India, seeking to revive and sustain heirloom traditions and empower artisans in villages.</p>
                    </div>


                </div>
            </div>
        </div>
    </section>


    <section class="container offer">
                <div class="row">
            <div class="col-md-12">
                <h2 class="title">
                    You may also like...
                </h2>
            </div>
     
        </div>
        <div class="row">
            <div class="col-12">
                <div class="offer_slider">
                    <div class="offer_slider-item">
                        <figure><img src="/vendor/frontend/img/poduct_img01.png" alt=""></figure>
                    </div>
                    <div class="offer_slider-item">
                        <figure><img src="/vendor/frontend/img/poduct_img02.png" alt=""></figure>
                    </div>
                    <div class="offer_slider-item">
                        <figure><img src="/vendor/frontend/img/poduct_img03.png" alt=""></figure>
                    </div>
                    <div class="offer_slider-item">
                        <figure><img src="/vendor/frontend/img/poduct_img04.png" alt=""></figure>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <section class="container offering">
    </section>
    <section class="container-fluid location_onmap ">
        <div class="row no-gutters">
            <div class="col-12">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d56122.436645511465!2d77.04168293906328!3d28.459896286104527!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x390d19222ad79e2f%3A0xa2f7eb98f5f013a!2sGlobal+Desi+-+Ladies+Fashion+Wear+Store%2C+Metropolitan+Mall%2C+Gurgaon!5e0!3m2!1sen!2sin!4v1560839450107!5m2!1sen!2sin" width="100%" height="450" frameborder="0" style="border:0" allowfullscreen></iframe>
            </div>
        </div>
    </section>
    <section class="container promotion-wrapper">
        <div class="row">
            <div class="col-12">
                <section class="promotion-wrapper-items">
                    <div class="item">
                        <figure><img src="/vendor/frontend/img/promotion/shopping.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                    <div class="item">
                        <figure><img src="/vendor/frontend/img/promotion/shopping2.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                    <div class="item">
                        <figure><img src="/vendor/frontend/img/promotion/shopping3.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                    <div class="item">
                        <figure><img src="/vendor/frontend/img/promotion/shopping.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                    <div class="item">
                        <figure><img src="/vendor/frontend/img/promotion/shopping2.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                    <div class="item">
                        <figure><img src="/vendor/frontend/img/promotion/shopping3.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                </section>
            </div>
        </div>
    </section>
    <section class="container location_reviews_outer">
        <div class="row ">
            <div class="col-md-8 col-12">
                <section class="location_reviews">
                    <h5 class="title">Reviews</h5>
                    <div class="row location_reviews-head">
                        <div class="col-sm-6 col-12 text-center">
                            <div class="average">
                                4.5
                            </div>
                            <span class="ratings">
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star-outline"></i>
                                    <span class="counts">(20)</span>
                            </span>
                        </div>
                        <div class="col-sm-6 col-12 location_reviews-rb">
                            <div class="row">
                                <div class="col-2"><i class="mdi mdi-star"></i> 5</div>
                                <div class="col-8">
                                    <div class="progress">
                                        <div class="progress-bar cr5" role="progressbar" style="width: 85%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                <div class="col-2">19</div>
                            </div>
                            <div class="row">
                                <div class="col-2"><i class="mdi mdi-star"></i> 4</div>
                                <div class="col-8">
                                    <div class="progress">
                                        <div class="progress-bar cr4" role="progressbar" style="width: 55%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                <div class="col-2">9</div>
                            </div>
                            <div class="row">
                                <div class="col-2"><i class="mdi mdi-star"></i> 3</div>
                                <div class="col-8">
                                    <div class="progress">
                                        <div class="progress-bar cr3" role="progressbar" style="width: 45%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                <div class="col-2">4</div>
                            </div>
                            <div class="row">
                                <div class="col-2"><i class="mdi mdi-star"></i> 2</div>
                                <div class="col-8">
                                    <div class="progress">
                                        <div class="progress-bar cr2" role="progressbar" style="width: 35%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                <div class="col-2">7</div>
                            </div>
                            <div class="row">
                                <div class="col-2"><i class="mdi mdi-star"></i> 1</div>
                                <div class="col-8">
                                    <div class="progress">
                                        <div class="progress-bar cr1" role="progressbar" style="width: 15%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                <div class="col-2">4</div>
                            </div>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="dropdown mb-3">
                                <div class="btn btn-secondary dropdown-toggle custom-dropdown" id="reviewbyfilter" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Most relevant
                                </div>
                                <div class="dropdown-menu" aria-labelledby="reviewbyfilter">
                                    <a class="dropdown-item" href="javascript:void(0);">Most relevant</a>
                                    <a class="dropdown-item" href="javascript:void(0);">Newest</a>
                                    <a class="dropdown-item" href="javascript:void(0);">Highest rating</a>
                                    <a class="dropdown-item" href="javascript:void(0);">Lowest rating</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 card-columns">
                            <article class="card">
                                <div class="card-body">
                                    <p class="rev-name">Ankur Garg</p>
                                    <figure class="rev-img"><img src="/vendor/frontend/img/reviewer-1.png"></figure>
                                    <p><span class="ratings">
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star-outline"></i>
                                            <span class="timestamp">1 month ago</span>
                                        </span>
                                    </p>
                                    <p class="rev-text">If one needs to buy cotton clothes for women, this is the brand which has made a unique place in it. With stores full of clothes, one definitely gets from Indian, Western to Indo Western styles here. Prices are affordable. Sale is a must watch catch. </p>
                                </div>
                            </article>
                            <article class="card">
                                <div class="card-body">
                                    <p class="rev-name">Ankur Garg</p>
                                    <figure class="rev-img"><img src="/vendor/frontend/img/reviewer-3.png"></figure>
                                    <p><span class="ratings">
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star-outline"></i>
                                                <span class="timestamp">1 month ago</span>
                                        </span>
                                    </p>
                                    <p class="rev-text">If one needs to buy cotton clothes for women, this is the brand which has made a unique place in it. With stores full of clothes, one definitely gets from Indian, Western to Indo Western styles here. Prices are affordable. Sale is a must watch catch. </p>
                                </div>
                            </article>
                            <article class="card">
                                <div class="card-body">
                                    <p class="rev-name">Ankur Garg</p>
                                    <figure class="rev-img"><img src="/vendor/frontend/img/reviewer-2.png"></figure>
                                    <p><span class="ratings">
                                                    <i class="mdi mdi-star"></i>
                                                    <i class="mdi mdi-star"></i>
                                                    <i class="mdi mdi-star"></i>
                                                    <i class="mdi mdi-star"></i>
                                                    <i class="mdi mdi-star-outline"></i>
                                                    <span class="timestamp">1 month ago</span>
                                        </span>
                                    </p>
                                    <p class="rev-text">If one needs to buy cotton clothes for women, this is the brand which has made a unique place in it. With stores full of clothes, one definitely gets from Indian, Western to Indo Western styles here. Prices are affordable. Sale is a must watch catch. </p>
                                </div>
                            </article>
                            <article class="card">
                                <div class="card-body">
                                    <p class="rev-name">Ankur Garg</p>
                                    <figure class="rev-img"><img src="/vendor/frontend/img/reviewer-3.png"></figure>
                                    <p><span class="ratings">
                                                        <i class="mdi mdi-star"></i>
                                                        <i class="mdi mdi-star"></i>
                                                        <i class="mdi mdi-star"></i>
                                                        <i class="mdi mdi-star"></i>
                                                        <i class="mdi mdi-star-outline"></i>
                                                        <span class="timestamp">1 month ago</span>
                                        </span>
                                    </p>
                                    <p class="rev-text">If one needs to buy cotton clothes for women, this is the brand which has made a unique place in it. With stores full of clothes, one definitely gets from Indian, Western to Indo Western styles here. Prices are affordable. Sale is a must watch catch. </p>
                                </div>
                            </article>
                            <article class="text-center">
                                <button class="btn btn-secondary" type="button" disabled>
                                            <span class="spinner-grow spinner-grow-sm" role="status" aria-hidden="true"></span>
                                            Loading...
                                          </button>
                            </article>
                        </div>
                    </div>

                </section>
            </div>
            <div class="col-md-4 col-12">
                <aside class="nearby_locations">
                    <h5 class="title">
                        Nearby Global Desi Store Locator's
                    </h5>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="title">Global Desi - Women Clothing Store</h5>
                            <span class="ratings">
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star-outline"></i>
                                    <span class="counts">(20)</span>
                            </span>
                            <p class="address">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</p>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="title">Global Desi - Women Clothing Store</h5>
                            <span class="ratings">
                                        <i class="mdi mdi-star"></i>
                                        <i class="mdi mdi-star"></i>
                                        <i class="mdi mdi-star"></i>
                                        <i class="mdi mdi-star"></i>
                                        <i class="mdi mdi-star-outline"></i>
                                        <span class="counts">(20)</span>
                            </span>
                            <p class="address">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</p>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="title">Global Desi - Women Clothing Store</h5>
                            <span class="ratings">
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star-outline"></i>
                                            <span class="counts">(20)</span>
                            </span>
                            <p class="address">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</p>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="title">Global Desi - Women Clothing Store</h5>
                            <span class="ratings">
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star-outline"></i>
                                                <span class="counts">(20)</span>
                            </span>
                            <p class="address">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</p>
                        </div>
                    </div>

                </aside>
            </div>
        </div>

    </section>
    @endsection