<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Homepage;
use App\Helpers\Apihelpers;
use GuzzleHttp\Client;
use App\Locater;
use App\Page;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;


class SearchController extends Controller
{
    use Apihelpers;
    //public $locationDeatilAPIdata;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
        $this->record_per_page=10;
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        $api_url = getenv('API_LIST');
        $locatorApiData = $this->call_api('',$api_url);
        //$locatorApiData = $locationDeatilAPIdata;
        $locaterkeyvalueddata = Locater::where('status', '=', '1')->with('page')->get()->pluck('page.slug', 'locater_id_url');
        $homepage = Homepage::where('homepages.status', '=', '1')->first();
        return view('frontend.searchs.index', ['homepage' => $homepage,'locatorApiData'=>$locatorApiData,'locaterkeyvalueddata'=>$locaterkeyvalueddata]);
    }

    public function searchlocator(Request $request)
    {
        $api_url = getenv('API_LIST');
        $locationDetailAPIdata = $this->call_api($request->locality,$api_url);
        $locaterkeyvalueddata = Locater::where('status', '=', '1')->with('page')->get()->pluck('page.slug', 'locater_id_url');
        $homepage = Homepage::where('homepages.status', '=', '1')->first();
        $datanew = '';
        foreach($locationDetailAPIdata->data as $key=>$data){ 
            $link = '';
            if(isset($locaterkeyvalueddata[$data->id])){
                $link = $locaterkeyvalueddata[$data->id];    
            }
            $datanew .= '<div class="card"><div class="card-body"><div class="location_data-img"><img src="vendor/frontend/img/location-img.png" /></div><div class="location_data-content"><h5 class="title"><a href="/detail/'.$link.'">'.$data->name.'</a></h5><span class="ratings"><i class="mdi mdi-star"></i><i class="mdi mdi-star"></i><i class="mdi mdi-star"></i><i class="mdi mdi-star"></i><i class="mdi mdi-star-outline"></i><br><span class="counts">'.$data->reviewCounts.'</span></span><p class="address">'.$data->fullAddress->addressLines[0].'</p></div></div></div>';
        }
        return $datanew;
    }

    public function detail(Request $request, $slug = '') {
        $pageData = Page::where('pages.slug', '=', $slug)->with('locaterlists')->first();
        /*Fetch Locater ID*/ 
        $locatorID = $pageData->locaterlists->locater_id_url;
        $api_url = getenv('API_LOCATION');
        $locationDetailAPIdata = $this->call_api($locatorID,$api_url);
        $homepage = Homepage::where('homepages.status', '=', '1')->first();
        return view('frontend.searchs.detail', ['homepage' => $homepage,'locationDetailAPIdata'=>$locationDetailAPIdata, 'pageData' => $pageData]);
    }

    public function autocomplete(Request $request)
    {
        $api_url = getenv('API_SEARCH');
        $locationDetailAPIdata = $this->call_api($request['query'],$api_url);    
        $output = '<ul class="dropdown-menu" style="display:block; position:relative">';
        foreach($locationDetailAPIdata->data as $row){
            $output .= '<li><i class="mdi mdi-map-marker"></i><a href="#">'.$row->name.'</a></li>';
        }
        $output .= '</ul>';
        echo $output;
        //return response()->json($data);
    }

    
    
    
}
