<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminController;
use App\LocaterFeed;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;

class FeedController extends AdminController
{
    const RECORD_PER_PAGE = 10;

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function feedsList(Request $request) {
        $admin_id = $request->session()->get('id');

        $pageNo = trim($request->input('page', 1));

        DB::enableQueryLog();

        $keyword = strtolower(trim($request->input('keyword')));
        $feedList = LocaterFeed::where('locater_feeds.is_deleted', '=', '0');
        $count = LocaterFeed::where('locater_feeds.is_deleted', '=', '0')->count();
        
        if($keyword)
        {
            $feedList = $feedList->where(function ($query) use ($keyword) {
                $query->orwhere('locater_feeds.title', 'like', '%'.$keyword);
            });
        }
        
        $this->data['records'] = $feedList->sortable(['id'=>'desc'])->paginate(Self::RECORD_PER_PAGE);
        
        $queries = DB::getQueryLog();
        
        return view('admin.feeds.feeds_mng', ['data' => $this->data,'pageNo' => @$pageNo, 'record_per_page' => Self::RECORD_PER_PAGE,'request'=>$request]);
    }

    public function createFeed(){
        return view('admin.feeds.add');
    }

    public function saveFeed(Request $request) {
        $user_id = auth()->user('id');
        
        if ($request->all()) { 
        
            $feeds_id = trim($request->feeds_id);
            $title = trim($request->title);
            $description = trim($request->description);
            $gtin = trim($request->gtin);
            $brand = trim($request->brand);
            $color = trim($request->color);
            $size = trim($request->size);
            $link = trim($request->link);
            $image_link = trim($request->image_link);
            $availability = trim($request->availability);
            $product_condition = trim($request->product_condition);
            $item_group_id = trim($request->item_group_id);
            $google_product_category = trim($request->google_product_category);
            $product_type = trim($request->product_type);
            $sale_price = trim($request->sale_price);
            $price = trim($request->price);
            $status = trim($request->status);
            
            $validator = Validator::make($request->all(), [
                'feeds_id' => 'required',
                'title' => 'required',
                'description' => 'required',
                'gtin' => 'required',
                'brand' => 'required',
                'color' => 'required',
                'size' => 'required',
                'link' => 'required',
                'image_link' => 'required',
                'availability' => 'required',
                'product_condition' => 'required',
                'item_group_id' => 'required',
                'google_product_category' => 'required',
                'product_type' => 'required',
                'sale_price' => 'required',
                'price' => 'required',
                'status' => 'required',
            ]);

            if ($validator->fails()) 
            {
                return redirect()->route('admin.feeds.add')
                            ->withErrors($validator)
                            ->withInput();
            } 
            else 
            {
                $feed = new LocaterFeed;
                $feed->feeds_id = $feeds_id;
                $feed->title = $title;
                $feed->description = $description;
                $feed->gtin = $gtin;
                $feed->brand = $brand;
                $feed->color = $color;
                $feed->size = $size;
                $feed->link = $link;
                $feed->image_link = $image_link;
                $feed->availability = $availability;
                $feed->product_condition = $product_condition;
                $feed->item_group_id = $item_group_id;
                $feed->google_product_category = $google_product_category;
                $feed->product_type = $product_type;
                $feed->sale_price = $sale_price;
                $feed->price = $price;
                $feed->status = $status;
                $feed->save();
                
                $msg = 'Feed has been added successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.feeds');
            }
        }
    }

    public function editFeed(Request $request, $id){
        if(!empty($id)){
            $data = LocaterFeed::find($id);
        }
        return view('admin.feeds.edit', compact(array('data')));
    }

    public function updateFeed(Request $request, $id) {
        $user_id = auth()->user('id');
        $data = array();
        if(!empty($id)){
            $data = LocaterFeed::find($id);
        }
        if ($request->all()) { 
            
            $feeds_id = trim($request->feeds_id);
            $title = trim($request->title);
            $description = trim($request->description);
            $gtin = trim($request->gtin);
            $brand = trim($request->brand);
            $color = trim($request->color);
            $size = trim($request->size);
            $link = trim($request->link);
            $image_link = trim($request->image_link);
            $availability = trim($request->availability);
            $product_condition = trim($request->product_condition);
            $item_group_id = trim($request->item_group_id);
            $google_product_category = trim($request->google_product_category);
            $product_type = trim($request->product_type);
            $sale_price = trim($request->sale_price);
            $price = trim($request->price);
            $status = trim($request->status);
            
            $validator = Validator::make($request->all(), [
                'feeds_id' => 'required',
                'title' => 'required',
                'description' => 'required',
                'gtin' => 'required',
                'brand' => 'required',
                'color' => 'required',
                'size' => 'required',
                'link' => 'required',
                'image_link' => 'required',
                'availability' => 'required',
                'product_condition' => 'required',
                'item_group_id' => 'required',
                'google_product_category' => 'required',
                'product_type' => 'required',
                'sale_price' => 'required',
                'price' => 'required',
                'status' => 'required',
            ]);
            
            if ($validator->fails()) {
                return redirect()->route('admin.feeds.edit',['id'=>$id])
                            ->withErrors($validator)
                            ->withInput();
            } else {

                $feed = LocaterFeed::find($id);
                $feed->feeds_id = $feeds_id;
                $feed->title = $title;
                $feed->description = $description;
                $feed->gtin = $gtin;
                $feed->brand = $brand;
                $feed->color = $color;
                $feed->size = $size;
                $feed->link = $link;
                $feed->image_link = $image_link;
                $feed->availability = $availability;
                $feed->product_condition = $product_condition;
                $feed->item_group_id = $item_group_id;
                $feed->google_product_category = $google_product_category;
                $feed->product_type = $product_type;
                $feed->sale_price = $sale_price;
                $feed->price = $price;
                $feed->status = $status;
                $feed->save();

                $msg = 'Feed has been updated successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.feeds');
            }
        }
        else {
            return view('admin.feeds.add', ['data' => $data, 'request' => $request]);
        }
    }

    
    public function deleteFeed($id, Request $request) {
        if ($id) {
            $feed = LocaterFeed::find($id);
            $feed->is_deleted = '1';
            if($feed->save()){
                $msg = 'Feed has been deleted successfully.';
                $request->session()->flash('message', $msg);
            }
        }
        return redirect()->route('admin.feeds');
    }

}