@extends('layouts.frontend')

@section('content')
    <section class="searchbar container-fluid">
        <div class="row">
            <div class="col-md-10 col-lg-9 col-12">
                <form id="search-mng" method="POST" action="{{route('search')}}">
                {{ csrf_field() }}
                    <div class="searchbar_form">
                        <div class="searchfield">
                            <div class="os"><i class="mdi mdi-magnify"></i>
                                <input type="text" class="form-control locality" autocomplete="off" name="locality" placeholder="--Search Nearby--">
                                <div id="localitylist"></div>
                            </div>
                        </div>

                        <div class="or">OR</div>
                        <div class="select">
                            <select class="form-control">
                                    <option>State</option>
                              </select>
                        </div>
                        <div class="select">
                            <select class="form-control">
                                        <option>City</option>
                                  </select>
                        </div>
                        <div class="select">
                            <input type="text" class="form-control" placeholder="Location">
                        </div>
                        <div class="action">
                            <input type="button" id="searchbutton" value="Submit" class="btn btn-primary">
                        </div>
                    </div>
                </form>

            </div>
            <div class="m-options col-6"> <span class="btn" data-show="Show more" data-less="Show less"><span class="txt" >Show more </span><i class="mdi mdi-chevron-down"></i></span>
            </div>
            <div class="col-md-2 col-lg-3 col-6 text-right">
                <div class="data-view-type">
                    <div class="map btn active"><i class="mdi mdi-map-marker"></i></div>
                    <div class="list btn"><i class="mdi mdi-view-module"></i></div>
                </div>
            </div>
        </div>

    </section>
    <section class="container-fluid location_data no-pb">
        <div class="row ">
            <aside class="col-md-5 col-lg-3 location_data-lw">
                <!--search count and filter start-->
                <div class="row result_head">
                    <div class="col-6">
                        <span class="result_head-counts">
                        <?php $totalFoundLocation = count($finalData); ?>
                        {{ $totalFoundLocation }} locations found</span>
                    </div>
                    <div class="col-6 text-right">
                        <div class="dropdown">
                            <div class="btn btn-secondary dropdown-toggle custom-dropdown" id="reviewbyfilter" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                Most relevant
                            </div>
                            <div class="dropdown-menu" aria-labelledby="reviewbyfilter">
                                <a class="dropdown-item" href="javascript:void(0);">Most relevant</a>
                                <a class="dropdown-item" href="javascript:void(0);">Newest</a>
                                <a class="dropdown-item" href="javascript:void(0);">Highest rating</a>
                                <a class="dropdown-item" href="javascript:void(0);">Lowest rating</a>
                            </div>
                        </div>
                    </div>
                </div>
                <!--location listing start-->
                <div class="row no-gutters">
                    <div class=" mt-4 location_data-listing" id="searchlocaterid">
                        <?php 
                        foreach($finalData as $key=>$data){ 
                            /*$link = '';
                            if(isset($locaterkeyvalueddata[$data->id])){
                                $link = $locaterkeyvalueddata[$data->id];    
                            }*/
                            ?>
                            <div class="card">
                                <div class="card-body">
                                    <div class="location_data-img">
                                        <img src="vendor/frontend/img/location-img.png" />
                                    </div>
                                    <div class="location_data-content">
                                        <h5 class="title"><a href="{{route('detail',['slug'=>$data['slug']])}}"><?php echo $data['name']; ?></a></h5>
                                        <span class="ratings">
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star-outline"></i>
                                            <br>
                                            <span class="counts">({{ $data['reviewCounts'] }})</span>
                                        </span>
                                        <p class="address">
                                        <?php echo $data['fullAddress']['addressLines'][0]; ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <!--<div class="card">
                            <div class="card-body">
                                <div class="location_data-img">
                                    <img src="vendor/frontend/img/location-img.png" />
                                </div>
                                <div class="location_data-content">
                                    <h5 class="title"><a href="location.html">Global Desi - Women Clothing Store</a></h5>
                                    <span class="ratings">
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star"></i>
                                                <i class="mdi mdi-star-outline"></i>
                                                <span class="counts">(20)</span>
                                    </span>
                                    <p class="address"><a href="location.html">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</a></p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-body">
                                <div class="location_data-img">
                                    <img src="vendor/frontend/img/location-img.png" />
                                </div>
                                <div class="location_data-content">
                                    <h5 class="title"><a href="location.html">Global Desi- Women Clothing Store</a></h5>
                                    <span class="ratings">
                                                    <i class="mdi mdi-star"></i>
                                                    <i class="mdi mdi-star"></i>
                                                    <i class="mdi mdi-star"></i>
                                                    <i class="mdi mdi-star"></i>
                                                    <i class="mdi mdi-star-outline"></i>
                                                    <span class="counts">(20)</span>
                                    </span>
                                    <p class="address"><a href="location.html">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</a></p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-body">
                                <div class="location_data-img">
                                    <img src="vendor/frontend/img/location-img.png" />
                                </div>
                                <div class="location_data-content">
                                    <h5 class="title"><a href="location.html">Global Desi - Women Clothing Store</a></h5>
                                    <span class="ratings">
                                                        <i class="mdi mdi-star"></i>
                                                        <i class="mdi mdi-star"></i>
                                                        <i class="mdi mdi-star"></i>
                                                        <i class="mdi mdi-star"></i>
                                                        <i class="mdi mdi-star-outline"></i>
                                                        <span class="counts">(20)</span>
                                    </span>
                                    <p class="address"><a href="location.html">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</a></p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-body">
                                <div class="location_data-img">
                                    <img src="vendor/frontend/img/location-img.png" />
                                </div>
                                <div class="location_data-content">
                                    <h5 class="title"><a href="location.html">Global Desi - Women Clothing Store</a></h5>
                                    <span class="ratings">
                                                            <i class="mdi mdi-star"></i>
                                                            <i class="mdi mdi-star"></i>
                                                            <i class="mdi mdi-star"></i>
                                                            <i class="mdi mdi-star"></i>
                                                            <i class="mdi mdi-star-outline"></i>
                                                            <span class="counts">(20)</span>
                                    </span>
                                    <p class="address"><a href="location.html">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</a></p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-body">
                                <div class="location_data-img">
                                    <img src="vendor/frontend/img/location-img.png" />
                                </div>
                                <div class="location_data-content">
                                    <h5 class="title"><a href="location.html">Global Desi - Women Clothing Store</a></h5>
                                    <span class="ratings">
                                                                <i class="mdi mdi-star"></i>
                                                                <i class="mdi mdi-star"></i>
                                                                <i class="mdi mdi-star"></i>
                                                                <i class="mdi mdi-star"></i>
                                                                <i class="mdi mdi-star-outline"></i>
                                                                <span class="counts">(20)</span>
                                    </span>
                                    <p class="address"><a href="location.html">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</a></p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-body">
                                <div class="location_data-img">
                                    <img src="vendor/frontend/img/location-img.png" />
                                </div>
                                <div class="location_data-content">
                                    <h5 class="title"><a href="location.html">Global Desi - Women Clothing Store</a></h5>
                                    <span class="ratings">
                                                                    <i class="mdi mdi-star"></i>
                                                                    <i class="mdi mdi-star"></i>
                                                                    <i class="mdi mdi-star"></i>
                                                                    <i class="mdi mdi-star"></i>
                                                                    <i class="mdi mdi-star-outline"></i>
                                                                    <span class="counts">(20)</span>
                                    </span>
                                    <p class="address"><a href="location.html">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</a></p>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-body">
                                <div class="location_data-img">
                                    <img src="vendor/frontend/img/location-img.png" />
                                </div>
                                <div class="location_data-content">
                                    <h5 class="title"><a href="location.html">Global Desi - Women Clothing Store</a></h5>
                                    <span class="ratings">
                                                                        <i class="mdi mdi-star"></i>
                                                                        <i class="mdi mdi-star"></i>
                                                                        <i class="mdi mdi-star"></i>
                                                                        <i class="mdi mdi-star"></i>
                                                                        <i class="mdi mdi-star-outline"></i>
                                                                        <span class="counts">(20)</span>
                                    </span>
                                    <p class="address"><a href="location.html">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</a></p>
                                </div>
                            </div>
                        </div>
                    </div>-->

                </div>
                <!--pagination start-->
                <!--<div class="pagination-wrapper justify-content-center">
                    <nav>
                        <ul class="pagination">
                            <li class="page-item">
                                <a class="page-link" href="#" aria-label="Previous">
                                    <i class="mdi mdi-chevron-left"></i>
                                </a>
                            </li>
                            <li class="page-item active"><a class="page-link" href="#">1</a></li>
                            <li class="page-item"><a class="page-link" href="#">2</a></li>
                            <li class="page-item"><a class="page-link" href="#">3</a></li>
                            <li class="page-item">
                                <a class="page-link" href="#" aria-label="Next">
                                    <i class="mdi mdi-chevron-right"></i>
                                </a>
                            </li>
                        </ul>
                    </nav>
                </div>-->
            </aside>
            <div class="col-md-7 col-lg-9 location_data-map"><iframe src="https://www.google.com/maps/embed?pb=!1m16!1m12!1m3!1d56122.436645511465!2d77.04168293906328!3d28.459896286104527!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!2m1!1sanita+dongre!5e0!3m2!1sen!2sin!4v1560423783107!5m2!1sen!2sin" width="100%"
                    frameborder="0" style="border:0" allowfullscreen></iframe></div>
        </div>
    </section>
    <section class="container promotion-wrapper mt-4">
        <div class="row">
            <div class="col-12">
                <section class="promotion-wrapper-items">
                    <div class="item">
                        <figure><img src="vendor/frontend/img/promotion/shopping.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                    <div class="item">
                        <figure><img src="vendor/frontend/img/promotion/shopping2.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                    <div class="item">
                        <figure><img src="vendor/frontend/img/promotion/shopping3.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                    <div class="item">
                        <figure><img src="vendor/frontend/img/promotion/shopping.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                    <div class="item">
                        <figure><img src="vendor/frontend/img/promotion/shopping2.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                    <div class="item">
                        <figure><img src="vendor/frontend/img/promotion/shopping3.png"> </figure>
                        <p class="name">Very me men floral print straight kurta</p>
                        <p class="currency bold">$ 100</p>
                        <p class="publisher">Global Desi</p>
                        <p class="grey-txt">21% price drop</p>
                    </div>
                </section>
            </div>
        </div>
    </section>
    
    <script type="text/javascript">
    
        /*var path = "{{ route('autocomplete') }}";
        $('input.locality').typeahead({
            source:  function (query, process) {
                return $.get(path, { query: query }, function (data) {
                    return process(data);
                });
            }
        });*/

        $(document).ready(function(){
            $('.locality').keyup(function(){
                var query = $(this).val();
                if(query != ''){
                    $.ajax({
                        url: "{{ route('autocomplete') }}",
                        method: "GET",
                        data: {query: query},
                        success:function(data)
                        {
                            $('#localitylist').fadeIn();
                            $('#localitylist').html(data);
                        }
                    })
                }
            });

            $(document).on('click','li', function(){
                $('.locality').val($(this).text());   
                $('#localitylist').fadeOut();               
            });
        });
        $('.locality').focusout(function(){
            $('#localitylist').fadeOut('slow');
        });

        $(function () {
            $('#searchbutton').on('click', function (e) {
            e.preventDefault();
            $.ajax({
                type: 'post',
                url: "{{route('searchlocator')}}",
                data: $('form').serialize(),
                    success: function (datanew) {
                    $( "#searchlocaterid" ).html( datanew );
                }
            });
            });
        });
    </script>

   
    @endsection

    