<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminController;
use App\Locater;
use App\User;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;

class LocaterController extends AdminController
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->record_per_page=10;
    }

    public function locatersList(Request $request) {
        $admin_id = $request->session()->get('id');

        $pageNo = trim($request->input('page', 1));

        DB::enableQueryLog();

        $keyword = strtolower(trim($request->input('keyword')));
        $locaterList = Locater::where('locaters.is_deleted', '=', '0');
        $count = Locater::where('locaters.is_deleted', '=', '0')->count();
        
        if($keyword)
        {
            $locaterList = $locaterList->where(function ($query) use ($keyword) {
                $query->orwhere('locaters.name', 'like', '%'.$keyword);
                $query->orwhere('locaters.locater_identity', 'like', '%'.$keyword);
                $query->orwhere('locaters.description', 'like', '%'.$keyword);
            });
        }
        
        $this->data['records'] = $locaterList->sortable(['id'=>'desc'])->paginate($this->record_per_page);
        
        $queries = DB::getQueryLog();
        
        return view('admin.locaters.locaters_mng', ['data' => $this->data,'pageNo' => @$pageNo, 'record_per_page' => $this->record_per_page,'request'=>$request]);
    }

    public function createLocater(){
        return view('admin.locaters.add');
    }

    public function saveLocater(Request $request) {
        $user_id = auth()->user('id');
        
        if ($request->all()) { 
            
            $name = trim($request->name);
            $locater_identity = trim($request->locater_identity);
            $locater_code = trim($request->locater_code);
            $description = trim($request->description);
            
            $validator = Validator::make($request->all(), [
                'locater_identity' => 'required|unique:locaters,locater_identity,null,null',
                'locater_code' => 'required|unique:locaters,locater_code,null,null',
                'name' => 'required',
                'description' => 'required',
            ]);

            if ($validator->fails()) 
            {
                return redirect()->route('admin.locaters.add')
                            ->withErrors($validator)
                            ->withInput();
            } 
            else 
            {
                $locater = new Locater;
                $locater->created_by = $user_id->id;
                $locater->name = $name;
                $locater->locater_identity = $locater_identity;
                $locater->locater_code = $locater_code;
                $locater->description = $description;
                $locater->save();
                
                $msg = 'Locater has been added successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.locaters');
            }
        }
    }

    public function editLocater(Request $request, $id){
        if(!empty($id)){
            $data = Locater::find($id);
        }
        return view('admin.locaters.edit', compact(array('data')));
    }

    public function updateLocater(Request $request, $id) {
        $user_id = auth()->user('id');
        $data = array();
        if(!empty($id)){
            $data = Locater::find($id);
        }
        if ($request->all()) { 
            
            $name = trim($request->name);
            $locater_identity = trim($request->locater_identity);
            $locater_code = trim($request->locater_code);
            $description = trim($request->description);
            
            $validator = Validator::make($request->all(), [
                'locater_identity' => 'required|unique:locaters,locater_identity,null,null,id,!'.$id,
                'locater_code' => 'required|unique:locaters,locater_code,null,null,id,!'.$id,
                'name' => 'required',
                'description' => 'required',
            ]);
            
            if ($validator->fails()) {
                return redirect()->route('admin.locaters.edit',['id'=>$id])
                            ->withErrors($validator)
                            ->withInput();
            } else {

                $locater = Locater::find($id);
                $modified_by = trim($user_id->id);
                $locater->modified_by = $modified_by;
                $locater->name = $name;
                $locater->locater_identity = $locater_identity;
                $locater->locater_code = $locater_code;
                $locater->description = $description;
                $locater->save();

                $msg = 'Locater has been updated successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.locaters');
            }
        }
        else {
            return view('admin.locaters.add_locater', ['data' => $data, 'request' => $request]);
        }
    }

    
    public function deleteLocater($id, Request $request) {
        if ($id) {
            $locater = Locater::find($id);
            $locater->is_deleted = '1';
            if($locater->save()){
                $msg = 'Locater has been deleted successfully.';
                $request->session()->flash('message', $msg);
            }
        }
        return redirect()->route('admin.locaters');
    }

}