<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminController;
use App\Homepage;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;

class HomepageController extends AdminController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->record_per_page=10;
    }


    public function homepagesList(Request $request) {
        $admin_id = $request->session()->get('id');

        $pageNo = trim($request->input('page', 1));
        
        DB::enableQueryLog();
        
        $homepageList = Homepage::where('homepages.is_deleted', '=', '0');
        $count = Homepage::where('homepages.is_deleted', '=', '0');
        $this->data['records'] = $homepageList->sortable(['id'=>'desc'])->paginate($this->record_per_page);
        $queries = DB::getQueryLog();

        return view('admin.homepages.homepages_mng', ['data' => $this->data,'pageNo' => @$pageNo, 'record_per_page' => $this->record_per_page,'request'=>$request]);
    }

    public function createHomepage(){
        return view('admin.homepages.add');
    }

    public function saveHomepage(Request $request) {
        $user_id = auth()->user('id');
        if ($request->all()) { dd($request->all());
            $header_image_normal = trim($request->header_image_normal);
            $header_image_mobile = trim($request->header_image_mobile);
            $footer_image_normal = trim($request->footer_image_normal);
            $footer_image_mobile = trim($request->footer_image_mobile);
            $created_by = trim($user_id->id);
            $status = trim($request->status);
            $meta_title = trim($request->meta_title);
            $meta_keyword = trim($request->meta_keyword);
            $meta_description = trim($request->meta_description);
            
            $validator = Validator::make($request->all(), [
                'header_image_normal' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'header_image_mobile' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'footer_image_normal' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'footer_image_mobile' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);

            if ($validator->fails()) {
                return redirect()->route('admin.homepages.add')
                            ->withErrors($validator)
                            ->withInput();
            } else {
                $homepage = new Homepage;
                $homepage->created_by = $user_id->id;
                
                if(!empty($request->header_image_normal)){
                    $homepage->header_image_normal = $request->file('header_image_normal')->store('image');
                }
                if(!empty($request->header_image_mobile)){
                    $homepage->header_image_mobile = $request->file('header_image_mobile')->store('image');
                }
                if(!empty($request->footer_image_normal)){
                    $homepage->footer_image_normal = $request->file('footer_image_normal')->store('image');
                }
                if(!empty($request->footer_image_mobile)){
                    $homepage->footer_image_mobile = $request->file('footer_image_mobile')->store('image');
                }
                
                $homepage->status = $status;
                $homepage->meta_title = $meta_title;
                $homepage->meta_keyword = $meta_keyword;
                $homepage->meta_description = $meta_description;
                $homepage->save();

                $msg = 'Homepage has been added successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.homepages');
            }
        }
    }

    public function editHomepage(Request $request, $id){
        if(!empty($id)){
            $data = Homepage::find($id);
        }
        return view('admin.homepages.edit');
    }

    /**
    * Function add_homepage
    *
    * function to add homepage
    *
    * @Created Date: 02 July,2019
    * @Modified Date: 02 July,2019
    * @param  ARRAY
    * @return STRING
    */
    public function add_homepage(Request $request, $id = '') {
        $user_id = auth()->user('id');
        $data = array();
        if(!empty($id)){
            $data = Homepage::find($id);
        }
        if ($request->all()) { //post
            $header_image_normal = trim($request->header_image_normal);
            $header_image_mobile = trim($request->header_image_mobile);
            $footer_image_normal = trim($request->footer_image_normal);
            $footer_image_mobile = trim($request->footer_image_mobile);
            $created_by = trim($user_id->id);
            $status = trim($request->status);
            $meta_title = trim($request->meta_title);
            $meta_keyword = trim($request->meta_keyword);
            $meta_description = trim($request->meta_description);
            
            if ($id) {
                //Validate the input
                $validator = Validator::make($request->all(), [
                    'header_image_normal' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'header_image_mobile' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'footer_image_normal' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'footer_image_mobile' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                ]);
                $messages = $validator->messages();
            }else {
                //Validate the input
                $validator = Validator::make($request->all(), [
                    'header_image_normal' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'header_image_mobile' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'footer_image_normal' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'footer_image_mobile' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                ]);
            }
            if ($validator->fails()) {
                if($id) {
                   return redirect()->route('admin-edithomepage',['id'=>$id])
                            ->withErrors($validator)
                            ->withInput(); 
                } else {
                    return redirect()->route('admin-addhomepage')
                            ->withErrors($validator)
                            ->withInput();
                }
            } else {
                if ($id) { //update case
                    $homepage = Homepage::find($id);//->with('userlists');
                    $modified_by = trim($user_id->id);
                    $homepage->modified_by = $modified_by;
                } else {
                    $homepage = new Homepage;
                    $homepage->created_by = $user_id->id;
                }
                if(!empty($request->header_image_normal)){
                    $homepage->header_image_normal = $request->file('header_image_normal')->store('image');
                }
                if(!empty($request->header_image_mobile)){
                    $homepage->header_image_mobile = $request->file('header_image_mobile')->store('image');
                }
                if(!empty($request->footer_image_normal)){
                    $homepage->footer_image_normal = $request->file('footer_image_normal')->store('image');
                }
                if(!empty($request->footer_image_mobile)){
                    $homepage->footer_image_mobile = $request->file('footer_image_mobile')->store('image');
                }
                
                $homepage->status = $status;
                $homepage->meta_title = $meta_title;
                $homepage->meta_keyword = $meta_keyword;
                $homepage->meta_description = $meta_description;
                $homepage->save();
                if ($id) {
                    $msg = 'Homepage has been updated successfully.';
                    $request->session()->flash('add_message', $msg);
                    return redirect()->route('admin.homepages');
                } else if (!empty($id)){
                    try{
                        $msg = 'Homepage has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin.homepages');
                    }
                    catch(\Exception $e){
                        //
                    
                    }
                } else {
                    try{
                        $msg = 'Homepage has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin.homepages');
                    }
                    catch(\Exception $e){
                        //
                    }
                }
            }
        }
        else {
            return view('admin.homepages.add_homepage', ['data' => $data, 'request' => $request]);
        }
    }

    public function homepage_delete($id, Request $request) {
        if ($id) {
            $homepage = Homepage::find($id);
            $homepage->is_deleted = '1';
            if($homepage->save()){
                $msg = 'Homepage has been deleted successfully.';
                $request->session()->flash('message', $msg);
            }
        }
        return redirect()->route('admin.homepages');
    }

    

}