<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class Homepage extends Model
{
    use Notifiable;
    use Sortable;

    protected $table = 'homepages';

    public $sortable = ['id',
                        'header_image_normal',
                        'created_at',
                        'updated_at'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'header_image_normal'
    ];

    public static function homepage(){
        return static::where('homepages.status', '=', '1')->first();
    }

    
}
