<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminController;
use App\User;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;

class UserController extends AdminController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->record_per_page=10;
    }

    public function usersList(Request $request) {
        $admin_id = $request->session()->get('id');
        $pageNo = trim($request->input('page', 1));
        
        DB::enableQueryLog();
        
        $keyword = strtolower(trim($request->input('keyword')));
        $field_name = strtolower(trim($request->input('field_name'))); 
        
        $usersList = User::where('users.email', '!=', '')->where('users.is_deleted', '=', '0');
        $count = User::where('users.email', '!=', '')->where('users.is_deleted', '=', '0')->count();
        
        if($keyword)
        {
            $usersList = $usersList->where(function ($query) use ($keyword) {
            $query->orwhere('users.name', 'like', '%'.$keyword);
            $query->orwhere('users.email', 'like', '%'.$keyword);
            });
        }
        
        $records = $usersList->sortable(['id'=>'desc'])->paginate($this->record_per_page);
        
        $queries = DB::getQueryLog();
        
        return view('admin.users.users_mng', ['records' => $records,'pageNo' => @$pageNo, 'record_per_page' => $this->record_per_page,'request'=>$request]);
    }

    public function createUser(){
        return view('admin.users.add');
    }

    public function saveUser(Request $request) {
        if ($request->all()) { //post
            $name = strtolower(trim($request->name));
            $email = strtolower(trim($request->email)); 
            $new_password = trim($request->new_password);
            $confirm_password = trim($request->confirm_password);
            
            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'email' => 'required|email|unique:users,email,null,null',
            ]);

            if ($validator->fails()) {
                return redirect()->route('admin.user.add')
                            ->withErrors($validator)
                            ->withInput();
            } else {
                if(!$new_password)
                    $password = _makePassword(6);
                else
                $password = $new_password;

                $user = new User;
                $user->password = Hash::make($password);

                $user->name = $name;
                $user->email = strtolower($email);
                $user->save();

                $msg = 'User has been added successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.users');
            }
        }
    }
    
    public function editUser(Request $request, $id){
        if(!empty($id)){
            $data = User::find($id);
        }
        return view('admin.users.edit', compact(array('data')));
    }

    public function updateUser(Request $request, $id = '') {
        $data = array();
        if(!empty($id)){
            $data = User::find($id);
        }
        if ($request->all()) { 
            $email = strtolower(trim($request->email)); 
            $name = strtolower(trim($request->name));
            $new_password = trim($request->new_password);
            $confirm_password = trim($request->confirm_password);
            
            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'email' => 'required|email|unique:users,email,null,null,id,!'.$id,
            ]);
            
            if ($validator->fails()) 
            {
                return redirect()->route('admin.user.edit',['id'=>$id])
                ->withErrors($validator)
                ->withInput(); 
            } 
            else 
            {
                if ($id) { //update case
                    $user = User::find($id);
                    if($new_password)
                        $user->password = Hash::make($new_password);
                } else {
                    if(!$new_password)
                        $password = _makePassword(6);
                    else
                    $password = $new_password;
                    $user = new User;
                    $user->password = Hash::make($password);
                }

                $user->name = $name;
                $user->email = strtolower($email);
                $user->save();

                if ($id  && empty($request->new_password)) 
                {
                    $msg = 'User has been updated successfully.';
                    $request->session()->flash('add_message', $msg);
                    return redirect()->route('admin.users');
                } 
                else if (!empty($id) && !empty($request->new_password))
                {
                    try{
                        $msg = 'User has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin.users');
                    }
                    catch(\Exception $e){
                        //
                    }
                } 
                else 
                {
                    try{
                        $msg = 'User has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin.users');
                    }
                    catch(\Exception $e){
                        //
                    }
                }
            }
        }
        else {
            return view('admin.user.edit', compact(array('data')));
        }
    }

    public function deleteUser($id, Request $request) {
        if ($id) {
            $user = User::find($id);
            $user->is_deleted = '1';
            
            if($user->save()){
                $msg = 'User has been deleted successfully.';
                $request->session()->flash('message', $msg);
            }
        }
        return redirect()->route('admin.users');
    }

}