#!/usr/bin/env bash

# Set environment variables for dev
export APP_ENV=${APP_ENV:-local}

COMPOSE="docker-compose -f docker-compose.$APP_ENV.yml"

# If we pass any arguments...
if [ $# -gt 0 ];then

    # If "art" is used, pass-thru to "artisan"
    # inside a new container
    if [ "$1" == "art" ]; then
        shift 1
        $COMPOSE run --rm \
            web \
            php artisan "$@"

    # If "composer" is used, pass-thru to "composer"
    # inside a new container
    elif [ "$1" == "composer" ]; then
        shift 1
        $COMPOSE run --rm \
            web \
            composer "$@" --no-plugins --no-scripts

    # If "test" is used, run unit tests,
    # pass-thru any extra arguments to php-unit
    elif [ "$1" == "test" ]; then
        shift 1
        $COMPOSE run --rm \
            web \
            ./vendor/bin/phpunit "$@"

    # If "npm" is used, run npm
    # from our node container
    elif [ "$1" == "npm" ]; then
        shift 1
        $COMPOSE run --rm \
            node \
            npm "$@"

    # If "gulp" is used, run gulp
    # from our node container
    elif [ "$1" == "gulp" ]; then
        shift 1
        $COMPOSE run --rm \
            node \
            ./node_modules/.bin/gulp "$@"
    # Else, pass-thru args to docker-compose
    else
        $COMPOSE "$@"
    fi

else
    $COMPOSE ps
fi
