@extends('adminlte::page')

@section('content')

<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>Locater</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Create Feed</li>
            </ol>
        </div>
    </div>
</div><!-- /.container-fluid -->

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"></h3>
                            <div class="alert alert-success alert-dismissible groputitle" style="display:none">
                        </div>
                        @if(Session::has('add_message'))
                        <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {!! session('add_message') !!} 
                        </div>
                        @endif

                        <form class="form-horizontal" id="add-feedform" action="{{route('admin.feeds.save')}}" method="POST" enctype="multipart/form-data">

                        {{ csrf_field() }}
                        <div class="box-body">
                       
                            <div class="form-group @if($errors->first('feeds_id')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Feed ID<em>*</em></label>
                            <div class="col-sm-4">
                                <input type="text" name="feeds_id" class="form-control" placeholder="Feed ID">
                                <?php if(@$errors->first('feeds_id')) { ?> <span class="help-block">{{@$errors->first('feeds_id')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('title')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Title<em>*</em></label>
                            <div class="col-sm-6">
                                <input type="text" name="title" class="form-control" placeholder="Title">
                                <?php if(@$errors->first('title')) { ?> <span class="help-block">{{@$errors->first('title')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('description')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Description</label>
                            <div class="col-sm-10">
                                <textarea class="form-control" id="description" name="description">
                                <?php if(isset($data->description) && !empty($data->description)){ ?>
                                {{$data->description}}
                                <?php } ?>
                                </textarea>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('gtin')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Gtin<em>*</em></label>
                            <div class="col-sm-4">
                                <input type="textarea" name="gtin" class="form-control" placeholder="gtin">
                                <?php if(@$errors->first('gtin')) { ?> <span class="help-block">{{@$errors->first('gtin')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('brand')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Brand<em>*</em></label>
                            <div class="col-sm-4">
                                <input type="textarea" name="brand" class="form-control" placeholder="brand">
                                <?php if(@$errors->first('brand')) { ?> <span class="help-block">{{@$errors->first('brand')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('color')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Color<em>*</em></label>
                            <div class="col-sm-4">
                                <input type="textarea" name="color" class="form-control" placeholder="color">
                                <?php if(@$errors->first('color')) { ?> <span class="help-block">{{@$errors->first('color')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('size')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Size<em>*</em></label>
                            <div class="col-sm-4">
                                <input type="textarea" name="size" class="form-control" placeholder="size">
                                <?php if(@$errors->first('size')) { ?> <span class="help-block">{{@$errors->first('size')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('link')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Link<em>*</em></label>
                            <div class="col-sm-6">
                                <input type="textarea" name="link" class="form-control" placeholder="link">
                                <?php if(@$errors->first('link')) { ?> <span class="help-block">{{@$errors->first('link')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('image_link')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Image Link<em>*</em></label>
                            <div class="col-sm-6">
                                <input type="textarea" name="image_link" class="form-control" placeholder="image_link">
                                <?php if(@$errors->first('image_link')) { ?> <span class="help-block">{{@$errors->first('image_link')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('availability')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Availability<em>*</em></label>
                            <div class="col-sm-4">
                                <?php $options = array('in stock'=>'In stock'); ?>
                                <select name="availability" class="form-control">
                                    <option value="">Select</option>
                                    @foreach($options as $key => $option)
                                    <option value="<?php echo $key; ?>"><?php echo $option; ?></option>
                                    @endforeach
                                </select>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('product_condition')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Product Condition<em>*</em></label>
                            <div class="col-sm-4">
                                <?php $options = array('NEW'=>'NEW'); ?>
                                <select name="product_condition" class="form-control">
                                    <option value="">Select</option>
                                    @foreach($options as $key => $option)
                                    <option value="<?php echo $key; ?>"><?php echo $option; ?></option>
                                    @endforeach
                                </select>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('item_group_id')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Item Group Id<em>*</em></label>
                            <div class="col-sm-4">
                                <input type="textarea" name="item_group_id" class="form-control" placeholder="item_group_id">
                                <?php if(@$errors->first('item_group_id')) { ?> <span class="help-block">{{@$errors->first('item_group_id')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('google_product_category')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Google Product Category<em>*</em></label>
                            <div class="col-sm-4">
                                <input type="textarea" name="google_product_category" class="form-control" placeholder="google_product_category">
                                <?php if(@$errors->first('google_product_category')) { ?> <span class="help-block">{{@$errors->first('google_product_category')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('product_type')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Product Type<em>*</em></label>
                            <div class="col-sm-4">
                                <input type="textarea" name="product_type" class="form-control" placeholder="product_type">
                                <?php if(@$errors->first('product_type')) { ?> <span class="help-block">{{@$errors->first('product_type')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('sale_price')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Sale Price<em>*</em></label>
                            <div class="col-sm-4">
                                <input type="textarea" name="sale_price" class="form-control" placeholder="sale_price">
                                <?php if(@$errors->first('sale_price')) { ?> <span class="help-block">{{@$errors->first('sale_price')}}</span> <?php } ?>
                            </div>
                            </div>
                            
                            <div class="form-group @if($errors->first('price')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Price<em>*</em></label>
                            <div class="col-sm-4">
                                <input type="textarea" name="price" class="form-control" placeholder="price">
                                <?php if(@$errors->first('price')) { ?> <span class="help-block">{{@$errors->first('price')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('status')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Status<em>*</em></label>
                            <div class="col-sm-4">
                                <?php $options = array('1'=>'Active','0'=>'In Active'); ?>
                                <select name="status" class="form-control">
                                    <option value="">Select</option>
                                    @foreach($options as $key => $option)
                                    <option value="<?php echo $key; ?>"><?php echo $option; ?></option>
                                    @endforeach
                                </select>
                            </div>
                            </div>

                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer">
                            <input type="submit" value="Submit" class="btn btn-info">
                            <a href="{{route('admin.feeds')}}" class="btn btn-default">Cancel</a>
                        </div>
                        <!-- /.box-footer -->
                        </form>
                        
                    </div>
                    
                </div>
                <!--/.col (right) -->
            </div>
        </div>
    </div>
        
                
    <style>
        .help-block{
            color:red;
        }
        .error{
            color:red;
        }
    </style>

<script type="text/javascript">
    $( document ).ready(function() {
    
      $.validator.addMethod('filesize', function(value, element, param) {
        return this.optional(element) || (element.files[0].size <= param)
      });
         
      $.validator.addMethod("alphanumspecial", function (value, element) {
        return this.optional(element) || /^(?=.*[a-z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{6,})/i.test(value);
      }, "Combination of alphabets,special characters & numeric values required.");
      $('#add-feedform').validate({
            ignore: ".ignore",
            rules: {
                feeds_id: "required",
                title: "required",
                description: "required",
                gtin: "required",
                brand: "required",
                color: "required",
                size: "required",
                link: "required",
                image_link: "required",
                availability: "required",
                product_condition: "required",
                item_group_id: "required",
                google_product_category: "required",
                product_type: "required",
                sale_price: "required",
                price: "required",
                status: "required",
            },
            // Specify validation error messages
            messages: {
                feeds_id:"Please enter Feed ID.",
                title:"Please enter Titale.",
                description: "Please enter Description.",
                gtin: "Please enter Gtin.",
                brand: "Please enter Brand.",
                color: "Please enter Color",
                size: "Please enter Size.",
                link: "Please enter Link.",
                image_link: "Please enter Image Link.",
                availability: "Please select availabilty.",
                product_condition: "Please select Product Condition.",
                item_group_id: "Please enter Item Group Id.",
                google_product_category: "Please enter Google Product Category.",
                product_type: "Please enter Product Type",
                sale_price: "Please enter Sale Price.",
                price: "Please enter Price.",
                status: "Please select status."
            },
        });
    });
  
</script>
<script src="{{ asset('/vendor/unisharp/laravel-ckeditor/ckeditor.js') }}"></script>
<script>
    CKEDITOR.replace( 'description' );
</script>

@endsection        