@if(!empty($reviewData['data']))
<div class="col-12 card-columns">
    @foreach($reviewData['data'] as $data)
    <article class="card">
        <div class="card-body">
            <p class="rev-name">{{ $data['reviewer']['name'] }}</p>
            <figure class="rev-img"><img src="{{ $data['reviewer']['photoUrl'] }}"></figure>
            <p><span class="ratings">
                    <?php for($i=1; $i<=5; $i++){ 
                        $rating = round($data['rating']);
                        if($rating >= $i){ 
                            echo'<i class="mdi mdi-star"></i>';
                        }else{
                            echo '<i class="mdi mdi-star-outline"></i>';
                        }
                        ?>
                    <?php } ?>
                    <span class="timestamp">{{ $data['postedAt'] }}</span>
                </span>
            </p>
            <p class="rev-text">{{ $data['review'] }}</p>
        </div>
    </article>
    @endforeach
    @if($reviewData['meta']['total'] > 15)
    <article class="text-center">
        <!-- For Pagination -->
        <div class="pagination-wrapper justify-content-center">
            <nav>
                <ul class="pagination">
                    <?php 
                        $reviewData['links']['first'] = explode('page=',$reviewData['links']['first']);
                        if(!empty($reviewData['links']['last'])){
                            $reviewData['links']['last'] = explode('page=',$reviewData['links']['last']);
                        }else{
                            $reviewData['links']['last'] = '';
                        }
                        if(!empty($reviewData['links']['prev'])){
                            $reviewData['links']['prev'] = explode('page=',$reviewData['links']['prev']);
                        }else{
                            $reviewData['links']['prev'] = '';
                        }
                        if(!empty($reviewData['links']['next'])){
                            $reviewData['links']['next'] = explode('page=',$reviewData['links']['next']);
                        }else{
                            $reviewData['links']['next'] = '';
                        }
                        
                    ?>
                    <li class="page-item">
                        <a class="page-link" id="first" title="First" data-page="{{ $reviewData['links']['first'][1] }}" href="javascript:void(0);">
                            <i class="mdi mdi-chevron-double-left"></i>
                        </a>
                    </li>
                    <li class="page-item">
                        <a class="page-link" title="Prev" href="javascript:void(0);" id="prev" data-page="@if(@$reviewData['links']['prev']) {{ $reviewData['links']['prev'][1] }} @else @endif" aria-label="Previous">
                            <i class="mdi mdi-chevron-left"></i>
                        </a>
                    </li>
                    <li class="page-item">
                        <a class="page-link" title="Next" href="javascript:void(0);" id="next" data-page="@if(@$reviewData['links']['next']) {{ $reviewData['links']['next'][1] }} @else @endif" name="next" aria-label="Next">
                            <i class="mdi mdi-chevron-right"></i>
                        </a>
                    </li>
                    <li class="page-item">
                        <a class="page-link" title="Last" id="last" data-page="{{ $reviewData['links']['last'][1] }}" href="javascript:void(0);"><i class="mdi mdi-chevron-double-right"></i></a>
                    </li>
                </ul>
            </nav>
        </div>
        <!-- End Pagination -->
    </article>
    @endif
</div>
@else
<div class="col-12 card-columns">
    <article class="card">
        <div class="card-body">
            <p class="rev-text">No Data Found!</p>
        </div>
    </article>
</div>    
@endif