@extends('adminlte::page')

@section('content')

<div class="container-fluid">
    <div class="">
        <div class="col-sm-6">
            <h2>Locator Offer</h2>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Update Offer</li>
            </ol>
        </div>
    </div>
</div><!-- /.container-fluid -->

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"></h3>
                            <div class="alert alert-success alert-dismissible groputitle" style="display:none">
                        </div>
                        @if(Session::has('add_message'))
                        <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {!! session('add_message') !!} 
                        </div>
                        @endif

                        <form class="form-horizontal" id="add-offerform" action="{{route('admin.offers.save')}}" method="POST" enctype="multipart/form-data">

                        {{ csrf_field() }}


                        <div class="col-md-12">
                            <!-- Custom Tabs -->
                            <div class="nav-tabs-custom">
                                <ul class="nav nav-tabs">
                                <li class="active"><a href="#tab_1" data-toggle="tab" aria-expanded="true">MAIN</a></li>
                                </ul>
                                <div class="tab-content">
                                <div class="tab-pane active" id="tab_1">
                                    <div class="form-group @if($errors->first('locater_id')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Locater ID<em>*</em></label>
                                    <div class="col-sm-10">
                                        <select name="locater_id" class="form-control">
                                            <option value="">Select</option>
                                            @foreach($locater_identity as $key => $option)
                                            <option 
                                                value="<?php echo $option->id; ?>"><?php echo $option->locater_identity; ?></option>
                                            @endforeach
                                        </select>
                                    </div>
                                    </div>

                                    <div class="form-group @if($errors->first('offer_type')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Offer Type<em>*</em></label>
                                    <div class="col-sm-10">
                                        <select name="offer_type" class="form-control">
                                            <option value="">Select</option>
                                            @foreach($offer_list as $key => $option)
                                            <option 
                                                value="<?php echo $option->id; ?>"><?php echo $option->name; ?></option>
                                            @endforeach
                                        </select>
                                    </div>
                                    </div>

                                    <div class="form-group @if($errors->first('offer_name')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Offer Name<em>*</em></label>
                                    <div class="col-sm-10">
                                        <input type="text" name="offer_name" class="form-control" placeholder="Offer Name">
                                        <?php if(@$errors->first('offer_name')) { ?> <span class="help-block">{{@$errors->first('offer_name')}}</span> <?php } ?>
                                    </div>
                                    </div>
                                    
                                    <div class="form-group @if($errors->first('start_date')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Start Date<em>*</em></label>
                                    <div class="col-sm-10">
                                        <input autocomplete="off" type="text" name="start_date" id="dpd1" class="form-control" placeholder="Start Date">
                                        <?php if(@$errors->first('start_date')) { ?> <span class="help-block">{{@$errors->first('start_date')}}</span> <?php } ?>
                                    </div>
                                    </div>

                                    <div class="form-group @if($errors->first('end_date')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">End Date<em>*</em></label>
                                    <div class="col-sm-10">
                                        <input autocomplete="off" type="text" name="end_date" id="dpd2" class="form-control" placeholder="End Date">
                                        <?php if(@$errors->first('end_date')) { ?> <span class="help-block">{{@$errors->first('end_date')}}</span> <?php } ?>
                                    </div>
                                    </div>

                                    <div class="form-group @if($errors->first('banner_content')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Status<em>*</em></label>
                                    <div class="col-sm-10">
                                        <?php $options = array('1'=>'Active','0'=>'In Active'); ?>
                                        <select name="status" class="form-control">
                                            <option value="">Select</option>
                                            @foreach($options as $key => $option)
                                            <option value="<?php echo $key; ?>"><?php echo $option; ?></option>
                                            @endforeach
                                        </select>
                                    </div>
                                    </div>
                                    
                                    <div class="form-group @if($errors->first('offer_image')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Offer Image</label>
                                    <div class="col-sm-10">
                                        <input type="file" name="offer_image" class="form-control" placeholder="Offer Image">
                                    </div>
                                    </div>
                                    
                                    <div class="form-group @if($errors->first('offer_link')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Offer Link</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="offer_link" class="form-control" placeholder="Offer Link">
                                        <?php if(@$errors->first('offer_link')) { ?> <span class="help-block">{{@$errors->first('offer_link')}}</span> <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                <!-- /.tab-pane -->
                                </div>
                                <!-- /.tab-content -->
                            </div>
                        <!-- nav-tabs-custom -->
                        </div>    


                        <!-- /.box-body -->
                        <div class="box-footer">
                            <input type="submit" value="Submit" class="btn btn-info">
                            <a href="{{route('admin.offers')}}" class="btn btn-default">Cancel</a>
                        </div>
                        <!-- /.box-footer -->
                        </form>
                        
                    </div>
                    
                </div>
                <!--/.col (right) -->
            </div>
        </div>
    </div>
        
                
            <style>
                .help-block{
                    color:red;
                }
                .error{
                    color:red;
                }
            </style>

<script type="text/javascript">
    $( document ).ready(function() {
    
      $('#add-offerform').validate({
            ignore: ".ignore",
            rules: {
                locater_id: "required",
                offer_type: "required",
                offer_name: "required",
                start_date: "required",
                end_date: "required",
                status: "required",
                banner_content: "required",
            },
            // Specify validation error messages
            messages: {
                locater_id: "Please select locator",
                offer_type: "Please select Offer Type.",
                offer_name: "Please enter Offer Name.",
                start_date: "Please select Start Date.",
                end_date: "Please select End Date.",
                status: "Please select Status.",
                banner_content: "Please enter Meta Banner Content.",
            },
        });
    });


    $( "#dpd1" ).datepicker();
    $( "#dpd2" ).datepicker();

    $("#dpd2").change(function () {
        var dpd1 = $('#dpd1').val();
        var dpd2 = $('#dpd2').val();
       
        if ((Date.parse(dpd1) >= Date.parse(dpd2))) {
            alert("End date should be greater than Start date");
            document.getElementById("dpd2").value = "";
        }
    });

    
</script>

@endsection        