@extends('adminlte::page')

@section('content')

<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>Users</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Update User</li>
            </ol>
        </div>
    </div>
</div><!-- /.container-fluid -->

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"></h3>
                            <div class="alert alert-success alert-dismissible groputitle" style="display:none">
                        </div>
                        @if(Session::has('add_message'))
                        <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {!! session('add_message') !!} 
                        </div>
                        @endif

                        <form class="form-horizontal" id="add-form" action="@if(@$data->id) {{route('admin-usersedit',['id'=>@$data->id])}} @else  {{route('admin-adduser')}} @endif" method="POST" enctype="multipart/form-data">

                        {{ csrf_field() }}
                        <div class="box-body">
                        <input type="hidden" name="id" value="{{old('id',@$data->id)}}">
                        

                            <div class="form-group @if($errors->first('first_name')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Name<em>*</em></label>
                            <div class="col-sm-10">
                                <input type="text" name="name" class="form-control" placeholder="Name" value="{{old('name',@$data->name)}}">
                                <?php if(@$errors->first('name')) { ?> <span class="help-block">{{@$errors->first('name')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('email')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Email<em>*</em></label>
                            <div class="col-sm-10">
                                <?php
                                if(isset($data->id) && $data->id>0){
                                echo $data->email;
                                ?>
                                <input type="hidden" name="email" class="form-control" placeholder="Email" value="{{old('email',@$data->email)}}">
                                <?php
                                }
                                else{ 
                                ?>
                                <input type="text" name="email" class="form-control" placeholder="Email" value="{{old('email',@$data->email)}}">
                                <?php } ?>
                                <?php if(@$errors->first('email')) { ?><span class="help-block">{{@$errors->first('email')}}</span> <?php } ?>
                            </div>
                            </div>
                            <div class="form-group @if($errors->first('new_password')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Password</label>
                            <div class="col-sm-10">
                                <input type="password" id="new_password" name="new_password" class="form-control" placeholder="New password" value="{{old('new_password')}}">
                                <?php if(@$errors->first('new_password')) { ?><span class="help-block">{{@$errors->first('new_password')}}</span> <?php } ?>
                            </div>
                            </div>
                            <div class="form-group @if($errors->first('confirm_password')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Confirm Password</label>
                            <div class="col-sm-10">
                                <input type="password" id="confirm_password" name="confirm_password" class="form-control" placeholder="Confirm Password" value="{{old('confirm_password')}}">
                                <?php if(@$errors->first('confirm_password')) { ?><span class="help-block">{{@$errors->first('confirm_password')}}</span> <?php } ?>
                            </div>
                            </div>
                            
                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer">
                            <input type="submit" value="Submit" class="btn btn-info">
                            <a href="{{route('admin-users')}}" class="btn btn-default">Cancel</a>
                        </div>
                        <!-- /.box-footer -->
                        </form>
                        
                    </div>
                    
                </div>
                <!--/.col (right) -->
            </div>
        </div>
    </div>
        
                
            <style>
                .help-block{
                    color:red;
                }
            </style>

<script type="text/javascript">
    $( document ).ready(function() {
    
      $.validator.addMethod('filesize', function(value, element, param) {
        return this.optional(element) || (element.files[0].size <= param)
      });
         
      $.validator.addMethod("alphanumspecial", function (value, element) {
        return this.optional(element) || /^(?=.*[a-z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{6,})/i.test(value);
      }, "Combination of alphabets,special characters & numeric values required.");
      $('#add-form').validate({
            ignore: ".ignore",
            rules: {
                email: {
                    required:true,
                    email:true,
                    remote: {
                        url: '{{route("check_email")}}'+'?id='+'{{@$data->id}}',
                        type: "get",
                        data: {
                            title: function() {
                                return $("#email").val();
                            }
                        },
                    },
                },
                name: "required",
                new_password: {
                    minlength: 6,
                    maxlength: 15,
                    alphanumspecial: true
                },
                confirm_password:{
                    required: {
                        depends: function(element) {
                            return ($("input[name=new_password]").val() != "" && $('input[name=id]').val() != "");
                        },
                    },
                    minlength:6,
                    equalTo : "#new_password",
                },
            },
            // Specify validation error messages
            messages: {
                email:
                {
                    required:"Please enter email.",
                    email:"Please enter valid email.",
                    remote:"Email already exist."
                },
                name: "Please enter Name.",
                new_password:{
                    minlength: "Password must be 6 characters long hhhh.",
                    maxlength: 'Maximum length required is 15',
                    alphanumspecial: 'Combination of alphabets,special characters & numeric values required',
                },
                confirm_password:{
                    required:"Please enter confirm password.",
                    minlength: "Password must be 6 characters long.",
                    equalTo : "Confirm password should match with new password.",
                }
            },
        });
    });
  
</script>

@endsection        