<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminController;
use App\Locater;
use App\User;
use App\Page;
use App\Offer;
use App\OfferType;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;

class OfferController extends AdminController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->record_per_page=10;
    }


    public function offerslist(Request $request) {
        $admin_id = $request->session()->get('id');
        $pageNo = trim($request->input('page', 1));
        DB::enableQueryLog();
        $keyword = strtolower(trim($request->input('keyword')));
        $field_name = strtolower(trim($request->input('field_name'))); 
        $order_by = strtolower(trim($request->input('order_by'))); 
        $offerList = Offer::where('offers.is_deleted', '=', '0')->with('locaterlists');
        $count = Offer::where('offers.is_deleted', '=', '0')->with('locaterlists');
        if($keyword)
        {
            $offerList = $offerList->where(function ($query) use ($keyword) {
                $query->orwhere('offers.offer_name', 'like', '%'.$keyword);
            });
        }
        
        $this->data['records'] = $offerList->sortable(['id'=>'desc'])->paginate($this->record_per_page);
        $queries = DB::getQueryLog();

        return view('admin.offers.offers_mng', ['data' => $this->data,'pageNo' => @$pageNo, 'record_per_page' => $this->record_per_page,'request'=>$request]);
    }

    /**
    * Function add_offer
    *
    * function to add offer
    *
    * @Created Date: 01 July,2019
    * @Modified Date: 01 July,2019
    * @param  ARRAY
    * @return STRING
    */
    public function add_offer(Request $request, $id = '') {
        $user_id = auth()->user('id');
        $data = array();
        if(!empty($id)){
            $data = Offer::find($id);
        }
        if ($request->all()) { //post

            
            $offer_name = trim($request->offer_name);
            $locater_id = trim($request->locater_id);
            $start_date = date("Y-m-d", strtotime($request->start_date));
            $end_date = date("Y-m-d", strtotime($request->end_date));//trim($request->end_date);
            $offer_type = trim($request->offer_type);
            $offer_link = trim($request->offer_link);
            $created_by = trim($user_id->id);
            $status = trim($request->status);
            
            if ($id) {
                //Validate the input
                $validator = Validator::make($request->all(), [
                    'locater_id' => 'required',
                    'offer_name' => 'required',
                    'offer_image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'start_date' => 'required',
                    'end_date' => 'required',
                    'offer_type' => 'required',
                ]);
                $messages = $validator->messages();
            }else {
                //Validate the input
                $validator = Validator::make($request->all(), [
                    'locater_id' => 'required',
                    'offer_name' => 'required',
                    'start_date' => 'required',
                    'offer_image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                    'end_date' => 'required',
                    'offer_type' => 'required',
                ]);
            }
            if ($validator->fails()) {
                if($id) {
                   return redirect()->route('admin-editoffer',['id'=>$id])
                            ->withErrors($validator)
                            ->withInput(); 
                } else {
                    return redirect()->route('admin-addoffer')
                            ->withErrors($validator)
                            ->withInput();
                }
            } else {
                if ($id) { //update case
                    $offer = Offer::find($id);//->with('userlists');
                    $modified_by = trim($user_id->id);
                    $offer->modified_by = $modified_by;
                } else {
                    $offer = new Offer;
                    $offer->created_by = $user_id->id;
                }
                $offer->offer_name = $offer_name;
                $offer->locater_id = $locater_id;
                $offer->start_date = $start_date;
                $offer->end_date = $end_date;
                $offer->offer_type = $offer_type;
                $offer->offer_link = $offer_link;
                if(!empty($request->offer_image)){
                    $offer->offer_image = $request->file('offer_image')->store('image');
                }
                
                $offer->status = $status;
                //echo"<pre>";
                //print_r($offer);
                //die;
                $offer->save();
                if ($id) {
                    $msg = 'Offer has been updated successfully.';
                    $request->session()->flash('add_message', $msg);
                    return redirect()->route('admin-offers');
                } else if (!empty($id)){
                    try{
                        $msg = 'Offer has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin-offers');
                    }
                    catch(\Exception $e){
                        //
                    
                    }
                } else {
                    try{
                        $msg = 'Offer has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin-offers');
                    }
                    catch(\Exception $e){
                        //
                    }
                }
            }
        }
        else {
            $locater_id_url = Locater::where('locaters.status', '=', '1')->get();
            $offer_list = OfferType::where('offer_types.status', '=', '1')->get();
            return view('admin.offers.add_offer', ['data' => $data, 'locater_id_url'=> $locater_id_url,'offer_list'=>$offer_list,'request' => $request]);
        }
    }

    public function offer_delete($id, Request $request) {
        if ($id) {
            $offer = Offer::find($id);
            $offer->is_deleted = '1';
            if($offer->save()){
                $msg = 'Offer has been deleted successfully.';
                $request->session()->flash('message', $msg);
            }
        }
        return redirect()->route('admin-offers');
    }

}