<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminController;
use App\Locater;
use App\User;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;

class LocaterController extends AdminController
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->record_per_page=10;
    }

    public function locaterslist(Request $request) {
        $admin_id = $request->session()->get('id');
        $pageNo = trim($request->input('page', 1));
        DB::enableQueryLog();
        $keyword = strtolower(trim($request->input('keyword')));
        $field_name = strtolower(trim($request->input('field_name'))); 
        $order_by = strtolower(trim($request->input('order_by'))); 
        $locaterList = Locater::where('locaters.status', '=', '1');
        $count = Locater::where('locaters.status', '=', '1')->count();
        if($keyword)
        {
            $locaterList = $locaterList->where(function ($query) use ($keyword) {
                $query->orwhere('locaters.name', 'like', '%'.$keyword);
                $query->orwhere('locaters.locater_id_url', 'like', '%'.$keyword);
                $query->orwhere('locaters.description', 'like', '%'.$keyword);
            });
        }
        
        $this->data['records'] = $locaterList->sortable(['id'=>'desc'])->paginate($this->record_per_page);
        $queries = DB::getQueryLog();
        //dd($queries);
        return view('admin.locaters.locaters_mng', ['data' => $this->data,'pageNo' => @$pageNo, 'record_per_page' => $this->record_per_page,'request'=>$request]);
    }

    /**
    * Function add_locater
    *
    * function to add locater
    *
    * @Created Date: 28 June,2019
    * @Modified Date: 28 June,2019
    * @param  ARRAY
    * @return STRING
    */
    public function add_locater(Request $request, $id = '') {
        $user_id = auth()->user('id');
        $data = array();
        if(!empty($id)){
            $data = Locater::find($id);
        }
        if ($request->all()) { //post
            //dd($request->all());
            $name = trim($request->name);
            $locater_id_url = trim($request->locater_id_url);
            $locater_code = trim($request->locater_code);
            $description = trim($request->description);
            
            if ($id) {
                //Validate the input
                $validator = Validator::make($request->all(), [
                    'locater_id_url' => 'required',
                    'locater_code' => 'required',
                    'name' => 'required',
                    'description' => 'required',
                ]);
                $messages = $validator->messages();
            }else {
                //Validate the input
                $validator = Validator::make($request->all(), [
                    'locater_id_url' => 'required|unique:locaters,locater_id_url,null,null,id,!'.$id,
                    'locater_code' => 'required|unique:locaters,locater_code,null,null,id,!'.$id,
                    'name' => 'required',
                    'description' => 'required',
                ]);
            }
            if ($validator->fails()) {
                if($id) {
                   return redirect()->route('admin-editlocater',['id'=>$id])
                            ->withErrors($validator)
                            ->withInput(); 
                } else {
                    return redirect()->route('admin-addlocater')
                            ->withErrors($validator)
                            ->withInput();
                }
            } else {
                if ($id) { //update case
                    $locater = Locater::find($id);
                    $modified_by = trim($user_id->id);
                    $locater->modified_by = $modified_by;
                } else {
                    $locater = new Locater;
                    $locater->created_by = $user_id->id;
                }
                $locater->name = $name;
                $locater->locater_id_url = $locater_id_url;
                $locater->locater_code = $locater_code;
                $locater->description = $description;
                $locater->save();
                if ($id) {
                    $msg = 'Locater has been updated successfully.';
                    $request->session()->flash('add_message', $msg);
                    return redirect()->route('admin-locaters');
                } else if (!empty($id)){
                    try{
                        $msg = 'Locater has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin-locaters');
                    }
                    catch(\Exception $e){
                        //
                    
                    }
                } else {
                ######### Here I am creating a Agency locaters with all privillages ######
                    try{
                        $msg = 'Locater has been added successfully.';
                        $request->session()->flash('add_message', $msg);
                        return redirect()->route('admin-locaters');
                    }
                    catch(\Exception $e){
                        //
                    }
                }
            }
        }
        else {
            return view('admin.locaters.add_locater', ['data' => $data, 'request' => $request]);
        }
    }

    public function locater_delete($id, Request $request) {
        if ($id) {
            $locater = Locater::find($id);
            $locater->status = '0';
            if($locater->save()){
                $msg = 'Locater has been deleted successfully.';
                $request->session()->flash('message', $msg);
            }
        }
        return redirect()->route('admin-locaters');
    }

}