<?php

namespace App\Traits;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Storage;

Trait Apitraits
{
    private function createFileAndPutApiKey(){
        Storage::disk('public')->put('key/apikey.dba', '');
        $api_key_url = config('app.api_key_url');

        $client = new Client();

        $response = $client->request('POST', $api_key_url,[
            'form_params'   => [
                'client_id' => 1,
                'client_secret' => 'DJXCYjyCRDt5IHMbiKYbiKqjVWdeNKo1VixHYQaL'
            ]
        ]);

        $body = $response->getBody()->getContents();
        $keyDetailAPIdata = json_decode($body, true);

        $updateKey = Storage::disk('public')->put('key/apikey.dba', $keyDetailAPIdata['access_token']);

        if($updateKey == true){
            $api_key = Storage::get('key/apikey.dba');
        }else{
            return false;
        }
        return $api_key;
    }

    public function getAPiKey(){
        
        $file = Storage::disk('public')->exists('key/apikey.dba');

        if($file == false){
            
            $api_key =  $this->createFileAndPutApiKey();

        }else{
            
            $modifiedtime = Storage::lastModified('key/apikey.dba');
            $time = date('d-m-Y', $modifiedtime);
            $expieryDate = date('d-m-Y', strtotime($time. ' + 15 days'));
            $expieryUpdationDate = date('d-m-Y', strtotime($expieryDate. ' - 1 days'));
            $currentDate = date('d-m-Y');

            if(strtotime($currentDate) == strtotime($expieryUpdationDate)){
                $file = Storage::disk('public')->exists('key/apikey.dba');

                $api_key_url = config('app.api_key_url');

                $client = new Client();

                $response = $client->request('POST', $api_key_url,[
                    'form_params'   => [
                        'client_id' => 1,
                        'client_secret' => 'DJXCYjyCRDt5IHMbiKYbiKqjVWdeNKo1VixHYQaL'
                    ]
                ]);

                $body = $response->getBody()->getContents();
                $keyDetailAPIdata = json_decode($body, true);

                $updateKey = Storage::disk('public')->put('key/apikey.dba', $keyDetailAPIdata['access_token']);

                if($updateKey == true){
                    $api_key = Storage::get('key/apikey.dba');
                }else{
                    return false;
                }         
            }else{
                
                $file = Storage::disk('public')->exists('key/apikey.dba');
                if($file == true){
                    $api_key = Storage::get('key/apikey.dba');
                }else{
                    return false;
                }
            }
        }
        
        return $api_key;
    } 
    
    public function call_api($api_url,$locatorID)
    {
        $apiKey = $this->getAPiKey();

        $client = new Client();
        $response = $client->request('GET', $api_url.$locatorID, [ 'headers' => [
            'Accept'     => 'application/json',
            'Authorization'  => $apiKey]
        ]);

    	$statusCode = $response->getStatusCode();
        $body = $response->getBody()->getContents();
        return $locationDetailAPIdata = json_decode($body, true);
    }


    public function call_api_page($api_url, $locatorID=null, $state=null, $city=null, $location=null, $page=1)
    {
        $apiKey = $this->getAPiKey();

        if(!empty($locatorID)){
            $locatorID = $locatorID;
        }else{
            $locatorID = $location;
        }

        $query_param = array(
            'keyword' => $locatorID,
            'state' => $state,
            'city' => $city,
            'page' => empty($page) ? 1 : $page
        );
        
        $client = new Client();
        $response = $client->request('GET', $api_url, [ 'headers' => [
            'Accept'     => 'application/json',
            'Authorization'  => $apiKey],
            'query'   => $query_param
        ]);
        
    	$statusCode = $response->getStatusCode();
        $body = $response->getBody()->getContents();
        return $locationDetailAPIdata = json_decode($body, true);
    }

    public function review_api_detail($api_url, $locatorID, $page=1)
    {
        $apiKey = $this->getAPiKey();

        $api = $api_url.$locatorID.'/reviews'.'/';
       
        $query_param = array(
            'page' => empty($page) ? 1 : $page
        );
       
        $client = new Client();

        $response = $client->request('GET', $api, [ 'headers' => [
            'Accept'     => 'application/json',
            'Authorization'  => $apiKey],
            'query'   => $query_param
        ]);

    	$statusCode = $response->getStatusCode();
        $body = $response->getBody()->getContents();
        return $locationDetailAPIdata = json_decode($body, true);
    }



    public function cronList($api_url)
    {
        $apiKey = $this->getAPiKey();

        $client = new Client();
        $response = $client->request('GET', $api_url, [ 'headers' => [
            'Accept'     => 'application/json',
            'Authorization'  => $apiKey],
        ]);
        
    	$statusCode = $response->getStatusCode();
        $body = $response->getBody()->getContents();
        $locationDetailAPIdata = json_decode($body, true);
        return $locationDetailAPIdata['meta'];
    }

}