<?php
//============================================================+
// File name   : example_002.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 002 for TCPDF class
//               Removing Header and Footer
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Removing Header and Footer
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path).
require_once('config/tcpdf_config.php');
require_once('tcpdf.php');

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('TCPDF Example 061');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

$pdf->setCellHeightRatio(1.2);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('freesans', '', 6);

// add a page
$pdf->AddPage();

/* NOTE:
 * *********************************************************
 * You can load external XHTML using :
 *
 * $html = file_get_contents('/path/to/your/file.html');
 *
 * External CSS files will be automatically loaded.
 * Sometimes you need to fix the path of the external CSS.
 * *********************************************************
 */

// define some HTML content with style
$html = <<<EOF
<table cellpadding="0" cellspacing="5"  class="pay-in-slip bg-grey" style=" background-color: #bdbfc1;" width="100%">
    <tr>
        <td>
            <table cellpadding="0" cellspacing="0"  width="100%">
                <tbody>
                    <tr>
                        <!-- START: CUSTOMER PAY SLIP -->
                        <td class="customer-pay-slip" width="38%" valign="top">
                            <table  cellpadding="0" cellspacing="0"  style=" background-color: #fff; border: 1px solid #373435;"
                                width="100%">
                                <tr>
                                    <td width="99%">
                                        <table width="100%" cellpadding="0" cellspacing="0">
                                            <tbody>
                                                <!-- START: TOP LOGO BAR -->
                                                <tr>
                                                    <td>
                                                        <table cellpadding="0" cellspacing="0"  width="100%">
                                                            <tbody>
                                                                <tr><td height="2" style="line-height: 5px;"></td></tr>
                                                                <tr>
                                                                    <td width="20%"><img src="images/logo.jpg" alt=""></td>

                                                                    <td class=" title" style=" text-align: center; line-height: 10px;" align="center" width="60%">
                                                                        PAYIN SLIP/जमा पर्ची<br>
                                                                            Customer Copy / <span  style="font-weight: bold;">ग्राहककॉपी</span>
                                                                    </td>

                                                                    <td class="secure-pay text-right" width="20%" style=" text-align: right;" align="right"><img src="images/secure-pay.jpg" alt="" class="img-fluid"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr><!-- END: TOP LOGO BAR -->

                                                <tr>
                                                    <td height="2"></td>
                                                </tr>

                                                <!-- START: DATE AND BRANCH NAME -->
                                                <tr>
                                                    <td>
                                                        <table width="100%" cellpadding="0" cellspacing="0" >
                                                            <tbody>
                                                                <tr>
                                                                    <!-- START: DATE -->
                                                                    <td width="40%">
                                                                        <table width="100%" cellpadding="0" cellspacing="0" >
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td class="date-title" width="30%">Date:<br>दिनांक:</td>
                                                                                    <td class="date" width="70%">
                                                                                        <table cellpadding="0" cellspacing="0"  style=" border-bottom: 1px solid #545252; border-right: 1px solid #545252;" width="100%">
                                                                                            <tbody>
                                                                                                <tr>
                                                                                                    <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="12" align="center">
                                                                                                    </td>
                                                                                                    <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="12" align="center">
                                                                                                    </td>
                                                                                                    <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="12" align="center">
                                                                                                    </td>
                                                                                                    <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="12" align="center">
                                                                                                    </td>
                                                                                                    <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="12" align="center">
                                                                                                    </td>
                                                                                                    <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="12" align="center">
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </tbody>
                                                                                        </table>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td><!-- END: DATE -->

                                                                    <td width="1%">&nbsp;</td>


                                                                    <!-- START: DEPOSITED IN BRANCH -->

                                                                    <td width="59%">
                                                                        <table width="100%" cellpadding="0" cellspacing="0" >
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td class="deposited-branch-title" style=" text-align: right;" width="60%">Deposited in Branch:&nbsp;&nbsp;&nbsp;<br>जमा
                                                                                        कर्ता शाखा का नाम&nbsp;&nbsp;&nbsp;</td>
                                                                                    <td style="   border-bottom: 1px solid #545252;" class="deposited-branch" width="40%">&nbsp;<br>Hisar</td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td><!-- END: DEPOSITED IN BRANCH -->
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr><!-- END: DATE AND BRANCH NAME -->

                                                <tr><td></td></tr>

                                                <!-- START: PAY TO -->
                                                <tr class="pay-to">
                                                    <td>
                                                        <table width="100%" cellpadding="1" cellspacing="0"  >
                                                            <tbody>
                                                                <tr>
                                                                    <td   width="30%">Pay To:<br>अदा
                                                                        करे:</td>
                                                                    <td class="pay-to border-bottom" style=" border-bottom: 1px solid #565354;"
                                                                        width="70%" valign="baseline">&nbsp;<br>CignaTTK Health Insurance Co.
                                                                        Ltd.</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr><!-- END: PAY TO -->
                                                <!-- START: PAYER NAME -->

                                                <tr class="payer-name">
                                                    <td>
                                                        <table width="100%" cellpadding="1" cellspacing="0" >
                                                            <tbody>
                                                                <tr>
                                                                    <td  width="30%">Payer Name:<div>भुगतान
                                                                        कर्ता का नाम:</div></td>

                                                                    <td class="payer border-bottom" style=" border-bottom: 1px solid #565354;" width="70%" >&nbsp;<br>Sunil Soni</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr><!-- END: PAYER NAME -->
                                                <!-- START: PAYER DETAIL 1 -->

                                                <tr class="payer-detail">
                                                    <td>
                                                        <table width="100%" cellpadding="1" cellspacing="0" >
                                                            <tbody>
                                                                <tr>
                                                                    <td  width="30%" >Payer Detail 1*<br>भुगतान
                                                                        कर्ता विवरण १*</td>
                                                                    <td class="payer-detail border-bottom" style=" border-bottom: 1px solid #565354;" width="70%">&nbsp;<br>01231456789</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr><!-- END: PAYER DETAIL 1 -->
                                                <!-- START: PAYER DETAIL 2 -->

                                                <tr class="payer-detail">
                                                    <td>
                                                        <table width="100%" cellpadding="1" cellspacing="0" >
                                                            <tbody>
                                                                <tr>
                                                                    <td  width="30%">Payer Detail 2*<br>भुगतान
                                                                        कर्ता विवरण २*</td>

                                                                    <td class="payer-detail border-bottom" style=" border-bottom: 1px solid #565354;" width="70%">&nbsp;<br>01231456789</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr><!-- END: PAYER DETAIL 2 -->
                                                <!-- START: PAYER DETAIL 3 -->

                                                <tr class="payer-detail">
                                                    <td>
                                                        <table width="100%" cellpadding="1" cellspacing="0" >
                                                            <tbody>
                                                                <tr>
                                                                    <td  width="30%">Payer Detail 3*<br>भुगतान
                                                                        कर्ता विवरण ३*</td>
                                                                    <td class="payer-detail border-bottom" style=" border-bottom: 1px solid #565354;" width="70%">&nbsp;<br>01231456789</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr><!-- END: PAYER DETAIL 3 -->

                                                <tr>
                                                    <td height="2"></td>
                                                </tr>

                                                <!-- START: CONTACT NUMBERS -->
                                                <tr class="contact-number">
                                                    <td>
                                                        <table cellpadding="0" cellspacing="0" style="  border: 1px solid #545252;"
                                                            width="100%">
                                                            <tbody>
                                                                <tr>
                                                                    <!-- START: CONTACT NO. 1 -->
                                                                    <td width="50%">
                                                                        <table width="100%" cellpadding="0" cellspacing="0" >
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td  style=" border-right: none; font-size: 4.5px;" width="35%">CONTACT NO. 1<br>दूरभाष
                                                                                        स. १</td>

                                                                                    <td class="contact-number" width="65%">
                                                                                        <table width="100%" cellpadding="0" cellspacing="0" style=" border-right: 1px solid #545252;">
                                                                                            <tbody>
                                                                                                <tr>
                                                                                                    <td style="text-align: center;  border-left: 1px solid #545252;" width="10%" height="11">9</td>
                                                                                                    <td style="text-align: center;  border-left: 1px solid #545252;" width="10%" height="11">8</td>
                                                                                                    <td style="text-align: center;  border-left: 1px solid #545252;" width="10%" height="11">9</td>
                                                                                                    <td style="text-align: center;  border-left: 1px solid #545252;" width="10%" height="11">6</td>
                                                                                                    <td style="text-align: center;  border-left: 1px solid #545252;" width="10%" height="11">2</td>
                                                                                                    <td style="text-align: center;  border-left: 1px solid #545252;" width="10%" height="11">1</td>
                                                                                                    <td style="text-align: center;  border-left: 1px solid #545252;" width="10%" height="11">5</td>
                                                                                                    <td style="text-align: center;  border-left: 1px solid #545252;" width="10%" height="11">7</td>
                                                                                                    <td style="text-align: center;  border-left: 1px solid #545252;" width="10%" height="11">5</td>
                                                                                                    <td style="text-align: center;  border-left: 1px solid #545252;" width="10%" height="11">0</td>
                                                                                                </tr>
                                                                                            </tbody>
                                                                                        </table>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td><!-- END: CONTACT NO. 1 -->
                                                                    <!-- START: CONTACT NO. 2 -->

                                                                    <td width="50%">
                                                                        <table width="100%" cellpadding="0" cellspacing="0" >
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td  style=" text-align: center;  border-right: none; font-size: 4.5px;"
                                                                                        width="35%" align="center">CONTACT NO. 2<br
                                                                                        >दूरभाष
                                                                                        स. २</td>

                                                                                    <td class="contact-number" width="65%">
                                                                                        <table cellpadding="0" cellspacing="0"  style=" border-right: none;">
                                                                                            <tbody>
                                                                                                <tr>
                                                                                                    <td style=" border-left: 1px solid #545252; text-align: center;" width="10%" height="11">9</td>
                                                                                                    <td style=" border-left: 1px solid #545252; text-align: center;" width="10%" height="11">8</td>
                                                                                                    <td style=" border-left: 1px solid #545252; text-align: center;" width="10%" height="11">9</td>
                                                                                                    <td style=" border-left: 1px solid #545252; text-align: center;" width="10%" height="11">6</td>
                                                                                                    <td style=" border-left: 1px solid #545252; text-align: center;" width="10%" height="11">2</td>
                                                                                                    <td style=" border-left: 1px solid #545252; text-align: center;" width="10%" height="11">1</td>
                                                                                                    <td style=" border-left: 1px solid #545252; text-align: center;" width="10%" height="11">5</td>
                                                                                                    <td style=" border-left: 1px solid #545252; text-align: center;" width="10%" height="11">7</td>
                                                                                                    <td style=" border-left: 1px solid #545252; text-align: center;" width="10%" height="11">5</td>
                                                                                                    <td style=" border-left: 1px solid #545252; text-align: center;" width="10%" height="11">0</td>
                                                                                                </tr>
                                                                                            </tbody>
                                                                                        </table>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td><!-- END: CONTACT NO. 2 -->
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <!-- END: CONTACT NUMBERS -->

                                                <tr>
                                                    <td height="2"></td>
                                                </tr>

                                                <!-- START: PARTICULARS -->
                                                <tr class="particulars">
                                                    <td>
                                                        <table width="100%" cellpadding="1" cellspacing="0" style="  text-align: center; width: 100%;" align="center">
                                                            <thead style="background-color: #bdbfc1;">
                                                                <tr>
                                                                    <th style="border: 1px solid #545252; background-color: #bdbfc1;  border-left: none; border-bottom: none;" width="60%">
                                                                        PARTICULARS/ विवरण</th>
                                                                    <th style="border: 1px solid #545252; background-color: #bdbfc1;  border-left: none; border-bottom: none;" width="30%">
                                                                        ₹/ रु.</th>
                                                                    <th style="border: 1px solid #545252; background-color: #bdbfc1;  border-left: none; border-bottom: none; border-right: none;" width="10%">Ps./
                                                                        पै.</th>
                                                                </tr>
                                                            </thead>

                                                            <tbody>
                                                                <tr>
                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8">12345678910</td>

                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8">150000</td>

                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>
                                                                </tr>

                                                                <tr>
                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>

                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>

                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>
                                                                </tr>

                                                                <tr>
                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>

                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>

                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>
                                                                </tr>

                                                                <tr>
                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>

                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>

                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>
                                                                </tr>

                                                                <tr>
                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>

                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>

                                                                    <td style="border: 1px solid #545252;  border-left: none; border-bottom: none;" height="8"></td>
                                                                </tr>

                                                                <tr class="particulars-total">
                                                                    <td class="text-right  " style="text-align: right; font-weight: bold;   border: 1px solid #545252;  border-left: none; border-bottom: none;"
                                                                        height="20" align="right">Total / कुल</td>

                                                                    <td style=" border: 1px solid #545252;  border-left: none; border-bottom: none; " height="8">150000</td>

                                                                    <td style=" border: 1px solid #545252;  border-left: none; border-bottom: none; " height="8">35</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr><!-- END: PARTICULARS -->
                                                <!-- START: OFFICER SIGN -->

                                                <tr class="officer-sign">
                                                    <td>
                                                        <table width="100%" cellpadding="0" cellspacing="0"  style=" border-bottom: 1px solid #565354;">
                                                            <tbody>
                                                                <tr>
                                                                    <td class="sign-first-box" style=" border-left: 1px solid #545252; border-right: 1px solid #545252;" width="70%">
                                                                        <table width="100%" cellpadding="1" cellspacing="0">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td class="sign-title" style=" text-align: center; font-weight: bold; border-bottom: 1px solid #565354;" height="30">SIGN OF OFFICER / अधिकारी के हस्ताक्षर</td>
                                                                                </tr>

                                                                                <tr>
                                                                                    <td class="cheque-sub" align="center">CHEQUE (S) SUBJECT TO REALISATION<br>चैक
                                                                                        (चैकों) की जमा भुगतान प्राप्ति के अधीनहै|</td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>

                                                                    <td class="sign-second-box" width="30%" style=" border-right: 1px solid #545252; text-align: center;" align="center"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr><!-- END: OFFICER SIGN -->
                                                <!-- START: INSTRUCTION -->

                                                <tr class="instruction">
                                                    <td>
                                                        <table>
                                                            <tr>
                                                                <td>Please read instruction overfeat / कृप्या पीछे दिए गए निर्देशों को पढ़ लें <br><span style="font-size: 5.5px;">Please mention name and other details (if any) on the back of the cheque</span> <br>कृप्या चैक के पीछे नाम एवं अन्य विवरण (यदि कोई है तो) लिखे| <br>* <span style="font-size: 5.5px;">Please provide payer details as Customer ID Policy Number Application <br>Number Bill No. Property ID Challan No. Customer code given by your service provider</span></td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr><!-- END: INSTRUCTION -->
                                            </tbody>
                                        </table>
                                    </td>
                                    <td width="1%"></td>
                                </tr>
                            </table>
                        </td><!-- END: CUSTOMER PAY SLIP -->


                        <!-- START: BANK PAY SLIP -->

                        <td class=" bank-pay-slip" valign="top" width="62%">
                            <table class=" border-all" cellpadding="0" cellspacing="0" width="100%" style=" background-color: #fff; border: 1px solid #545252;">
                                <tbody>
                                    <!-- START: TOP LOGO BAR -->
                                    <tr><td height="2" style="line-height: 5px;"></td></tr>
                                    <tr>
                                        <td>
                                            <table cellpadding="0" cellspacing="0"  width="100%">
                                                <tbody>
                                                    <tr>
                                                        <td width="30%"><img src="images/logo-02.jpg" alt="" class="img-fluid" style="max-width: 100%;"></td>

                                                        <td class="title" style=" text-align: center;" align="center" width="40%">
                                                            PAY IN SLIP / जमा पर्ची<br>
                                                                Bank Copy /<span  style="font-weight: bold;">बैंक कॉपी</span>
                                                        </td>

                                                        <td class="secure-pay text-right" width="29%" align="right"><img src="images/secure-pay.jpg" alt="" class="img-fluid" style="height: 26px;"></td>
                                                        <td width="1%"></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr><!-- END: TOP LOGO BAR -->

                                    <tr>
                                        <td height="2"></td>
                                    </tr>

                                    <!-- START: DATE AND BRANCH NAME -->

                                    <tr>
                                        <td>
                                            <table width="100%" cellpadding="0" cellspacing="0" >
                                                <tbody>
                                                    <tr>
                                                        <!-- START: DEPOSITED IN BRANCH -->
                                                        <td width="60%">
                                                            <table width="90%" cellpadding="0" cellspacing="0">
                                                                <tbody>
                                                                    <tr>
                                                                        <td class="deposited-branch-title" width="40%">Deposited in Branch:<br>जमा कर्ता शाखा का नाम</td>
                                                                        <td class="deposited-branch" style=" border-bottom: 1px solid #545252;" width="60%">&nbsp;<br>Hisar</td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td><!-- END: DEPOSITED IN BRANCH -->


                                                        <!-- START: DATE -->

                                                        <td width="40%">
                                                            <table width="100%" cellpadding="0" cellspacing="0">
                                                                <tbody>
                                                                    <tr>
                                                                        <td class="date-title text-right" style="  text-align: right;" align="right" width="25%">Date:<br>दिनांक:</td>

                                                                        <td class="date" width="75%">
                                                                            <table width="100%" cellpadding="0" cellspacing="0"  style=" border-bottom: 1px solid #545252; border-right: 1px solid #545252;">
                                                                                <tbody>
                                                                                    <tr>
                                                                                        <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="8" align="center">
                                                                                        </td>

                                                                                        <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="8" align="center">
                                                                                        </td>

                                                                                        <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="8" align="center">
                                                                                        </td>

                                                                                        <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="8" align="center">
                                                                                        </td>

                                                                                        <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="8" align="center">
                                                                                        </td>

                                                                                        <td style=" border-left: 1px solid #545252; border-top: 1px solid #545252; text-align: center;" width="16.66%" height="8" align="center">
                                                                                        </td>
                                                                                    </tr>
                                                                                </tbody>
                                                                            </table>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td><!-- END: DATE -->
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr><!-- END: DATE AND BRANCH NAME -->

                                    <tr>
                                        <td height="2"></td>
                                    </tr>

                                    <!-- START: PAY TO -->

                                    <tr class="pay-to">
                                        <td style="  ">
                                            <table width="100%" cellpadding="1" cellspacing="0" >
                                                <tbody>
                                                    <tr>
                                                        <td  width="20%">Pay To:
                                                            <br>अदा करे:</td>
                                                        <td class="pay-to border-bottom" style=" border-bottom: 1px solid #565354;" width="80%">&nbsp;<br>CignaTTK Health Insurance Co. Ltd.</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr><!-- END: PAY TO -->

                                    <!-- START: PAYER NAME -->

                                    <tr class="payer-name">
                                        <td>
                                            <table width="100%" cellpadding="1" cellspacing="0" >
                                                <tbody>
                                                    <tr>
                                                        <td width="20%">Payer
                                                            Name:<br>भुगतान कर्ता का
                                                            नाम:</td>
                                                        <td class="payer border-bottom" style=" border-bottom: 1px solid #565354;" width="80%">&nbsp;<br>Sunil Soni</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr><!-- END: PAYER NAME -->

                                    <!-- START: PAYER DETAIL 1 -->

                                    <tr class="payer-detail">
                                        <td>
                                            <table width="100%" cellpadding="1" cellspacing="0" >
                                                <tbody>
                                                    <tr>
                                                        <td  width="20%">Payer Detail 1*<br>भुगतान कर्ता विवरण १*</td>
                                                        <td class="payer-detail border-bottom" style=" border-bottom: 1px solid #565354;" width="80%">&nbsp;<br>01231456789</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr><!-- END: PAYER DETAIL 1 -->
                                    <!-- START: PAYER DETAIL 2 -->

                                    <tr class="payer-detail">
                                        <td>
                                            <table width="100%" cellpadding="1" cellspacing="0">
                                                <tbody>
                                                    <tr>
                                                        <td width="20%">Payer Detail 2*<br>भुगतान कर्ता विवरण २*</td>
                                                        <td class="payer-detail border-bottom" style=" border-bottom: 1px solid #565354;" width="80%">&nbsp;<br></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr><!-- END: PAYER DETAIL 2 -->

                                    <!-- START: PAYER DETAIL 3 -->

                                    <tr class="payer-detail">
                                        <td>
                                            <table width="100%" cellpadding="0" cellspacing="0">
                                                <tbody>
                                                    <tr>
                                                        <td width="20%">Payer Detail 3*<br>भुगतान कर्ता
                                                            विवरण ३</td>
                                                        <td class="payer-detail border-bottom" style=" border-bottom: 1px solid #565354;" width="80%">&nbsp;<br></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr><!-- END: PAYER DETAIL 3 -->

                                    <tr>
                                        <td height="2"></td>
                                    </tr>

                                    <!-- START: CONTACT NUMBERS -->

                                    <tr class="contact-number">
                                        <td>
                                            <table cellpadding="0" cellspacing="0" width="100%" style="  border-bottom: 1px solid #565354; border-top: 1px solid #545252; border-left: 1px solid #545252;">
                                                <tbody>
                                                    <tr>
                                                        <!-- START: CONTACT NO. 1 -->
                                                        <td width="50%">
                                                            <table width="100%" cellpadding="0" cellspacing="0">
                                                                <tbody>
                                                                    <tr>
                                                                        <td  style=" text-align: center; font-size: 5.6px; border-right: none;" align="center" width="30%"><span>CONTACT NO. 1 / दूरभाष स. १</span></td>
                                                                        <td class="contact-number" style="text-align: center; line-height: 13px;" width="70%">
                                                                            <table width="100%" cellpadding="0" cellspacing="0" style=" border-right: 1px solid #545252;">
                                                                                <tbody>
                                                                                    <tr>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                    </tr>
                                                                                </tbody>
                                                                            </table>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td><!-- END: CONTACT NO. 1 -->

                                                        <!-- START: CONTACT NO. 2 -->

                                                        <td width="50%">
                                                            <table width="100%" cellpadding="0" cellspacing="0">
                                                                <tbody>
                                                                    <tr>
                                                                        <td  style=" text-align: center; border-right: none; font-size: 5.6px;" width="30%" align="center"><span>CONTACT NO. 2 / दूरभाष स. २</span></td>

                                                                        <td class="contact-number" width="70%">
                                                                            <table cellspacing="0" cellpadding="0" width="100%" style="line-height: 13px; text-align: center;">
                                                                                <tbody>
                                                                                    <tr>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                        <td style="border-left: 1px solid #545252;" width="10%">9</td>
                                                                                    </tr>
                                                                                </tbody>
                                                                            </table>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td><!-- END: CONTACT NO. 2 -->
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr><!-- END: CONTACT NUMBERS -->

                                    <tr>
                                        <td height="2"></td>
                                    </tr>


                                    <!-- START: DEPOSITE TABLE -->

                                    <tr class="deposite-table">
                                        <td>
                                            <table cellpadding="0" cellspacing="0" width="100%">
                                                <tbody>
                                                    <tr>

                                                        <!-- START: CHEQUE DEPOSITE -->
                                                        <td width="62%" valign="top">
                                                            <table cellpadding="0" cellspacing="0" width="100%">
                                                                <tbody>
                                                                    <tr>
                                                                        <td width="8%">
                                                                            <img src="images/cheque_detail_01.jpg" alt="" style="height: 90px;">
                                                                        </td>
                                                                        <td class=" cheque-deposite-table" valign="top" width="92%">
                                                                            <table width="100%" cellpadding="0" cellspacing="0" style="border: 1px solid #545252; line-height: 10px;">
                                                                                <thead class=" bg-grey border-bottom" style="background-color: #bdbfc1; border-bottom: 1px solid #565354; text-align: center">
                                                                                    <tr>
                                                                                        <th style="background-color: #bdbfc1; border-right: 1px solid #545252; border: 1px solid #545252; font-size: 7px; text-align: center; line-height: 10px;" width="66%">BANK &amp;
                                                                                            BRANCH NAME / बैंक और शाखानाम</th>
                                                                                        <th width="34%" style="background-color: #bdbfc1; text-align: center; font-size: 6px; line-height: 10px; border: 1px solid #545252; ">CHEQUE NO. / चैक संख्या</th>
                                                                                    </tr>
                                                                                </thead>
                                                                                <tbody style="text-align: center">
                                                                                    <tr>
                                                                                        <td style="border: 1px solid #545252;" width="66%">Punjab National Bank</td>

                                                                                        <td style="border: 1px solid #545252;" width="34%">123456789</td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <td style="border: 1px solid #545252;">Branch Name</td>

                                                                                        <td style="border: 1px solid #545252;"></td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <td style="border: 1px solid #545252;"></td>

                                                                                        <td style="border: 1px solid #545252;"></td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <td style="border: 1px solid #545252;"></td>

                                                                                        <td style="border: 1px solid #545252;"></td>
                                                                                    </tr>
                                                                                </tbody>

                                                                                <tfoot>
                                                                                    <tr>
                                                                                        <td colspan="2" height="18">TOTAL AMOUNT RUPEES (in words) /कुल राशि रुपये (शब्दों में)</td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <td colspan="2" style="border: none; border-top: 1px solid #545252; padding-bottom: 5px;">
                                                                                            <table width="100%" cellspacing="2" cellpadding="0" style=" border: none;">
                                                                                                <tbody>
                                                                                                    <tr>
                                                                                                        <td width="70%" style=" border: none; border-bottom: 1px solid #545252;">15,000.00</td>
                                                                                                        <td>ONLY / मात्र</td>
                                                                                                    </tr>
                                                                                                </tbody>
                                                                                            </table>
                                                                                        </td>
                                                                                    </tr>
                                                                                </tfoot>
                                                                            </table>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>

                                                            <table cellpadding="0" cellspacing="0" width="100%">
                                                                <thead class="bg-grey " style="background-color: #bdbfc1;  text-align: center">
                                                                    <tr>
                                                                        <td colspan="2" class="border-bottom" style=" border-bottom: 1px solid #565354;  font-weight: bold;" height="12">FOR OFFICE USE ONLY / केवल
                                                                            कार्यालय उपयोग हेतु</td>
                                                                    </tr>
                                                                </thead>

                                                                <tbody>
                                                                    <tr>
                                                                        <td width="30%" style="font-size: 7px;">TRAN. ID<br>कार्य व्यवहार संख्या</td>
                                                                        <td></td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td><!-- END: CHEQUE DEPOSITE -->


                                                        <!-- START: CASH DEPOSITE -->

                                                        <td width="38%" valign="top">
                                                            <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #363435;">
                                                                <tbody>
                                                                    <tr>
                                                                        <td style="border-top: 1px solid #545252;" width="10%">
                                                                            <img src="images/cheque_detail_02.jpg" alt="" style="height: 122px;">
                                                                        </td>

                                                                        <td class=" border-top" style="  border-top: 1px solid #545252;"
                                                                            width="90%" valign="top">
                                                                            <table width="100%" cellspacing="0" cellpadding="0" class="cash-deposite-table" style="background-color: #fff;">
                                                                                <thead class="bg-grey" style="background-color: #bdbfc1; ">
                                                                                    <tr>
                                                                                        <th width="31%" style=" border-right: 1px solid #545252; border-bottom: 1px solid #545252; background-color: #bdbfc1; font-size: 5.5px; line-height: 10px;">DEVO./मूल्यवर्ग</th>

                                                                                        <th style="background-color: #bdbfc1;  border-right: 1px solid #545252; border-bottom: 1px solid #545252; font-size: 6px; text-align: center;" width="18%">PIECES<br>प्रति</th>

                                                                                        <th width="33%" style="background-color: #bdbfc1; padding: 0;  border-right: 1px solid #545252; text-align: center; border-bottom: 1px solid #545252; line-height: 10px;">₹/ रु.</th>

                                                                                        <th style=" background-color: #bdbfc1; border-bottom: 1px solid #545252; line-height: 10px;" width="18%">Ps./ पै.</th>
                                                                                    </tr>
                                                                                </thead>

                                                                                <tbody>
                                                                                    <tr>
                                                                                        <th style=" text-align: right;  border-right: 1px solid #545252; border-bottom: 1px solid #545252; background-color: #bdbfc1; "
                                                                                            align="right">2000 x&nbsp;&nbsp;</th>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252;" height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252;" height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;" height="5"></td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <th style=" text-align: right;  border-right: 1px solid #545252; border-bottom: 1px solid #545252; background-color: #bdbfc1; "
                                                                                            align="right">500 x&nbsp;&nbsp;</th>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;" height="5"></td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <th style=" text-align: right;  border-right: 1px solid #545252; border-bottom: 1px solid #545252; background-color: #bdbfc1; "
                                                                                            align="right">200 x&nbsp;&nbsp;</th>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  "
                                                                                            height="5"></td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <th style=" text-align: right;  border-right: 1px solid #545252; border-bottom: 1px solid #545252; background-color: #bdbfc1; "
                                                                                            align="right">100 x&nbsp;&nbsp;</th>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  "
                                                                                            height="5"></td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <th style=" text-align: right;  border-right: 1px solid #545252; border-bottom: 1px solid #545252; background-color: #bdbfc1; "
                                                                                            align="right">50 x&nbsp;&nbsp;</th>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  "
                                                                                            height="5"></td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <th style=" text-align: right;  border-right: 1px solid #545252; border-bottom: 1px solid #545252; background-color: #bdbfc1; "
                                                                                            align="right">20 x&nbsp;&nbsp;</th>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  "
                                                                                            height="5"></td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <th style=" text-align: right;  border-right: 1px solid #545252; border-bottom: 1px solid #545252; background-color: #bdbfc1; "
                                                                                            align="right">10 x&nbsp;&nbsp;</th>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  "
                                                                                            height="5"></td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <th style=" text-align: right;  border-right: 1px solid #545252; border-bottom: 1px solid #545252; background-color: #bdbfc1; "
                                                                                            align="right">5 x&nbsp;&nbsp;</th>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252; "
                                                                                            height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;" height="5"></td>
                                                                                    </tr>

                                                                                    <tr>
                                                                                        <th style=" text-align: right;  border-right: 1px solid #545252; border-bottom: 1px solid #545252; background-color: #bdbfc1; font-size: 5px;" align="right">COINS<br>सिक्के&nbsp;&nbsp;</th>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252;" height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;  border-right: 1px solid #545252;" height="5"></td>

                                                                                        <td style=" border-bottom: 1px solid #545252;" height="5"></td>
                                                                                    </tr>
                                                                                </tbody>

                                                                                <tfoot>
                                                                                    <tr>
                                                                                        <td height="16" style=" background-color: #bdbfc1;  border-right: 1px solid #545252; font-size: 6px; text-align: center;">TOTAL<br>कुल</td>
                                                                                    </tr>
                                                                                </tfoot>
                                                                            </table>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td><!-- END: CASH DEPOSITE -->
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr><!-- END: DEPOSITE TABLE -->
                                    <!-- START: FOOTER -->

                                    <tr class="footer">
                                        <td class="border-top">
                                            <table width="100%" cellpadding="0" cellspacing="0" style=" border-top: 1px solid #545252; border-left: 1px solid #545252;">
                                                <tbody>
                                                    <tr>
                                                        <td class="border-right border-bottom" style=" border-right: 1px solid #545252; border-bottom: 1px solid #565354;"
                                                            width="75.2%">
                                                            <table width="100%" cellpadding="0" cellspacing="0">
                                                                <tbody>
                                                                    <tr>
                                                                        <td class="border-right p-2 "
                                                                            width="50%" style="  font-weight: bold; border-right: 1px solid #545252; padding: 2px;">SIGN
                                                                            OF OFFICER<br>अधिकारी
                                                                            के हस्ताक्षर</td>
                                                                        <td class="p-2 " style=" font-weight: bold;  padding: 2px;">SIGN
                                                                            OF VERIFYING OFFICER<br>प्रमाणित
                                                                            अधिकारी के हस्ताक्षर</td>
                                                                    </tr>

                                                                    <tr>
                                                                        <td colspan="2" class="border-top p-2" style=" border-top: 1px solid #545252; padding: 2px; "><span
                                                                                >Branch
                                                                                staff should ensure that the customer
                                                                                has mentioned the name and the other
                                                                                details on the back of the Cheque/DD/PO</span><br
                                                                            >बैंक
                                                                            स्टाफ जाँच ले की चैक/डीडी/पीओ के पीछेग्राहक
                                                                            का नाम और सम्पर्क न. लिखा है|</td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </td>

                                                        <td width="24.8%" class="  p-2 border-bottom"
                                                            style="  text-align: center; border-bottom: 1px solid #565354; padding: 2px; "
                                                            align="center">&nbsp;<br><br>NAME AND SIGN OF DEPOSITER<br
                                                            >जमाकर्ता के हस्ताक्षर</td>
                                                    </tr>

                                                    <tr>
                                                        <td colspan="2" class="p-2" style=" padding: 2px; ">
                                                            NOTE:* Branch staff should ensure that customer has filled
                                                            the details correctly as per the process <br>नोट:*
                                                            बैंक स्टाफ ग्राहक के विवरण की प्रक्रिया के अनुसारजाँच ले</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr><!-- END: FOOTER -->
                                </tbody>
                            </table>
                        </td><!-- END: BANK PAY SLIP -->
                    </tr>
                </tbody>
            </table>
        </td>
    </tr>
</table>
EOF;

// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');


// reset pointer to the last page
$pdf->lastPage();

// ---------------------------------------------------------

//Close and output PDF document
$pdf->Output('example_061.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
?>