<?php
//============================================================+
// File name   : example_002.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 002 for TCPDF class
//               Removing Header and Footer
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+
/**
* Creates an example PDF TEST document using TCPDF
* @package com.tecnick.tcpdf
* @abstract TCPDF - Example: Removing Header and Footer
* @author Nicola Asuni
* @since 2008-03-04
*/
// Include the main TCPDF library (search for installation path).
require_once('config/tcpdf_config.php');
require_once('tcpdf.php');
// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('cigna');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$pdf->setCellHeightRatio(1.2);
// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
require_once(dirname(__FILE__).'/lang/eng.php');
$pdf->setLanguageArray($l);
}

$pdf->StartTransform();
$pdf->Rotate(-90);
$pdf->Cell(0,0,'This is a sample data',1,1,'L',0,'');
$pdf->StopTransform();
// ---------------------------------------------------------
// set font
$pdf->SetFont('freesans', '', 8);

// add a page
$pdf->AddPage();
$pdf->setPrintFooter(false);

/* NOTE:
* *********************************************************
* You can load external XHTML using :
*
* $html = file_get_contents('/path/to/your/file.html');
*
* External CSS files will be automatically loaded.
* Sometimes you need to fix the path of the external CSS.
* *********************************************************
*/
// define some HTML content with style

$html = <<<EOF
<!-- first page -->
<!--header-->
<!DOCTYPE html>
<html>
   <body>
   <style>
    
   .border {
        border: 2px solid red;
        
    }



</style>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
         <tr>
            <td valign="top"><table width="100%" border="0" cellpadding="0" cellspacing="0">
              <tr>
                <td align="right"><img src="images/logo.png" alt="" style="width:160px;" /></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td width="50%" valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td><b>Proposal Form No.:</b></td>
                        <td>PROPRM050004139</td>
                      </tr>
                      <tr>
                        <td><b>Application Received Date :</b></td>
                        <td>20/06/2022</td>
                      </tr>
                    </table></td>
                    <td width="50%">&nbsp;</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td align="center">&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" cellpadding="8" cellspacing="0">
                  <tr>
                    <td width="20%"></td>
                    <td width="60%" style="text-align:center;  border:solid 1px #000000; font-size:14px;"><strong>MANIPALCIGNA PROHEALTH PRIME INSURANCE</strong></td>
                    <td width="20%"></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td><table width="300" border="0" cellspacing="0" cellpadding="8">
                      <tr>
                        <td style="background-color:#006cae; color:#ffffff;  font-size:12px;"><strong>1. PROPOSER DETAILS:</strong></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="6" style="border:solid 1px #000000;">
                  <tr>
                    <td width="30%"><strong>Name :</strong></td>
                    <td width="10%">&nbsp;</td>
                    <td width="60%">Mrs. Meka Renuka Devi</td>
                  </tr>
                  <tr>
                    <td><strong>Gender :</strong></td>
                    <td>&nbsp;</td>
                    <td>Female</td>
                  </tr>
                  <tr>
                    <td><strong>DOB :</strong></td>
                    <td>&nbsp;</td>
                    <td>15/06/1971</td>
                  </tr>
                  <tr>
                    <td><strong>Marital Status :</strong></td>
                    <td>&nbsp;</td>
                    <td>Married</td>
                  </tr>
                  <tr>
                    <td><strong>Permanent Address :</strong></td>
                    <td>&nbsp;</td>
                    <td>PLOT NO-74,SILPA BRINDAVAN, SHEMSIGUDA, NEAR YELLAMMA,<br />
                      BANDA KUKATPALLY HYDERABAD HYDERABAD TELANGANA - 500072<br />
                      Hyderabad,<br />
                      Telangana-500072. </td>
                  </tr>
                  <tr>
                    <td><strong>Correspondence Address :</strong></td>
                    <td>&nbsp;</td>
                    <td>PLOT NO-74,SILPA BRINDAVAN, SHEMSIGUDA, NEAR YELLAMMA,<br />
                      BANDA KUKATPALLY HYDERABAD HYDERABAD TELANGANA - 500072<br />
                      Hyderabad,<br />
                      Telangana-500072.</td>
                  </tr>
                  <tr>
                    <td><strong>Email Address :</strong></td>
                    <td>&nbsp;</td>
                    <td><a href="mailto:srinir1965@gmail.com" style="color:#000000; text-decoration:none;">srinir1965@gmail.com</a></td>
                  </tr>
                  <tr>
                    <td valign="top"><strong>Telephone number(s) :</strong></td>
                    <td>&nbsp;</td>
                    <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td width="40%">Mobile :</td>
                        <td width="40%">null-9704170033</td>
                        <td width="20%">&nbsp;</td>
                      </tr>
                      <tr>
                        <td>Residence(Optional) :</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                      </tr>
                      <tr>
                        <td>Office :</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                      </tr>
                    </table></td>
                  </tr>
                  <tr>
                    <td><strong>Would you like to subscribe to important alert<br />
                      on Whatsapp :</strong></td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td><strong>Would you like to go digital and receive all<br />
                      policy related information in soft copy/via<br />
                      email only?</strong></td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td><b>Occupation :</b></td>
                    <td>&nbsp;</td>
                    <td>Private Service</td>
                  </tr>
                  <tr>
                    <td><b>Annual Income :</b></td>
                    <td>&nbsp;</td>
                    <td>5-10 L</td>
                  </tr>
                  <tr>
                    <td><b>Educational Qualification :</b></td>
                    <td>&nbsp;</td>
                    <td>Graduate</td>
                  </tr>
                  <tr>
                    <td><b>Nationality :</b></td>
                    <td>&nbsp;</td>
                    <td>India</td>
                  </tr>
                  <tr>
                    <td><b>Pan Card Number :</b></td>
                    <td>&nbsp;</td>
                    <td><b>GSTIN :</b></td>
                  </tr>
                  <tr>
                    <td><strong>Aadhaar number/ (VID number) :</strong></td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="0" cellpadding="0" cellspacing="0">
                  <tr>
                    <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #000;">
                      <tr>
                        <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="6">
                          <tr>
                            <td width="30%"><strong>Family Physician Details</strong></td>
                            <td width="10%">&nbsp;</td>
                            <td width="60%"></td>
                          </tr>
                          <tr>
                            <td>Name :</td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                          <tr>
                            <td>Contact Number :</td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                          <tr>
                            <td>Email ID:</td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                          <tr>
                            <td>Address:</td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                        </table></td>
                      </tr>
                    </table></td>
                  </tr>
                  <tr>
                    <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #000;">
                      <tr>
                        <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="6">
                          <tr>
                            <td width="30%"><strong>Care Giver Details</strong></td>
                            <td width="10%">&nbsp;</td>
                            <td width="60%"></td>
                          </tr>
                          <tr>
                            <td>Name :</td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                          <tr>
                            <td>Relationship with Proposer :</td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                          <tr>
                            <td>Age :</td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                          <tr>
                            <td>Email Id :</td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                          <tr>
                            <td>Mobile no :</td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                        </table></td>
                      </tr>
                    </table></td>
                  </tr>
                  <tr>
                    <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #000;">
                      <tr>
                        <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="6">
                          <tr>
                            <td width="30%"><strong>Is Employer Payor :</strong></td>
                            <td width="10%">&nbsp;</td>
                            <td width="60%"></td>
                          </tr>
                          <tr>
                            <td><strong>Employee Id :</strong></td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                          <tr>
                            <td><strong>Employee Name :</strong></td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                          <tr>
                            <td><strong>Corporate Name :</strong></td>
                            <td>&nbsp;</td>
                            <td></td>
                          </tr>
                        </table></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td><table width="300" border="0" cellspacing="0" cellpadding="8">
                      <tr>
                        <td style="background-color:#006cae; color:#ffffff; font-size:12px;"><strong>2. POLICY/PLAN DETAILS:</strong></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="0" cellpadding="6" cellspacing="0" style="border:solid 1px #000000;">
                  <tr>
                    <td width="20%"><strong>Plan Type :</strong></td>
                    <td width="20%">Individual</td>
                    <td width="5%" valign="top">&nbsp;</td>
                    <td width="20%" valign="top"><strong>Floater Type(if opted) :</strong></td>
                    <td width="20%" valign="top"><strong>Adult :</strong></td>
                    <td width="15%" valign="top"><strong>Child :</strong></td>
                  </tr>
                  <tr>
                    <td><strong>Sum Insured :</strong></td>
                    <td>10L</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top"><strong>Plan Name :</strong></td>
                    <td valign="top">ProHealth Prime - Protect.</td>
                    <td valign="top">&nbsp;</td>
                  </tr>
                  <tr>
                    <td>Optional <strong>Deductible</strong>:</td>
                    <td>NA</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top"><strong>Tenure :</strong></td>
                    <td valign="top">1 Year</td>
                    <td valign="top">&nbsp;</td>
                  </tr>
                  <tr>
                    <td><strong>Applicable Discount :</strong></td>
                    <td>Family Discount ,</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top">&nbsp;</td>
                  </tr>
                  <tr>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top">&nbsp;</td>
                  </tr>
                  <tr>
                    <td><strong>Optional Cover &amp; Add-on:</strong></td>
                    <td>PRIME NON MEDICAL ITEMS -</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top">&nbsp;</td>
                  </tr>
                  <tr>
                    <td><strong>Zone:</strong></td>
                    <td>ZONE2</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top"><strong>Portability :</strong></td>
                    <td valign="top">YES</td>
                    <td valign="top">&nbsp;</td>
                  </tr>
                  <tr>
                    <td><strong>Migration :</strong></td>
                    <td>&nbsp;</td>
                    <td valign="top">&nbsp;</td>
                    <td valign="top"><strong>Premium payment mode :</strong></td>
                    <td valign="top">Single</td>
                    <td valign="top">&nbsp;</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td><table width="300" border="0" cellspacing="0" cellpadding="8">
                      <tr>
                        <td style="background-color:#006cae; color:#ffffff; font-size:12px;"><strong>3. INSURED DETAILS:</strong></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="1" cellpadding="6" cellspacing="0">
                  <tr>
                    <td width="40%"><strong>Is Insured Address Different</strong></td>
                    <td width="30%"><strong>Name</strong></td>
                    <td width="30%"><strong>Address</strong></td>
                  </tr>
                  <tr>
                    <td>NO</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="1" align="center" cellpadding="2" cellspacing="0" style="text-align:center;">
                  <tr>
                    <td width="3%"><strong>Sr No</strong></td>
                    <td width="10%"><strong>Name (First, Middle, Last) </strong></td>
                    <td width="7%"><strong>Gender</strong></td>
                    <td width="7%"><strong>DOB</strong></td>
                    <td width="13%"><strong>Relationship with Proposer</strong></td>
                    <td width="8%"><strong>Height(Cms)</strong></td>
                    <td width="5%"><strong>Weight (Kgs)</strong></td>
                    <td width="10%"><strong>Gainful Annual Income</strong></td>
                    <td width="10%"><strong>Occupation</strong></td>
                    <td width="10%"><strong>City</strong></td>
                    <td width="5%"><strong>Deductible</strong></td>
                    <td width="10%"><strong>Sum Insured</strong></td>
                    <td width="2%"><strong>PEP</strong></td>
                  </tr>
                  <tr>
                    <td>1</td>
                    <td>Meka Renuka Devi </td>
                    <td>Female</td>
                    <td>15/06/1971</td>
                    <td>SELF PRIMARY
                      MEMBER </td>
                    <td>157.47</td>
                    <td>58.00</td>
                    <td>&nbsp;</td>
                    <td>Private
                      Service </td>
                    <td>Hyderabad </td>
                    <td>&nbsp;</td>
                    <td>1000000</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>2</td>
                    <td>MEKA LAKSHMI VARSHA</td>
                    <td>Female</td>
                    <td>06/12/1995</td>
                    <td>DAUGHTER</td>
                    <td>162.56</td>
                    <td>50.00</td>
                    <td>&nbsp;</td>
                    <td>Private
                      Service</td>
                    <td>Hyderabad</td>
                    <td>&nbsp;</td>
                    <td>1000000</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>3</td>
                    <td>MEKA VINEESHA</td>
                    <td>Female</td>
                    <td>19/06/1997</td>
                    <td>DAUGHTER</td>
                    <td>167.63</td>
                    <td>60.00</td>
                    <td>&nbsp;</td>
                    <td>Any Other</td>
                    <td>Hyderabad</td>
                    <td>&nbsp;</td>
                    <td>1000000</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>4</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>5</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>6</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>7</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>8</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="1" cellpadding="6" cellspacing="0">
                  <tr>
                    <td width="40%">All insured Indian national and Indian residents?</td>
                    <td width="60%" style="text-align:center;">YES</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td><table width="300" border="0" cellspacing="0" cellpadding="8">
                      <tr>
                        <td style="background-color:#006cae; color:#ffffff; font-size:12px;"><strong>4. NOMINEE DETAILS:</strong></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table border="1" cellspacing="0" cellpadding="6" width="100%" align="center" style="text-align:center">
                  <tr>
                    <td width="20%"><strong>Nominee Name</strong></td>
                    <td width="80%">Ms. Meka Lakshmi Varsha </td>
                  </tr>
                  <tr>
                    <td><strong>Relationship With Proposer</strong></td>
                    <td>Daughter</td>
                  </tr>
                  <tr>
                    <td><strong>Nominee Age</strong></td>
                    <td>26</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table border="1" cellspacing="0" cellpadding="6" width="100%" align="center" style="text-align:center">
                  <tr>
                    <td width="20%"><strong>Appointee name</strong></td>
                    <td width="80%">&nbsp;</td>
                  </tr>
                  <tr>
                    <td><strong>Age</strong></td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td><strong>Relationship with Nominee </strong></td>
                    <td>&nbsp;</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td><table width="300" border="0" cellspacing="0" cellpadding="8">
                      <tr>
                        <td style="background-color:#006cae; color:#ffffff; font-size:12px;"><strong>5. MEDICAL AND LIFESTYLE INFORMATION*:</strong></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="1" cellspacing="0" cellpadding="5">
                  <tr>
                    <td width="50%">&nbsp;</td>
                    <td width="10%"><strong>Insured 1</strong></td>
                    <td width="10%"><strong>Insured 2</strong></td>
                    <td width="10%"><strong>Insured 3</strong></td>
                    <td width="10%"><strong>Insured 4</strong></td>
                    <td width="10%"><strong>Insured 5</strong></td>
                  </tr>
                  <tr>
                    <td>Has any of the applicant ever been diagnosed with or suspected to have Cancer
                      or Rheumatoid Arthritis or Ulcerative Colitis or Crohn's disease or Chronic
                      Liver Disease, Hepatitis B, Cirrhosis or Chronic Kidney Disease or Kidney
                      failure or Epilepsy or Fits or Stroke or Paralysis or Parkinsonism or Alzheimer's
                      or Multiple sclerosis or Brain Tumor or Cerebral Palsy or Heart Failure or Heart Attack or Angina or Coronary Artery Disease or Ischemic Heart Disease or
                      Chronic Bronchitis or Intestitial Lung Diseases or Pneumoconiosis or
                      Emphysema.</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>Does any proposed to be insured suffer from any terminal illness, seizure
                      disorders or any disease/deformity affecting or restricting mobility, sight,
                      hearing or speech?</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>Does any proposed to be insured’s occupation or nature of duties require them
                      to be a part of armed forces, expose them to hazardous substances/chemicals or
                      hazardous activities</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>Has any member ever suffered or currently suffering or under
                      treatment(operated , hospitalised, investigated) or been under medication for
                      more than a week for any medical condition. </td>
                    <td>YES</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>i. Diabetes Mellitus </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>ii. Hypertension </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>iii. High Cholestero </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>iv. Thyroid disorders </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>v. Heart and Lung disorders </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>vi. Digestive system disorders (Stomach and related organs) </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>vii. Brain, nerve and Psychiatric (Mental) disorders </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>viii. Other Endocrine (Hormonal) disorders </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>ix. Bone, joints and muscle disorders </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>x. Ear, nose, eye and throat disorders </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>xi. Genito-urinary and Gynaecological disorders </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>xii. Blood and related disorders </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>xiii. Skin disorders </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>xiv. Any other condition / illness / disorder / surgery </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Has any of the applicant recommended to undergo or has undergone any
                      pathologic or radiologic tests for any illness other than the ones listed above and
                      routine or annual health check-up? </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Is any applicant currently not in good health and undergoing any investigation
                      or treatment or medication for any illness or medical condition (Physical/
                      Mental/ Sleep disorders)? </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Smoke </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Since how long does the applicant smoke </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Tobacco </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>How many Pan masala / gutka packets does the applicant has in a day </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Alcohol </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>How frequently does the applicant consume alcohol </td>
                    <td>NO</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Is this a Portability case? </td>
                    <td>YES</td>
                    <td>YES</td>
                    <td>YES</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Pre - Existing Diseases 1 </td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Pre - Existing Diseases 2 </td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Pre - Existing Diseases 3 </td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Pre - Existing Diseases 4 </td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Pre - Existing Diseases 5 </td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td></td>
                    <td></td>
                  </tr>
                  <tr>
                    <td>Pre - Existing Diseases Others </td>
                    <td>Disorders of
                      thyroid gland (
                      E00-E07
                      ),Asthma ( J45
                      )</td>
                    <td>NO</td>
                    <td>NO</td>
                    <td></td>
                    <td></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="300" border="0" cellspacing="0" cellpadding="6">
                  <tr>
                    <td style="background-color:#006cae; color:#ffffff; font-size:12px;"><strong>6. ADDITIONAL MEDICAL  INFORMATION*:</strong></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="1" align="center" cellpadding="5" cellspacing="0" style="text-align:center;">
                  <tr>
                    <td><strong>Sr No</strong></td>
                    <td><strong>Name of
                      Insured</strong></td>
                    <td><strong>Exact
                      Diagnosis </strong></td>
                    <td><strong>Year Of
                      Diagnosis </strong></td>
                    <td><strong>Treatment
                      taken</strong></td>
                    <td><strong>Current status</strong></td>
                    <td><strong>Complications/
                      Recurrences</strong></td>
                    <td><strong>Last
                      consultation
                      date </strong></td>
                    <td><strong>Histo-Pathology
                      Examination Report
                      (only for surgical) </strong></td>
                  </tr>
                  <tr>
                    <td>1</td>
                    <td>Meka Devi</td>
                    <td>Asthma </td>
                    <td>2015 </td>
                    <td>Medical</td>
                    <td>On-TREATMENT</td>
                    <td>NO</td>
                    <td>2022-02-02 </td>
                    <td>No Abnormality</td>
                  </tr>
                  <tr>
                    <td>2</td>
                    <td>Meka Devi</td>
                    <td>Thyroid </td>
                    <td>2015 </td>
                    <td>Medical</td>
                    <td>On-TREATMENT</td>
                    <td>NO</td>
                    <td>2022-02-02 </td>
                    <td>No Abnormality</td>
                  </tr>
                  <tr>
                    <td>3</td>
                    <td>MEKA<br />
                      VINEESHA</td>
                    <td>Asthma </td>
                    <td>2015 </td>
                    <td>Medical</td>
                    <td>On-TREATMENT</td>
                    <td>NO</td>
                    <td>2022-02-02 </td>
                    <td>No Abnormality</td>
                  </tr>
                  <tr>
                    <td>4</td>
                    <td>Meka Devi</td>
                    <td>Thyroid</td>
                    <td>2015</td>
                    <td>Medical</td>
                    <td>On-TREATMENT</td>
                    <td>NO</td>
                    <td>2022-02-02</td>
                    <td>No Abnormality</td>
                  </tr>
                  <tr>
                    <td>4</td>
                    <td>Meka Devi</td>
                    <td>Asthma </td>
                    <td>2015 </td>
                    <td>Medical</td>
                    <td>On-TREATMENT</td>
                    <td>NO</td>
                    <td>2022-02-02 </td>
                    <td>No Abnormality</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="300" border="0" cellspacing="0" cellpadding="5">
                  <tr>
                    <td style="background-color:#006cae; color:#ffffff; font-size:12px;"><strong>7. PREVIOUS/CURRENT INSURANCE DETAILS*:</strong></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="1" align="center" cellpadding="5" cellspacing="0">
                  <tr>
                    <td width="5%"><strong>Insured</strong></td>
                    <td width="5%"><strong>Policy<br />
                      No</strong></td>
                    <td width="10%"><strong>Types of<br />
                      Policy</strong></td>
                    <td width="15%"><strong>Insurer<br />
                      Name</strong></td>
                    <td width="5%"><strong>From Date</strong></td>
                    <td width="5%"><strong>To Date</strong></td>
                    <td width="10%"><strong>Sum<br />
                      Insured</strong></td>
                    <td width="25%" colspan="3" valign="top"><strong>Claim Details</strong></td>
                    <td width="10%" colspan="2"><strong>Cumulative<br />
                      Bonus<br />
                      Earned</strong></td>
                    <td width="10%"><strong>Previous Policy<br />
                      Acceptance/Rejection<br />
                      Claim </strong></td>
                  </tr>
                  <tr>
                    <td colspan="7">&nbsp;</td>
                    <td>Claim <br />
                      Number</td>
                    <td>Claimed<br />
                      Amount</td>
                    <td>Ailment</td>
                    <td>%</td>
                    <td>Amount</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>1</td>
                    <td>2805<br />
                      2041<br />
                      8989<br />
                      8500<br />
                      000</td>
                    <td>MEDICLAIM </td>
                    <td>HDFC Ergo<br />
                      General<br />
                      Insurance<br />
                      Company<br />
                      LTD.</td>
                    <td>23/06/2021</td>
                    <td>22/06/2022</td>
                    <td>1000000</td>
                    <td>&nbsp;</td>
                    <td>0.00</td>
                    <td>&nbsp;</td>
                    <td>0.0</td>
                    <td>0.0</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>2</td>
                    <td>2805<br />
                      2041<br />
                      8989<br />
                      8500<br />
                      000</td>
                    <td>MEDICLAIM</td>
                    <td>HDFC Ergo<br />
                      General<br />
                      Insurance<br />
                      Company<br />
                      LTD.</td>
                    <td>Medical</td>
                    <td>On-TREATMENT</td>
                    <td>1000000</td>
                    <td>&nbsp;</td>
                    <td>0.00</td>
                    <td>&nbsp;</td>
                    <td>0.0</td>
                    <td>0.0</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>3</td>
                    <td>2805<br />
                      2041<br />
                      8989<br />
                      8500<br />
                      000</td>
                    <td>MEDICLAIM</td>
                    <td>HDFC Ergo<br />
                      General<br />
                      Insurance<br />
                      Company<br />
                      LTD.</td>
                    <td>Medical</td>
                    <td>On-TREATMENT</td>
                    <td>1000000</td>
                    <td>&nbsp;</td>
                    <td>0.00</td>
                    <td>&nbsp;</td>
                    <td>0.0</td>
                    <td>0.0</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>4</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                  <tr>
                    <td>5</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>^ Has any proposal for life, health, hospital daily cash or critical illness insurance on the life of the applicant ever been declined, postponed, loaded or been made subject to any<br />
                  special conditions such as exclusions by any insurance company?</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="300" border="0" cellspacing="0" cellpadding="6">
                  <tr>
                    <td style="background-color:#006cae; color:#ffffff; font-size:12px;"><strong>8. PAYMENT DETAILS*:</strong></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>Premium Amount:Rs.36070.75 in Words Rs.&quot;Thirty Six Thousand Seventy and Seventy Five paisa&quot;</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="1" align="center" cellpadding="6" cellspacing="0">
                  <tr>
                    <td width="5%"><strong>Sr No.</strong></td>
                    <td width="20%"><strong>Premium Paid by</strong></td>
                    <td width="15%"><strong>Payment Option</strong></td>
                    <td width="20%"><strong>Instrument/Transaction Number</strong></td>
                    <td width="20%"><strong>Instrument/Transaction Amount</strong></td>
                    <td width="20%"><strong>Instrument/Transaction Date</strong></td>
                  </tr>
                  <tr>
                    <td>1</td>
                    <td>Self</td>
                    <td>Direct Debit</td>
                    <td>pay_JjeeWbYaVtU1oy</td>
                    <td>36070.80</td>
                    <td>20/06/2022</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td height="23">Declaration & Authorisation*:</td>
                  </tr>
                  <tr>
                    <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td width="1%">&nbsp;</td>
                        <td width="99%"><ul>
                          <li>I/We hereby declare, on my behalf and on behalf of all persons proposed to be insured, that the above statements, answers and/ or particulars given by me are true
                            and complete in all respects to the best of my knowledge and that I/We am/are authorised to propose on behalf of these other persons.</li>
                          <li>I understand that the information provided by me will form the basis of the insurance policy, is subject to the Board approved underwriting policy of the insurance
                            company and that the policy will come into force only after full receipt of the premium chargeable.</li>
                          <li>I/We further declare that I/We will notify in writing any change occurring in the occupation or general health of the life to be insured/proposer after the proposal has
                            been submitted but before communication of the risk acceptance by the company.</li>
                          <li>I/We declare and consent to the company seeking medical information from any doctor or from a hospital who at anytime has attended on the life to be
                            insured/proposer or from any past or present employer concerning anything which affects the physical or mental health of the life to be assured/proposer and seeking
                            information from any insurance company to which an application for insurance on the life to be assured/proposer has been made for the purpose of underwriting the
                            proposal and/or claim settlement.</li>
                          <li>I/We authorize the company to share information pertaining to my proposal including the medical records for the sole purpose of proposal underwriting and/or
                            claims settlement and with any Government and/or Regulatory authority.</li>
                          <li>I hereby consent to and authorize ManipalCigna Health Insurance Company Limited (“Company”) and its representatives to collect, use, share and disclose
                            information provided by me, as per the privacy policy of the Company. Company or its representatives are also hereby authorised to contact me (including overriding
                            my registry on NCPR/NDNC and/or under any extant TRAI regulations) and / or notify about the services being rendered by the Company.</li>
                        </ul></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td valign="top">&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td height="23">Vernacular Declaration:</td>
                  </tr>
                  <tr>
                    <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td width="1%">&nbsp;</td>
                        <td width="99%"><ul>
                          <li>I hereby declare that, I have fully explained the contents of the proposal form and terms and conditions of the Policy to the Proposer in the language understood to
                            him/her and that the Proposer has affixed the thumb impression above after fully understanding the contents thereof.</li>
                        </ul></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td height="23">Advisor / Intermediary Declaration*:</td>
                  </tr>
                  <tr>
                    <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td width="1%">&nbsp;</td>
                        <td width="99%"><ul>
                          <li>I, Mr Zenmoney insurance Broking services pvt ltd in my capacity as an Insurance Advisor/ Specified Person of the Corporate Agent/Authorised employee of the
                            Broker/Relationship Officer, do hereby declare that I have explained all the contents of this Proposal Form, including the nature of the questions contained in this
                            Proposal Form to the Proposer including statement(s), information and response(s) submitted by him/her in this Proposal Form to questions contained herein or any
                            details sought herein that will form the basis of the Contract of Insurance between the Company and the Proposer, if this Proposal is accepted by the Company for
                            issuance of the Policy. I further confirm that I have explained the product features, terms and conditions to the prospect and the product opted is suitable to the needs
                            of the customer.</li>
                          <li>I have further explained that if any untrue statement(s)/information/response(s) is/are contained in this Proposal Form/including addendum(s), affidavits, statements,
                            submissions, furnished/to be furnished, the Company shall have the right to vary the benefits which may be payable and further more if there has been a
                            non-disclosure of any material fact, the Policy issued to his/her favour pursuant to this Proposal may be treated by the Company as null and void and all premiums
                            paid under the Policy may be forfeited to the company.</li>
                          <li>License No. / ID (Advisor/COrporate Agent/Broker/Relationship Officer):</li>
                        </ul></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td height="23">Section 41 of Insurance Act 1938 (Prohibition of rebates):</td>
                  </tr>
                  <tr>
                    <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td width="1%">&nbsp;</td>
                        <td width="99%" valign="top"><ul>
                          <li>No person shall allow or offer to allow, either directly or indirectly, as an inducement to any person to take or renew or continue an insurance in respect of any kind of risk relating to lives or property in India, any rebate of the whole or part of the commission payable or any rebate of the premium shown on the policy, nor shall any person taking out or renewing or continuing a policy accept any rebate, except such rebate as may be allowed in accordance with the published prospectuses or tables of the insurer.</li>
                          <li>Any person making default in complying with the provisions of this section shall be liable for a penalty which may extend to ten lakh rupees.</li>
                        </ul></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td height="23">I hereby declare that :</td>
                  </tr>
                  <tr>
                    <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td width="1%">&nbsp;</td>
                        <td width="99%"><ul>
                          <li>For premium paid through net banking or credit/debit card towards this application/policy , the payment is made only through net banking account or credit/debit
                            card issued on the name i.e. proposer/policyholder</li>
                          <li>The debit/credit card or net banking account used for Insurance PREMIUM payment belongs to me (i.e. proposer/policy holder).</li>
                          <li>Required Documents (if any) will be provided by me for processing of application /refund , whenever it is sought by the Company</li>
                          <li>PAN Card is mandatory if premium paid is Rs 50,000 and above accepted in Cash/DD or Rs 100,000 and above by Cheque/Credit/Debit Card)</li>
                          <li>NEFT Details shall be provided by me (proposer) either at the application stage or at the time of refund.</li>
                        </ul></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td style="text-align:center">&nbsp;</td>
              </tr>
              <tr>
                <td style="text-align:center">Insurance is a subject matter of solicitation</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                  <tr>
                    <td width="28%"  valign="middle"><table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                      <tr>
                       
                        <td width="100%" height="30" valign="middle" style="vertical-align:middle;line-height:30px;"><span><img src="images/a-icon.JPG" alt="" width="15" height="15" /></span>&nbsp;&nbsp;<strong>For any assistance contact</strong>
                        </td>
                      </tr>
                    </table></td>
                    <td width="18%" valign="middle" style="background-color: #003f68;"><table width="100%" border="0" align="center" cellpadding="3" cellspacing="0">
                      <tr>
                      <td width="100%" height="30" valign="middle" style="vertical-align:middle;line-height:30px;"><span><img src="images/p-icon.JPG" alt="" width="15" height="15" /></span>&nbsp;&nbsp;<strong style="color:#ffffff;">1800-102-4462</strong>
                        </td>
                        
                      </tr>
                    </table></td>
                    <td width="30%" valign="middle" style="background-color: #006db2;"><table width="100%" border="0" align="center" cellpadding="3" cellspacing="0">
                      <tr>
                        <td width="100%" height="30" valign="middle" style="vertical-align:middle;line-height:30px;"><span><img src="images/e-icon.JPG" alt="" width="15" height="15" /></span>&nbsp;&nbsp;<strong style="color:#ffffff;">customercare@manipalcigna.com</strong>
                        </td>
                      </tr>
                    </table></td>
                    <td width="22%" valign="middle" style="background-color: #00a2e3;"><table width="100%" border="0" align="center" cellpadding="3" cellspacing="0">
                      <tr>
                       <td width="100%" height="30" valign="middle" style="vertical-align:middle;line-height:30px;"><span><img src="images/m-icon.JPG" alt="" width="15" height="15" /></span>&nbsp;&nbsp;<strong style="color:#ffffff;">www.manipalcigna.com</strong>
                        </td>
                        
                      </tr>
                    </table></td>
                  </tr>
                  <tr>
                    <td colspan="4">&nbsp;</td>
                  </tr>
                  <tr>
                    <td colspan="4" style="text-align:center"><strong>ManipalCigna Health Insurance Company Limited</strong><br />
                      (Formerly known as CignaTTK Health Insurance Company Limited) | CIN U66000MH2012PLC227948 | IRDAI Reg. No. 151. <br />
                      Reg. Office: <strong>401/402, 4th Floor, Raheja Titanium, off. Western Express Highway, Goregaon (East), Mumbai- 400 063 </strong><br />
                      Toll free number – 1800-102-4462 | Website address – <a href="file:///C|/Users/dell/Downloads/cigna-form/cigna-form/www.manipalcigna.com" style="color:#000000; text-decoration:none;"><strong>www.manipalcigna.com </strong></a><br />
                      Trade Name / Trade Logo belongs to MEMG International India Private Limited and Cigna Intellectual Property Inc. and is being used by <br />
                      ManipalCigna Health Insurance Company Limited under license. <br /></td>
                  </tr>
                  <tr>
                    <td colspan="4" style="text-align:center">&nbsp;</td>
                  </tr>
                  <tr>
                    <td colspan="4" style="text-align:center">Product Name – ManipalCigna ProHealth Prime / UIN- MCIHLIP22224V012122<br />
                      URN - 2021/PPRI-S/V1.01/OFF</td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
            </table></td>
         </tr>
      </table>
</html>
EOF;
// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');
// reset pointer to the last page
$pdf->lastPage();
// ---------------------------------------------------------
//Close and output PDF document
$pdf->Output('example_061.pdf', 'I');
//============================================================+
// END OF FILE
//============================================================+
?>