<?php
//============================================================+
// File name   : example_002.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 002 for TCPDF class
//               Removing Header and Footer
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+
/**
* Creates an example PDF TEST document using TCPDF
* @package com.tecnick.tcpdf
* @abstract TCPDF - Example: Removing Header and Footer
* @author Nicola Asuni
* @since 2008-03-04
*/
// Include the main TCPDF library (search for installation path).
require_once('config/tcpdf_config.php');
require_once('tcpdf.php');
// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('cigna');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$pdf->setCellHeightRatio(1.2);
// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
require_once(dirname(__FILE__).'/lang/eng.php');
$pdf->setLanguageArray($l);
}
// ---------------------------------------------------------
// set font
$pdf->SetFont('freesans', '', 8);
// add a page
$pdf->AddPage();
/* NOTE:
* *********************************************************
* You can load external XHTML using :
*
* $html = file_get_contents('/path/to/your/file.html');
*
* External CSS files will be automatically loaded.
* Sometimes you need to fix the path of the external CSS.
* *********************************************************
*/
// define some HTML content with style
$html = <<<EOF
<!-- first page -->
<!--header-->
<table border="0" cellspacing="0" cellpadding="0" width="100%" >
   <tr>
      <td valign="top">
         <table width="100%"  border="0" cellspacing="0" cellpadding="0">
            <tr>
               <td width="22%">
                  <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border-bottom:solid 1px #000000;
                     ">
                     <tr>
                        <td>Proposal Form No.:</td>
                     </tr>
                     <tr>
                        <td></td>
                     </tr>
                     <tr>
                        <td></td>
                     </tr>
                  </table>
               </td>
               <td width="3%"></td>
               <td width="55%" style="margin-right:15px;"><b>ManipalCigna Health Insurance Company Limited</b><br> (Formerly known as CignaTTK Health Insurance Company Limited)<br>
                  Corporate Office: 401/402, Raheja Titanium, Western Express Highway,<br> Goregaon (E), Mumbai - 400063. IRDAI Registration No. 151.<br>
                  <b>Call (Toll Free): </b>1800-102-4462 <b>Visit:</b> www.manipalcigna.com<br> <b>E-mail:</b> customercare@manipalcigna.com
                  <b>CIN No.:</b> U66000MH2012PLC227948
               </td>
               <td width="20%"><img src="images/logo.png"></td>
            </tr>
         </table>
      </td>
   </tr>
</table>
<!--header end-->
<table width="100%" border="0" cellspacing="0" cellpadding="0">
   <tr>
      <td>
         <table width="100%" cellpadding="0" cellspacing="0" bgcolor="#ffffff">
            <tr>
               <td></td>
            </tr>
            <tr>
               <td></td>
            </tr>
            <tr>
               <td></td>
            </tr>
            <tr>
               <td align="center">
                  <table width="100%" cellpadding="0" cellspacing="0" align="center">
                     <tr>
                        <td width="22%" style=" text-align: center; text-transform: uppercase; color: #666666; font-weight: bold; border: solid 2px #000000; line-height:24px; height:180px; line-height:180px;"align="center">
                           Photograph of Insured 1
                        </td>
                        <td width="4%"></td>
                        <td width="22%" style=" text-align: center; text-transform: uppercase; color: #666666; font-weight: bold; border: solid 2px #000000; line-height:24px; height:180px; line-height:180px;"align="center">
                           Photograph of Insured 2
                        </td>
                        <td width="4%"></td>
                        <td width="22%" style=" text-align: center; text-transform: uppercase; color: #666666; font-weight: bold; border: solid 2px #000000; line-height:24px; height:180px; line-height:180px;"align="center">
                           Photograph of Insured 3
                        </td>
                        <td width="4%"></td>
                        <td width="22%" style=" text-align: center; text-transform: uppercase; color: #666666; font-weight: bold; border: solid 2px #000000; line-height:24px; height:180px; line-height:180px;"align="center">
                           Photograph of Insured 4
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td></td>
            </tr>
            <tr>
               <td></td>
            </tr>
            <tr>
               <td align="center">
                  <table width="100%" cellpadding="0" cellspacing="0" align="center">
                     <tr>
                        <td width="22%" style=" text-align: center; text-transform: uppercase; color: #666666; font-weight: bold; border: solid 2px #000000; line-height:24px; height:180px; line-height:180px;"align="center">
                           Photograph of Insured 5
                        </td>
                        <td width="4%"></td>
                        <td width="22%" style=" text-align: center; text-transform: uppercase; color: #666666; font-weight: bold; border: solid 2px #000000; line-height:24px; height:180px; line-height:180px;"align="center">
                           Photograph of Insured 6
                        </td>
                        <td width="4%"></td>
                        <td width="22%" style=" text-align: center; text-transform: uppercase; color: #666666; font-weight: bold; border: solid 2px #000000; line-height:24px; height:180px; line-height:180px;"align="center">
                           Photograph of Insured 7
                        </td>
                        <td width="4%"></td>
                        <td width="22%" style=" text-align: center; text-transform: uppercase; color: #666666; font-weight: bold; border: solid 2px #000000; line-height:24px; height:180px; line-height:180px;"align="center">
                           Photograph of Insured 8
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td>&nbsp;</td>
            </tr>
            <tr>
               <td>&nbsp;</td>
            </tr>
            <tr>
               <td></td>
            </tr>
            <tr>
               <td>
                  <table cellspacing="0" cellpadding="5" align="center">
                     <tr>
                        <td align="center" style="font-weight: bold; color: #fff; background-color: #474746; font-size: 14px;">
                           FOR OFFICE USE ONLY
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td>
                  <table width="100%" border="0" cellspacing="0" cellpadding="5" >
                     <tr>
                        <td style="border:solid 1px #000000">Branch Name</td>
                        <td style="border:solid 1px #000000">Branch Code:</td>
                     </tr>
                     <tr>
                        <td style="border:solid 1px #000000">Intermediary Name:</td>
                        <td style="border:solid 1px #000000">Intermediary Code: <span style="color:#cac8c8;">Agent Code / Broker Code / CA Code</span></td>
                     </tr>
                     <tr>
                        <td colspan="2" style="border:solid 1px #000000">Business Type: <span style="color:#cac8c8;">Urban /Social / Rural</span></td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td>
                  <table width="100%" border="0" cellspacing="0" cellpadding="5" >
                     <tr>
                        <td width="10%" style="border:solid 1px #000000; background-color:#000000; color:#ffffff;">Ops Tags:</td>
                        <td width="30%" style="border:solid 1px #000000">Employee DMS Code:
                           <span style="font-size:8px; color:#cac8c8;"> ManipalCigna Employee DMS Code</span>
                        </td>
                        <td width="30%" style="border:solid 1px #000000">Partner Vertical Name:
                           <span style="font-size:8px; color:#cac8c8;">Partner Business Vertical Code</span>
                        </td>
                        <td width="30%" style="border:solid 1px #000000">Partner Branch ID: <span style="font-size:8px; color:#cac8c8;"> Partner Branch Code</span></td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td height="30"></td>
            </tr>
            <tr>
               <td>
                  <table width="100%" border="0" cellspacing="0" cellpadding="5" >
                     <tr>
                        <td width="15%">Ref. A<br/>Ref. B</td>
                        <td width="70%" style="border:solid 1px #000000; text-align:center; font-size:18px;">
                           <b>MANIPALCIGNA PROHEALTH SELECT A</b> PROPOSAL FORM
                        </td>
                        <td width="15%" style="text-align:right">Ref. C</td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td height="30"></td>
            </tr>
            <tr>
               <td align="center">
                  <table width="100%" border="0" cellspacing="0" cellpadding="0"  align="center">
                     <tr>
                        <td style="width:100%;"><img src="images/ins-bg.png"></td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td height="30"></td>
            </tr>
            <tr>
               <td style="font-size:11px;">The issuance of this form by ManipalCigna Health Insurance Company Limited (the Company) does not amount to acceptance of proposal. The actual liability of the Company does not
                  commence until this proposal has been accepted by the Company and premium realized.
               </td>
            </tr>
            <tr>
               <td height="30"></td>
            </tr>
            <tr>
               <td style="font-size:14px; font-weight:bold;">I. PROPOSER DETAILS:</td>
            </tr>
            <!--perposal details form start-->
            <tr>
               <td>
                  <table width="100%" border="1" cellspacing="0" cellpadding="0">
                     <tr>
                        <td>
                           <table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="80%">
                                    <table width="100%" cellspacing="0" cellpadding="0">
                                       <tr>
                                          <td width="40%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                                                   <td width="12%">Title*</td>
                                                   <td width="5%">:</td>
                                                   <td width="10%">Mr</td>
                                                   <td width="2%">&nbsp;</td>
                                                   <td width="8%" style="border:solid px #000000;"></td>
                                                   <td width="6%">&nbsp;</td>
                                                   <td width="12%">Mrs.</td>
                                                   <td width="2%">&nbsp;</td>
                                                   <td width="8%" style="border:solid px #000000;"></td>
                                                   <td width="6%">&nbsp;</td>
                                                   <td width="12%">Ms.</td>
                                                   <td width="8%" style="border:solid px #000000;"></td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                                                   <td width="15%">Gender*</td>
                                                   <td width="5%">:</td>
                                                   <td width="12%">Male</td>
                                                   <td width="2%">&nbsp;</td>
                                                   <td width="6%" style="border:solid px #000000;"></td>
                                                   <td width="6%">&nbsp;</td>
                                                   <td width="15%">Female.</td>
                                                   <td width="2%">&nbsp;</td>
                                                   <td width="6%" style="border:solid px #000000;"></td>
                                                   <td width="6%">&nbsp;</td>
                                                   <td width="15%">Others.</td>
                                                   <td width="6%" style="border:solid px #000000;"></td>
                                                   <td width="6%">&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                       <tr>
                                          <td></td>
                                       </tr>
                                       <tr>
                                          <td width="50%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                                                   <td width="30%">Date of Birth*</td>
                                                   <td width="2%">:</td>
                                                   <td width="8%" style="border:solid 1px #666; border-right:none; text-align:center;  color:#999;">D</td>
                                                   <td width="8%" style="border:solid 1px #666;text-align:centter; border-right:none;color:#999;">D</td>
                                                   <td width="3%"></td>
                                                   <td width="8%" style="border:solid 1px #666; text-align:center; border-right:none;color:#999;">M</td>
                                                   <td width="8%" style="border:solid 1px #666;text-align:center; border-right:none;color:#999;">M</td>
                                                   <td width="3%"></td>
                                                   <td width="8%" style="border:solid 1px #666;color:#999; text-align:center">Y</td>
                                                   <td width="8%" style="border:solid 1px #666;color:#999;text-align:center">Y</td>
                                                   <td width="8%" style="border:solid 1px #666;color:#999; text-align:center">Y</td>
                                                   <td width="8%" style="border:solid 1px #666;color:#999;text-align:center">Y</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="58%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                                                   <td width="25%">&nbsp;&nbsp;Marital Status*</td>
                                                   <td width="2%">:</td>
                                                   <td width="14%">Married</td>
                                                   <td width="3%">&nbsp;</td>
                                                   <td width="6%" style="border:solid px #000000;"></td>
                                                   <td width="3%">&nbsp;</td>
                                                   <td width="12%">Single.</td>
                                                   <td width="2%">&nbsp;</td>
                                                   <td width="6%" style="border:solid px #000000;"></td>
                                                   <td width="3%">&nbsp;</td>
                                                   <td width="14%">Others.</td>
                                                   <td width="6%" style="border:solid px #000000;"></td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="5%" align="right"></td>
                                 <td width="15%">
                                    <table width="100%">
                                       <tr>
                                          <td width="60%">Tick if Employer is the Payor:</td>
                                          <td width="30%" valign="middle">
                                             <table width="90%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                                <tr>
                                                   <td>
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                         <tr>
                                                            <td width="100%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%">Name*(as in bank account):</td>
                                 <td width="80%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%">Permanent Address:</td>
                                 <td width="80%">
                                    <table width="98%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%">&nbsp;</td>
                                 <td width="80%">
                                    <table width="98%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="28%" style="text-align:right;">Landmark:&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                 <td width="72%">
                                    <table width="98%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="25%" style="text-align:right">City*:&nbsp;&nbsp;</td>
                                 <td width="40%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="12%">Town (District):</td>
                                 <td width="22%">
                                    <table width="90%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="25%" style="text-align:right">State*:&nbsp;&nbsp;</td>
                                 <td width="45%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="14%" style="text-align:right;">Pin Code*:&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                 <td width="22%">
                                    <table width="90%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%">Correspondence Address*:</td>
                                 <td width="80%">
                                    <table width="98%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%">
                                    <table width="100%">
                                       <tr>
                                          <td width="80%" style="font-size:8px;">If same as above, please tick here:</td>
                                          <td width="15%">
                                             <table width="100%" border="1" cellspacing="0" cellpadding="0">
                                                <tr>
                                                   <td width="100%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="80%">
                                    <table width="98%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="28%" style="text-align:right;">Landmark:&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                 <td width="72%">
                                    <table width="98%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="25%" style="text-align:right">City*:&nbsp;&nbsp;</td>
                                 <td width="40%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="12%">Town (District):</td>
                                 <td width="22%">
                                    <table width="90%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="25%" style="text-align:right">State*:&nbsp;&nbsp;</td>
                                 <td width="45%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="14%" style="text-align:right;">Pin Code*:&nbsp;&nbsp;&nbsp;&nbsp;</td>
                                 <td width="22%">
                                    <table width="90%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="12%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="18%">Email Address^^</td>
                                 <td width="1%">:</td>
                                 <td width="8%">Address 1</td>
                                 <td width="30%" style="border:solid 1px #666666; height:13px;">&nbsp;</td>
                                 <td width="4%"></td>
                                 <td width="12%" style="text-align:right;">Address 2 &nbsp;&nbsp;&nbsp;</td>
                                 <td width="26%" style="border:solid 1px #666666; height:13px;">&nbsp;</td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="18%">Telephone Number(s)</td>
                                 <td width="1%">:</td>
                                 <td width="8%">Mobile^^:</td>
                                 <td width="30%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="1%"></td>
                                 <td width="20%" style="text-align:right;">Residence (Optional):&nbsp;&nbsp;&nbsp;</td>
                                 <td width="30%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="18%">&nbsp;</td>
                                 <td width="13%">Office(Optional):</td>
                                 <td width="30%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td height="30"></td>
            </tr>
            <!-- first page end -->
            <!-- second page -->
            <tr>
               <td>
                  <table width="100%" border="1" cellspacing="0" cellpadding="0">
                     <tr>
                        <td>
                           <table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="50%">Would you like to subscribe to important alert on Whatsapp?</td>
                                 <td width="30%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="15%" style="text-align:center;">yes</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="15%" style="text-align:center;">&nbsp;&nbsp;&nbsp;No</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="70%">Would you like to go digital and receive all policy related information in soft copy/via email only?</td>
                                 <td width="30%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="15%" style="text-align:center;">yes</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="15%" style="text-align:center;">&nbsp;&nbsp;&nbsp;No</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="13%">Occupation*</td>
                                 <td width="4%">:</td>
                                 <td width="80%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="22%" style="text-align:center;">Government Service</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="3%">&nbsp;</td>
                                          <td width="18%" style="text-align:center;">Private Service</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="3%">&nbsp;</td>
                                          <td width="18%" style="text-align:center;">Self Employed</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="5%">&nbsp;</td>
                                          <td width="10%" style="text-align:center;">Others</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="2%" style="text-align:center;">&nbsp;</td>
                                          <td width="10%" style="text-align:center; color:#999; border-bottom:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="13%">Annual Income*</td>
                                 <td width="4%">:</td>
                                 <td width="80%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="22%" style="text-align:center;">Up to ₹ 50,000</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="3%">&nbsp;</td>
                                          <td width="18%" style="text-align:center;">₹ 5 to 10 Lacs</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="3%">&nbsp;</td>
                                          <td width="18%" style="text-align:center;">₹ 15 to 20 Lacs</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="13%">Annual Income*</td>
                                 <td width="4%">:</td>
                                 <td width="80%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="22%" style="text-align:center;">₹ 50,000 to ₹ 5 Lacs</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="3%">&nbsp;</td>
                                          <td width="18%" style="text-align:center;">₹ 10 to 15 Lacs</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="3%">&nbsp;</td>
                                          <td width="18%" style="text-align:center;">Above ₹ 20 Lacs</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="13%">Educational Qualification :*</td>
                                 <td width="1%">:</td>
                                 <td width="86%">
                                    <table width="98%" border="0" cellpadding="0" cellspacing="0">
                                       <tr>
                                          <td width="16%">Less than class X</td>
                                          <td width="2%" style="color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="2%">&nbsp;</td>
                                          <td width="8%" style="text-align:center;">Class X</td>
                                          <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="2%">&nbsp;</td>
                                          <td width="9%" style="">Class XII</td>
                                          <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="2%">&nbsp;</td>
                                          <td width="9%" style="">Graduate</td>
                                          <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="2%" style="text-align:center;">&nbsp;</td>
                                          <td width="14%" style="">Post Graduate</td>
                                          <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="20%" style="text-align:center;">Professional Degree</td>
                                          <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="50%">Customer Goods & Service Tax Identification Number (if any):</td>
                                 <td width="30%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="13%">Nationality*</td>
                                 <td width="2%">:</td>
                                 <td width="80%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="8%" style="text-align:center;">Indian</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="3%">&nbsp;</td>
                                          <td width="6%" style="text-align:center;">NRI</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="3%">&nbsp;</td>
                                          <td width="10%" style="text-align:center;">Others</td>
                                          <td width="3%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="2%" style="text-align:center;">&nbsp;</td>
                                          <td width="20%" style="text-align:center; color:#999;">(Please specify)</td>
                                          <td width="26%" style="text-align:center; color:#999; border-bottom:solid 1px #666; border-right:none;"></td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="15%">PAN Card Number* :</td>
                                 <td width="25%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="60%" style="font-size:8px;">(Mandatory for premium of `50,000 and above accepted in Cash/DD or `100,000 and above by Cheque/Credit/Debit Card)</td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="42%">Form 60* (only in case where PAN number is not available)</td>
                                 <td width="15%">
                                    <table width="98%" border="0" cellpadding="0" cellspacing="0">
                                       <tr>
                                          <td width="25%" style="text-align:center;">yes</td>
                                          <td width="15%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="25%" style="text-align:center;">&nbsp;&nbsp;&nbsp;No</td>
                                          <td width="15%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="18%">Aadhaar number/ (VID number):</td>
                                 <td width="25%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="9%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td style="font-weight:bold;">Family Physician Details:</td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%">Name*</td>
                                 <td width="2%">:</td>
                                 <td width="60%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%" >Contact number &nbsp;&nbsp;</td>
                                 <td width="2%" >:&nbsp;&nbsp;</td>
                                 <td width="40%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="6%">Email id:</td>
                                 <td width="29%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="100%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%">Address*</td>
                                 <td width="2%">:</td>
                                 <td width="60%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td  width="99%" style="border-top:solid 1px #000000;">&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="35%">Do you wish to assign a Caregiver for your Policy/ies:*</td>
                                 <td width="2%">:</td>
                                 <td width="63%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="8%" style="text-align:center;">Yes</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="3%">&nbsp;</td>
                                          <td width="6%" style="text-align:center;">No</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="3%">&nbsp;</td>
                                          <td width="2%" style="text-align:center;">&nbsp;</td>
                                          <td width="30%" style="text-align:center; color:#999;">If Yes, please provide :</td>
                                          <td width="26%" style="text-align:center; color:#999; border-bottom:solid 1px #666; border-right:none;"></td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%">Name*:</td>
                                 <td width="80%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%" >Mobile number &nbsp;&nbsp;</td>
                                 <td width="2%" >:&nbsp;&nbsp;</td>
                                 <td width="28%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="20%">Relationship with Proposer:</td>
                                 <td width="28%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="100%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%" >Age (in Years)</td>
                                 <td width="2%" >:&nbsp;&nbsp;</td>
                                 <td width="28%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="8%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="10%">Email id:</td>
                                 <td width="38%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="100%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td width="94%" style="font-size:8px;">Caregiver can be a close family member who would take care of the Insured Person in any kind of health care event, whether emergency or planned. The Caregiver might not be the SOS contact.</td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td style="font-size:8px;">^^Please provide the details to enable us to serve you better.</td>
            </tr>
            <tr>
               <td height="30"></td>
            </tr>
            <tr>
               <td style="font-size:14px; font-weight:bold;">II. NOMINEE DETAILS:</td>
            </tr>
            <tr>
               <td>
                  <table width="100%" border="1" cellspacing="0" cellpadding="0">
                     <tr>
                        <td>
                           <table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="40%">Is the Nominee same as Caregiver (if provided above)?</td>
                                 <td width="20%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="30%" style="text-align:center;">yes</td>
                                          <td width="13%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="30%" style="text-align:center;">&nbsp;&nbsp;&nbsp;No</td>
                                          <td width="13%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="40%" >If No, please provide Nominee details.</td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%">Nominee Name</td>
                                 <td width="2%">:</td>
                                 <td width="60%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%" >Relationship with Proposer</td>
                                 <td width="2%" >:&nbsp;&nbsp;</td>
                                 <td width="55%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="12%" style="text-align:center;">Nominee Age :</td>
                                 <td width="29%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="98%" style="font-size:8px;">In the event of death of the Proposer, any payment due under the Policy shall become payable to the nominee, as per the 'Nomination' clause defined by the IRDAI and the receipt of the proceeds by such nominee would be sufficient discharge to the Company. For all other persons covered under the Policy, the Proposer will be the nominee.</td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="94%"><b>Appointee details:</b> (Required only if nominee is a minor)</td>
                              </tr>
                              <tr>
                                 <td width="20%">Appointee Name:</td>
                                 <td width="80%">
                                    <table width="98%" border="0" cellpadding="2" cellspacing="0">
                                       <tr>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>&nbsp;</td>
                              </tr>
                              <tr>
                                 <td width="20%" >Relationship with Proposer</td>
                                 <td width="2%" >:&nbsp;&nbsp;</td>
                                 <td width="55%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                          <td width="6%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="12%" style="text-align:right;">Age :</td>
                                 <td width="29%">
                                    <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                       <tr>
                                          <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                          <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td width="100%" style="font-size:8px;">#A Minor should not be declared as Appointee.</td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td height="30"></td>
            </tr>
            <tr>
               <td style="font-size:14px; font-weight:bold;">III. POLICY/PLAN DETAILS*:</td>
            </tr>
            <tr>
               <td>
                  <table width="100%" border="0" cellspacing="0" cellpadding="5" style="border:solid 1px #000000;">
                     <tr>
                        <td width="40%" style="border-right:solid 1px #000000;">
                           <table width="100%" border="0" cellpadding="0" cellspacing="0" >
                              <tr>
                                 <td width="20%" style=" border-right:none;"><b>Tenure*:</b></td>
                                 <td width="15%" style="text-align:center;">1 Year</td>
                                 <td width="5%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="22%" style="text-align:center;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2 Years</td>
                                 <td width="5%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="22%" style="text-align:center;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3 Years</td>
                                 <td width="5%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                           </table>
                        </td>
                        <td width="60%">
                           <table width="100%" border="0" cellpadding="0" cellspacing="0" >
                              <tr>
                                 <td width="30%" style=" border-right:none; font-size:8px;"><b>Proposed Policy Period:</b></td>
                                 <td width="8%" style="text-align:center;">From</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="6%" style="text-align:center;">at</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="2%" style="text-align:center;">:</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="6%" style="text-align:center;">Hrs</td>
                              </tr>
                              <tr>
                                 <td width="100%" style=" font-size:8px;">(Must be on or later than instrument date/ premium payment date)</td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td height="30"></td>
            </tr>
            <tr>
               <td  width="30%" style="font-size:14px; font-weight:bold;">INSURED DETAILS*:</td>
               <td style="font-size:11px;">(Deductible and Sum Insured only for individual cover)</td>
            </tr>
            <tr>
               <td width="100%" >
                  <table width="100%" border="1" cellspacing="0" cellpadding="1" style="text-align:center">
                     <tr>
                        <td width="3%" style="text-align:center">Sr <br /> No </td>
                        <td width="8%"> Name <span style="font-size:7px;">(First*,Middle, Last*)</span> </td>
                        <td width="7%"> Gender* <span style="font-size:7px;">(M/F/O)</span> </td>
                        <td>DOB*</td>
                        <td width="10%"> Relationship with Proposer* </td>
                        <td> Height* <span style="font-size:7px;">(Cms)</span> </td>
                        <td width="7%"> Weight* (Kgs) </td>
                        <td width="11%"> Occupation Industry Type Nature of Job* </td>
                        <td width="5%">City</td>
                        <td width="28%" colspan="3" >
                           <table width="98%" border="0" cellspacing="0" cellpadding="2">
                              <tr>
                                 <td style="border-bottom:solid 1px #000000;border-right:solid 1px #000000;">Deductible</td>
                                 <td style="border-bottom:solid 1px #000000;border-right:solid 1px #000000;">Sum Insured*</td>
                                 <td style="border-bottom:solid 1px #000000;border-right:none;">Insured<br />
                                    Address If Different From Proposer
                                 </td>
                              </tr>
                              <tr>
                                 <td width="100%" colspan="3"><span style="font-size:8px; text-align:center;">ManipalCigna ProHealth Select A<br />
                                    HMB is opted at individual level<br />
                                    will be displayed in the table.</span>
                                 </td>
                              </tr>
                           </table>
                        </td>
                        <td width="6%"> If PEP^ <span style="font-size:8px;">(Y/N)</span></td>
                     </tr>
                     <tr>
                        <td>1</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td colspan="3">
                           <table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td style="border-right:solid 2px #000000;"></td>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td></td>
                              </tr>
                           </table>
                        </td>
                        <td>&nbsp;</td>
                     </tr>
                     <tr>
                        <td>2</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td colspan="3">
                           <table border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td></td>
                              </tr>
                           </table>
                        </td>
                        <td>&nbsp;</td>
                     </tr>
                     <tr>
                        <td>3</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td colspan="3">
                           <table border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td></td>
                              </tr>
                           </table>
                        </td>
                        <td>&nbsp;</td>
                     </tr>
                     <tr>
                        <td>4</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td colspan="3">
                           <table border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td></td>
                              </tr>
                           </table>
                        </td>
                        <td>&nbsp;</td>
                     </tr>
                     <tr>
                        <td>5</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td colspan="3">
                           <table border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td></td>
                              </tr>
                           </table>
                        </td>
                        <td>&nbsp;</td>
                     </tr>
                     <tr>
                        <td>6</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td colspan="3">
                           <table border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td></td>
                              </tr>
                           </table>
                        </td>
                        <td>&nbsp;</td>
                     </tr>
                     <tr>
                        <td>7</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td colspan="3">
                           <table border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td></td>
                              </tr>
                           </table>
                        </td>
                        <td>&nbsp;</td>
                     </tr>
                     <tr>
                        <td>8</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td colspan="3">
                           <table border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td style="border-right:solid 1px #000000;"></td>
                                 <td></td>
                              </tr>
                           </table>
                        </td>
                        <td>&nbsp;</td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td  width="100%" style="font-size:8px;">^ Politically exposed person:</td>
            </tr>
            <tr>
               <td height="15"></td>
            </tr>
            <tr>
               <td>
                  <table width="100%" border="0" cellspacing="0" cellpadding="5" style="border:solid 1px #000000;">
                     <tr>
                        <td width="100%" style="border-right:solid 1px #000000;">
                           <table width="100%" border="0" cellpadding="0" cellspacing="0" >
                              <tr>
                                 <td width="40%" style="border-right:none; text-align:left">All insured Indian national and Indian residents?</td>
                                 <td width="5%" style="text-align:center;">Yes</td>
                                 <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="2%">&nbsp;</td>
                                 <td width="5%" style="text-align:center;">No</td>
                                 <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                     <tr>
                        <td><b>Note:</b> ManipalCigna Critical Illness Add On Cover: Minimum age at entry under this policy is 18 years and maximum age at entry is 65 years.</td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td height="15"></td>
            </tr>
            <tr>
               <td width="100%">
                  <table width="100%" border="0" cellspacing="0" cellpadding="5" style="border:solid 1px #000000;">
                     <tr>
                        <td width="27%" style="border-right:solid 1px #000000;">
                           <table width="100%" border="0" cellpadding="0" cellspacing="0" >
                              <tr>
                                 <td width="30%" style=" border-right:none; font-size:8px;"><b>Plan Type* :</b></td>
                                 <td width="30%" style="text-align:center;font-size:8px;">Individual</td>
                                 <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;"></td>
                                 <td width="25%" style="text-align:center;font-size:8px;">Floater</td>
                                 <td width="6%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                           </table>
                        </td>
                        <td width="36%" style="border-right:solid 1px #000000;">
                           <table width="100%" border="0" cellpadding="0" cellspacing="0" >
                              <tr>
                                 <td width="20%" style=" border-right:none; font-size:8px;"><b>Portability:</b></td>
                                 <td width="10%" style="text-align:center;font-size:8px;">Yes</td>
                                 <td width="8%">
                                    <table>
                                       <tr>
                                          <td style="text-align:center; color:#999; border:solid 1px #666; border-right:none;"></td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="2%"></td>
                                 <td width="10%" style="text-align:center;font-size:8px;">No</td>
                                 <td width="8%">
                                    <table width="100%">
                                       <tr>
                                          <td style="text-align:center; color:#999; border:solid 1px #666; border-right:none;"></td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="2%"></td>
                                 <td width="40%" style="text-align:center;font-size:8px;">(If yes portability form to be completed and attached)</td>
                              </tr>
                           </table>
                        </td>
                        <td width="36%" style="border-right:solid 1px #000000;">
                           <table width="100%" border="0" cellpadding="0" cellspacing="0" >
                              <tr>
                                 <td width="20%" style=" border-right:none; font-size:8px;"><b>Migration:</b></td>
                                 <td width="10%" style="text-align:center;font-size:8px;">Yes</td>
                                 <td width="8%">
                                    <table>
                                       <tr>
                                          <td style="text-align:center; color:#999; border:solid 1px #666; border-right:none;"></td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="2%"></td>
                                 <td width="10%" style="text-align:center;font-size:8px;">No</td>
                                 <td width="8%">
                                    <table width="100%">
                                       <tr>
                                          <td style="text-align:center; color:#999; border:solid 1px #666; border-right:none;"></td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="2%"></td>
                                 <td width="40%" style="text-align:center;font-size:8px;">(If yes migration form to be completed and attached)</td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td>
                  <table width="100%" border="1" cellspacing="0" cellpadding="0">
                     <tr>
                        <td>
                           <table width="100%" border="0" cellspacing="0" cellpadding="5">
                              <tr>
                                 <td width="55%"><strong>Sum Insured*:</strong></td>
                                 <td width="40%"><strong>OPTIONAL COVERS</strong></td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                     <tr>
                        <td width="100%" valign="top">
                           <table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td width="25%" valign="top"  style="border-right:solid 1px #000000;">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="30%">₹50,000</td>
                                          <td width="14%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="10%">&nbsp;</td>
                                          <td width="30%">₹7 Lacs</td>
                                          <td width="14%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                       <tr>
                                          <td width="30%">₹1 Lac</td>
                                          <td width="14%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="10%">&nbsp;</td>
                                          <td width="30%">₹10 Lacs</td>
                                          <td width="14%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                       <tr>
                                          <td width="30%">₹2 Lacs</td>
                                          <td width="14%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="10%">&nbsp;</td>
                                          <td width="30%">₹15 Lacs</td>
                                          <td width="14%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                       <tr>
                                          <td width="30%">₹3 Lacs</td>
                                          <td width="14%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="10%">&nbsp;</td>
                                          <td width="30%">₹20 Lacs</td>
                                          <td width="14%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                       <tr>
                                          <td width="30%">₹4 Lacs</td>
                                          <td width="14%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="10%">&nbsp;</td>
                                          <td width="30%">₹25 Lacs</td>
                                          <td width="14%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                       <tr>
                                          <td>₹5 Lacs</td>
                                          <td width="14%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td>&nbsp;</td>
                                          <td></td>
                                          <td>&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="25%" valign="top" style="border-right:solid 1px #000000;">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td><strong>Deductible</strong>:<span style="font-size:8px;">(cannot be higher than the Sum Insured)</span></td>
                                       </tr>
                                       <tr>
                                          <td valign="top">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="2" >
                                                <tr>
                                                   <td width="30%">₹1 Lac</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                   <td width="6%">&nbsp;</td>
                                                   <td width="30%">₹4 Lac</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                                <tr>
                                                   <td width="30%">₹2 Lacs</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                   <td width="6%">&nbsp;</td>
                                                   <td width="30%">₹5 Lac</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                                <tr>
                                                   <td width="30%">₹3 Lacs</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                   <td width="6%">&nbsp;</td>
                                                   <td width="30%">&nbsp;</td>
                                                   <td width="12%">&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                       <tr>
                                          <td><strong>Voluntary Co-pay</strong></td>
                                       </tr>
                                       <tr>
                                          <td>
                                             <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                                <tr>
                                                   <td width="20%">10%</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                   <td width="24%">&nbsp;</td>
                                                   <td width="20%">20%</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                       <tr>
                                          <td style="font-size:9px;">(Deductible and Voluntary Co-pay cannot be opted under the same plan)</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="28%" valign="top" style="border-right:solid 1px #000000;">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="5">
                                       <tr>
                                          <td valign="top">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                                <tr>
                                                   <td width="80%"><strong>Removal of Room Rent Limit</strong></td>
                                                   <td width="6%"></td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                                <tr>
                                                   <td width="80%"><strong>Health Checkup</strong></td>
                                                   <td width="6%"></td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                                <tr>
                                                   <td width="80%"><strong>Re-Assurance</strong></td>
                                                   <td width="6%"></td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                       <tr>
                                          <td><strong>Disease Specific Sub Limits</strong></td>
                                       </tr>
                                       <tr>
                                          <td valign="top">
                                             <table width="80%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                                                   <td width="10%">A</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                   <td width="20%"></td>
                                                   <td width="10%">B</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                   <td width="20%"></td>
                                                   <td width="10%">C</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                       <tr>
                                          <td><strong>Health Maintenance benefit</strong></td>
                                       </tr>
                                       <tr>
                                          <td valign="top">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="2" >
                                                <tr>
                                                   <td width="18%">500</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                   <td width="30%">&nbsp;</td>
                                                   <td width="22%">1000</td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                       <tr>
                                          <td valign="top">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                                <tr>
                                                   <td width="86%"><strong>Worldwide Emergency Cover</strong></td>
                                                   <td width="14%">
                                                      <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="22%" valign="top">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                       <tr>
                                          <td><strong>Cumulative Bonus Booster~</strong></td>
                                       </tr>
                                       <tr>
                                          <td>
                                             <table width="100%" border="0" cellspacing="0" cellpadding="5">
                                                <tr>
                                                   <td width="55%" >Option A</td>
                                                   <td valign="top">
                                                      <table width="25%" border="0" cellspacing="0" cellpadding="0"  style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                                <tr>
                                                   <td>Option B</td>
                                                   <td>
                                                      <table width="25%" border="0" cellspacing="0" cellpadding="0"  style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                                <tr>
                                                   <td>Option C</td>
                                                   <td>
                                                      <table width="25%" border="0" cellspacing="0" cellpadding="0"  style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                                <tr>
                                                   <td>Option D</td>
                                                   <td>
                                                      <table width="25%" border="0" cellspacing="0" cellpadding="0"  style="border:solid 1px #333;">
                                                         <tr>
                                                            <td>&nbsp;</td>
                                                         </tr>
                                                      </table>
                                                   </td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                     <tr>
                        <td valign="top">
                           <table width="100%" border="0" cellspacing="5" cellpadding="0">
                              <tr>
                                 <td width="3%" >
                                    <table width="100%" border="1" cellspacing="0" cellpadding="0">
                                       <tr>
                                          <td>&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="92%">ManipalCigna Critical Illness Add On Cover</td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td height="15"></td>
            </tr>
            <tr>
               <td>
                  <table width="100%" border="0" cellspacing="0" cellpadding="5" style="border:solid 1px #000000;">
                     <tr>
                        <td width="100%" style="border-right:solid 1px #000000;">
                           <table width="100%" border="0" cellpadding="0" cellspacing="0" >
                              <tr>
                                 <td><b>Applicable Discounts:</b> </td>
                              </tr>
                              <tr>
                                 <td>a. <b>Family Discount</b> of 10% for policies covering more than 2 individuals with individual Sum Insured.</td>
                              </tr>
                              <tr>
                                 <td>b. <b>Long Term Discount</b> of 7.5% for policies with term 2 years and 10% for policies with term 3 years, only upon payment of lump sum premium.</td>
                              </tr>
                              <tr>
                                 <td width="25%" style="border-right:none; text-align:left; font-weight:bold;">Premium payment mode:</td>
                                 <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="10%" style="text-align:center;">Monthly^</td>
                                 <td width="2%">&nbsp;</td>
                                 <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="10%" style="text-align:center">Quarterly</td>
                                 <td width="2%">&nbsp;</td>
                                 <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="10%" style="text-align:center;">Half yearly</td>
                                 <td width="2%">&nbsp;</td>
                                 <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="7%" style="text-align:center;">Yearly</td>
                                 <td width="2%">&nbsp;</td>
                                 <td width="2%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="7%" style="text-align:center;">Single</td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                     <tr>
                        <td><b>Note:</b> ManipalCigna Critical Illness Add On Cover: Minimum age at entry under this policy is 18 years and maximum age at entry is 65 years.</td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td>
                  <table width="100%" border="0" cellspacing="0" cellpadding="3" >
                     <tr>
                        <td style="font-size:10px;">Note: Please note that your Policy period will start from premium received date at our branch office in case of cash payments or/ as per instrument date when paying through Cheque/ demand draft/ pay order. In case
                           of credit card/ debit card transactions, Policy period will start from date of debit of requisite premium from the Proposer's card/ bank account. This is applicable only where medical examination or underwriting is not
                           required. In case a medical examination is to be done or an underwriting approval is required, the Policy shall commence on or after the date of approval by underwriter or the date of receipt of any additional premium,
                           whichever is later.
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td>
                  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td><b>~Cumulative Bonus Booster</b></td>
                        <td>&nbsp;</td>
                     </tr>
                     <tr>
                        <td>Option A: (10% increase, max upto 100% non-reducing bonus) </td>
                        <td>Option B: (25% increase, max upto 100% non-reducing bonus) </td>
                     </tr>
                     <tr>
                        <td>Option B: (25% increase, max upto 100% non-reducing bonus) </td>
                        <td>Option D: (10% increase, max upto 200%, irrespective of claim) </td>
                     </tr>
                  </table>
               </td>
            </tr>
            <tr>
               <td height="15"></td>
            </tr>
            <tr>
               <td>
                  <table width="100%" border="0" cellspacing="0" cellpadding="0">
                     <tr>
                        <td>
                           <table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td><strong>IV. MEDICAL AND LIFESTYLE INFORMATION*:</strong></td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                     <tr>
                        <td width="100%" valign="top">
                           <table width="100%" border="1" cellspacing="0" cellpadding="2">
                              <tr>
                                 <td width="34%" colspan="2" style="background-color:#333; color:#FFF"><b>Medical questions</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 1</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 2</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 3</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 4</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 5</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 6</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 7</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 8</b></td>
                              </tr>
                              <tr>
                                 <td width="4%">Q1</td>
                                 <td width="30%">Has any of the applicant ever been diagnosed with or suspected to<br />
                                    have Cancer or Rheumatoid Arthritis or Ulcerative Colitis or Crohn's<br />
                                    disease or Chronic Liver Disease, Hepatitis B, Cirrhosis or Chronic<br />
                                    Kidney Disease or Kidney failure or Epilepsy or Fits or Stroke or<br />
                                    Paralysis or Parkinsonism or Alzheimer's or Multiple sclerosis or Brain<br />
                                    Tumor or Cerebral Palsy or Heart Failure or Heart Attack or Angina or<br />
                                    Coronary Artery Disease or Ischemic Heart Disease or Chronic<br />
                                    Bronchitis or Intestitial Lung Diseases or Pneumoconiosis or<br />
                                    Emphysema.
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="30%"><table cellspacing="0" cellpadding="0" width="100%" style="border:solid 1px #666666;"><tr><td></td></tr></table></td>
                                          <td width="70%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="30%"><table cellspacing="0" cellpadding="0" width="100%" style="border:solid 1px #666666;"><tr><td></td></tr></table></td>
                                          <td width="70%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>Q2</td>
                                 <td>Has any member ever suffered or currently suffering from or under<br />
                                    treatment (operated, hospitalised, investigated) or been under<br />
                                    medication for more than a week for any medical condition.
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>i</td>
                                 <td>Diabetes Mellitus</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>ii</td>
                                 <td>Hypertension</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>iii</td>
                                 <td>High Cholesterol</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>iv</td>
                                 <td>Thyroid disorders</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>v</td>
                                 <td>Heart and Lung disorders</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>vi</td>
                                 <td>Digestive system disorders (Stomach and related organs)</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>vii</td>
                                 <td>Brain, nerve and Psychiatric (Mental) disorders</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>viii</td>
                                 <td>Other Endocrine (Hormonal) disorders</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>ix</td>
                                 <td>Bone, joints and muscle disorders</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>x</td>
                                 <td>Ear, nose, eye and throat disorders</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>xi</td>
                                 <td>Genito-urinary and Gynaecological disorders</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>xii</td>
                                 <td>Blood and related disorders</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>xiii</td>
                                 <td>Skin disorders</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>xiv</td>
                                 <td>Any other condition / illness / disorder / surgery</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>Q3</td>
                                 <td>Has any of the applicants recommended to undergo or has undergone<br />
                                    any pathologic or radiologic tests for any illness other than the ones<br />
                                    listed above and routine or annual health check-up?
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>Q4</td>
                                 <td>Is any applicant currently not in good health and undergoing any<br />
                                    investigation or treatment or medication for any illness or medical<br />
                                    condition (Physical/ Mental/ Sleep disorders)?
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                     <tr>
                        <td height="15"></td>
                     </tr>
                     <tr>
                        <td width="100%" valign="top">
                           <table width="100%" border="1" cellspacing="0" cellpadding="2">
                              <tr>
                                 <td width="34%" colspan="2" style="background-color:#333; color:#FFF"><b>Habits and Lifestyle questions</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 1</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 2</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 3</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 4</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 5</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 6</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 7</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 8</b></td>
                              </tr>
                              <tr>
                                 <td width="4%">Q5</td>
                                 <td width="30%">Does any of the insured/s chew tobacco/ smoke/ consume alcohol?
                                    Please tick the relevant box(es) below
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td width="8%">
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2" align="left">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td><b>A</b></td>
                                 <td><b>Smoke</b></td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>1</td>
                                 <td>Since how long does the applicant smoke</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>a</td>
                                 <td><=20 years</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>b</td>
                                 <td>>20 years</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">  
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td><b>B</b></td>
                                 <td><b>Tobacco</b></td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>1</td>
                                 <td>How many Pan masala / gutka packets does the applicant has in a day</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>a</td>
                                 <td>1-3 packets/day</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>b</td>
                                 <td>4-6 packets/day</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>c</td>
                                 <td>>6 packets/day</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td><b>C</b></td>
                                 <td><b>Alcohol</b></td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>1</td>
                                 <td>How frequently does the applicant consume alcohol</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>a</td>
                                 <td>1-3 days/ week</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>b</td>
                                 <td>3-6 days / week</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td>c</td>
                                 <td>Daily</td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td width="34%" colspan="2" style="background-color:#333; color:#FFF"><b>For Critical Illness Add On Cover</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 1</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 2</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 3</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 4</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 5</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 6</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 7</b></td>
                                 <td width="8%" style="background-color:#333; color:#FFF"><b>Insured 8</b></td>
                              </tr>
                              <tr>
                                 <td width="4%">Q6</td>
                                 <td width="30%">Have any first degree relatives (i.e. parents, brothers, sisters or
                                    children) of any of the applicants (who are not themselves applicants
                                    for this insurance policy) had cancer, motor neuron disease or any
                                    other hereditary disorders
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;YES</td>
                                       </tr>
                                       <tr>
                                          <td width="35%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #666666;">
                                                <tr>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="60%">&nbsp;NO</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                     <tr>
                        <td height="15"></td>
                     </tr>
                     <tr>
                        <td>
                           <table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                       <tr>
                                          <td><strong>V. ADDITIONAL MEDICAL INFORMATION:</strong></td>
                                       </tr>
                                       <tr>
                                          <td>If answers to Q2 are “Yes”, please provide further details below. Please attach extra sheets if required.</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td width="100%" valign="top">
                                    <table width="100%" border="1" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="4%"  style="color:#000000"><strong>Sr.No</strong></td>
                                          <td width="30%"  style="color:#000000"><strong>Additional Medical Information</strong></td>
                                          <td width="8%" style="color:#000000"><strong>Insured 1</strong></td>
                                          <td width="8%" style="color:#000000"><strong>Insured 2</strong></td>
                                          <td width="8%" style="color:#000000"><strong>Insured 3</strong></td>
                                          <td width="8%" style="color:#000000"><strong>Insured 4</strong></td>
                                          <td width="8%" style="color:#000000"><strong>Insured 5</strong></td>
                                          <td width="8%" style="color:#000000"><strong>Insured 6</strong></td>
                                          <td width="8%" style="color:#000000"><strong>Insured 7</strong></td>
                                          <td width="8%" style="color:#000000"><strong>Insured 8</strong></td>
                                       </tr>
                                       <tr>
                                          <td>a</td>
                                          <td>Exact Diagnosis</td>
                                          <td width="8%">&nbsp;</td>
                                          <td width="8%">&nbsp;</td>
                                          <td width="8%">&nbsp;</td>
                                          <td width="8%">&nbsp;</td>
                                          <td width="8%">&nbsp;</td>
                                          <td width="8%">&nbsp;</td>
                                          <td width="8%">&nbsp;</td>
                                          <td width="8%">&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>b</td>
                                          <td>Year of diagnosis</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>c</td>
                                          <td>Treatment taken : Surgical/ Medical / No treatment / Defaulter<br />
                                             (left treatment on own)
                                          </td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>d</td>
                                          <td>Current status - Cured/ On treatment / Pending surgery or treatment</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>e</td>
                                          <td>Complications/ Recurrences - Yes/No</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>f</td>
                                          <td>Last consultation date - &quot;Month/Year&quot; to be provided</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>g</td>
                                          <td>Histopathology Examination Report (only for surgical) - No<br />
                                             abnormality, Malignancy/ borderline malignancy/Tuberculosis
                                          </td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td valign="top">
                                    <table width="98%" border="0" cellspacing="0" cellpadding="0">
                                       <tr>
                                          <td width="60%">&nbsp;</td>
                                          <td width="40%">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                                                   <td></td>
                                                </tr>
                                                <tr>
                                                   <td width="50%">Signature of Proposer*:</td>
                                                   <td width="50%" style="border-bottom:solid 1px #666666;">&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                     <tr>
                        <td height="15"></td>
                     </tr>
                     <tr>
                        <td>
                           <table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                 <td>
                                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                       <tr>
                                          <td><strong>VI. PREVIOUS/ CURRENT INSURANCE DETAILS:</strong></td>
                                       </tr>
                                       <tr>
                                          <td>Pease fill the following details with respect to health insurance policies(s) currently or held with the Company or any other insurance company (Individual or Group)?</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td width="100%" valign="top">
                                    <table width="100%" border="1" cellspacing="0" cellpadding="2">
                                       <tr>
                                          <td width="8%" rowspan="2" valign="top">Insured</td>
                                          <td width="6%" rowspan="2" valign="top">Policy
                                             No.
                                          </td>
                                          <td width="8%" rowspan="2" valign="top">Type of<br />
                                             Policy<br />
                                             e.g. Mediclaim,<br />
                                             PA, CI, Hospital<br />
                                             Cash
                                          </td>
                                          <td width="6%" rowspan="2" valign="top">Insurer<br />
                                             Name
                                          </td>
                                          <td width="6%" rowspan="2" valign="top">From  <br />
                                             Date
                                          </td>
                                          <td width="6%" rowspan="2" valign="top">To Date</td>
                                          <td width="6%" rowspan="2" valign="top">Sum Insured</td>
                                          <td width="30%" colspan="5" valign="top">
                                             <table width="100%" border="0" cellspacing="0" cellpadding="2">
                                                <tr>
                                                   <td width="50%" style="border-right:solid 2px #666666;">Claim Details</td>
                                                   <td>Cumulative<br />
                                                      Bonus Earned
                                                   </td>
                                                </tr>
                                                <tr>
                                                   <td width="50%" style="border-right:solid 2px #666666;">&nbsp;</td>
                                                   <td>&nbsp;</td>
                                                </tr>
                                                <tr>
                                                   <td style="border-right:solid 2px #666666;">&nbsp;</td>
                                                   <td>&nbsp;</td>
                                                </tr>
                                                <tr>
                                                   <td style="border-right:solid 2px #666666;">&nbsp;</td>
                                                   <td>&nbsp;</td>
                                                </tr>
                                                <tr>
                                                   <td style="border-right:solid 2px #666666;">&nbsp;</td>
                                                   <td>&nbsp;</td>
                                                </tr>
                                                <tr>
                                                   <td style="border-right:solid 2px #666666;">&nbsp;</td>
                                                   <td>&nbsp;</td>
                                                </tr>
                                             </table>
                                          </td>
                                          <td width="22%">Has any proposal for life,
                                             health, hospital daily cash or critical illness insurance on           
                                             the life of the applicant ever
                                             been declined, postponed,
                                             loaded or been made subject
                                             to any special conditions
                                             such as exclusions by any
                                             insurance company?
                                          </td>
                                       </tr>
                                       <tr>
                                          <td>Claim<br />
                                             Number
                                          </td>
                                          <td>Claimed<br />
                                             Amount
                                          </td>
                                          <td>Ailment</td>
                                          <td>%</td>
                                          <td>Amount</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>Insured 1</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>Insured 2</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>Insured 3</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>Insured 4</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>Insured 5</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>Insured 6</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>Insured 7</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                       <tr>
                                          <td>Insured 8</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                          <td>&nbsp;</td>
                                       </tr>
                                    </table>
                                 </td>
                              </tr>
                              <tr>
                                 <td valign="top"><strong>For active policies, please attach policy copies.</strong><br />
                                    Insured wise information required with all the above information in Previous/Current Insurance Details
                                 </td>
                              </tr>
                           </table>
                        </td>
                     </tr>
                  </table>
               </td>
            </tr>
         </table>
      </td>
   </tr>
</table>
EOF;
// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');
// reset pointer to the last page
$pdf->lastPage();
// ---------------------------------------------------------
//Close and output PDF document
$pdf->Output('example_061.pdf', 'I');
//============================================================+
// END OF FILE
//============================================================+
?>