<?php
$darkLogo = get_option('dark_logo_url');

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php wp_title('', true, 'right'); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Work+Sans:wght@500&display=swap" rel="stylesheet">
    <?php
    wp_head();
    ?>
</head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>    
    <!-- Navbar Start -->
    <header class="site-header siteHeader">

        <nav class="site-navbar">
            <div class="nav-container">
                <div class="site-logo" data-dark_logo="<?php echo $darkLogo ?>" style="cursor: pointer;">
                    <?php the_custom_logo();?>
                </div>

                <?php
                wp_nav_menu(
                    array(
                        'theme_location' => 'primary',
                        'menu_class' => 'primary-menu primaryMenu',
                    )
                );
                ?>

                <a href="#" class="c-btn">
                    Contact us
                </a>
                <button class="toggle togglePrimary">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
            </div>

        </nav>
    </header>

    <!-- Navbar End -->