<?php 
// functions.php
function theme_support_options() {
    $defaults = array(
    'height'      => 150,
    'width'       => 250,
    'flex-height' => false, 
    'flex-width'  => false
    );
    add_theme_support( 'custom-logo', $defaults );
    add_theme_support( 'post-thumbnails' );
}
add_action( 'after_setup_theme', 'theme_support_options' );
   
   
function customtheme_theme_support(){
    add_theme_support('title-tag');
}  
add_action('after_setup_theme','customtheme_theme_support');


// add style
function customtheme_styles() {
    wp_enqueue_style( 'custometheme-main', get_template_directory_uri() . "/css/main.css", array(),'1.0','all');
    wp_enqueue_style( 'custometheme-style', get_template_directory_uri() . "/css/style.css", array(),'1.0','all');
    wp_enqueue_style( 'custometheme-footer', get_template_directory_uri() . "/css/footer.css", array(),'1.0','all');
    wp_enqueue_style( 'custometheme-bootscss', get_template_directory_uri() . "/css/bootstrap-grid.min.css", array(),'1.0','all');
    wp_enqueue_style( 'custometheme-gfont', "https://fonts.googleapis.com/css2?family=Work+Sans:wght@500&display=swap", array(),'1.0','all');
    wp_enqueue_style( 'custometheme-theme', "https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css", array(),'1.0','all');
    wp_enqueue_style( 'custometheme-slick', "https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css", array(),'1.0','all');
}
add_action( 'wp_enqueue_scripts', 'customtheme_styles' );

// add scripts
function customtheme_scripts() {
    wp_enqueue_script( 'custometheme-jquery', "https://code.jquery.com/jquery-3.6.0.min.js", array(), true);
    wp_enqueue_script( 'custometheme-main', get_template_directory_uri() . '/js/main.js', array(), '1.0.0', true );
    wp_enqueue_script( 'custometheme-slickjs', "https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js", array(), true);
}
add_action( 'wp_enqueue_scripts', 'customtheme_scripts' );

// register menu
register_nav_menus(
    array(
        'primary' => __( 'All Links', 'avegen' )
    )
);


// Allow SVG
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
    global $wp_version;
    if ( $wp_version !== '4.7.1' ) {
       return $data;
    }
    $filetype = wp_check_filetype( $filename, $mimes );
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];  
}, 10, 4 );
  
function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter( 'upload_mimes', 'cc_mime_types' );
  
function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
}
add_action( 'admin_head', 'fix_svg' );
    
//initialize custom posts
require_once('inc/custom-post-with-shortcode.php');
    
// Theme Options
require_once('inc/theme-option.php');


// Regster Widget sidebars
function site_widgets_init() {
	register_sidebar(
		array(
			'name'          => __( 'Description', 'hma' ),
			'id'            => 'info_block',
			'description'   => __( 'Add widgets here to appear in your footer.', 'Avegan' ),
			'before_widget' => '',
			'after_widget'  => '',
		)
	);

	register_sidebar(
		array(
			'name'          => __( 'Office One', 'hma' ),
			'id'            => 'office_one',
			'description'   => __( 'Add widgets here to appear in your footer.', 'Avegan' ),
			'before_widget' => '',
			'after_widget'  => '',
		)
	);
	register_sidebar(
		array(
			'name'          => __( 'Office Two', 'hma' ),
			'id'            => 'office_two',
			'description'   => __( 'Add widgets here to appear in your footer.', 'Avegan' ),
			'before_widget' => '',
			'after_widget'  => '',
		)
	);
	register_sidebar(
		array(
			'name'          => __( 'Copyright Text', 'hma' ),
			'id'            => 'footer_copyright',
			'description'   => __( 'Add widgets here to appear in your footer.', 'Avegan' ),
			'before_widget' => '',
			'after_widget'  => '',
		)
	);
	register_sidebar(
		array(
			'name'          => __( 'Footer Column Two', 'hma' ),
			'id'            => 'footer_column_two',
			'description'   => __( 'Add widgets here to appear in your footer.', 'Avegan' ),
			'before_widget' => '',
			'after_widget'  => '',
		)
	);
	register_sidebar(
		array(
			'name'          => __( 'Footer Column Three', 'hma' ),
			'id'            => 'footer_column_three',
			'description'   => __( 'Add widgets here to appear in your footer.', 'Avegan' ),
			'before_widget' => '',
			'after_widget'  => '',
		)
	);
	register_sidebar(
		array(
			'name'          => __( 'Footer Column Four', 'hma' ),
			'id'            => 'footer_column_four',
			'description'   => __( 'Add widgets here to appear in your footer.', 'Avegan' ),
			'before_widget' => '',
			'after_widget'  => '',
		)
	);
	register_sidebar(
		array(
			'name'          => __( 'Footer Bottom Menu', 'hma' ),
			'id'            => 'footer_bottom_menu',
			'description'   => __( 'Add widgets here to appear in your footer.', 'Avegan' ),
			'before_widget' => '',
			'after_widget'  => '',
		)
	);
	register_sidebar(
		array(
			'name'          => __( 'News Letter Short Code', 'hma' ),
			'id'            => 'news_letter',
			'description'   => __( 'Add widgets here to appear in your footer.', 'Avegan' ),
			'before_widget' => '',
			'after_widget'  => '',
		)
	);
	
	
}
add_action( 'widgets_init', 'site_widgets_init' );

?>



