<?php 
// functions.php
// create a function to add theme support options
function theme_support_options() {
    $defaults = array(
    'height'      => 150,
    'width'       => 250,
    'flex-height' => false, // <-- setting both flex-height and flex-width to false maintains an aspect ratio
    'flex-width'  => false
    );
    add_theme_support( 'custom-logo', $defaults );
   }
   // call the function in the hook
   add_action( 'after_setup_theme', 'theme_support_options' );
   
   
   // I'm not a big fan of the 'header-text' setting to hide elements by class name if a logo exists. You can simple use a condition statement in your header.php to accomplish the same thing, and it's more clear what is occurring.
function customtheme_theme_support(){
    add_theme_support('title-tag');
}  
add_action('after_setup_theme','customtheme_theme_support');


// add style...............................................................................................................
function customtheme_styles() {
    wp_enqueue_style( 'custometheme-main', get_template_directory_uri() . "/css/main.css", array(),'1.0','all');
    wp_enqueue_style( 'custometheme-style', get_template_directory_uri() . "/css/style.css", array(),'1.0','all');
    wp_enqueue_style( 'custometheme-footer', get_template_directory_uri() . "/css/footer.css", array(),'1.0','all');
    wp_enqueue_style( 'custometheme-bootscss', get_template_directory_uri() . "/css/bootstrap-grid.min.css", array(),'1.0','all');
    wp_enqueue_style( 'custometheme-gfont', "https://fonts.googleapis.com/css2?family=Work+Sans:wght@500&display=swap", array(),'1.0','all');

    wp_enqueue_style( 'custometheme-theme', "https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css", array(),'1.0','all');
    wp_enqueue_style( 'custometheme-slick', "https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css", array(),'1.0','all');
    
   
    
    http://localhost/avegen/wp-content/themes/customtheme/css/bootstrap-grid.min.css


}
add_action( 'wp_enqueue_scripts', 'customtheme_styles' );


// add scripts......................................................................................................................................

function customtheme_scripts() {
   
    wp_enqueue_script( 'custometheme-jquery', "https://code.jquery.com/jquery-3.6.0.min.js", array(), true);
    wp_enqueue_script( 'custometheme-main', get_template_directory_uri() . '/js/main.js', array(), '1.0.0', true );

    wp_enqueue_script( 'custometheme-slickjs', "https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js", array(), true);



   

}
add_action( 'wp_enqueue_scripts', 'customtheme_scripts' );

// register menu
register_nav_menus(
    array(
        'primary' => __( 'All Links', 'avegen' )
    )
);


// Allow SVG
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {

    global $wp_version;
    if ( $wp_version !== '4.7.1' ) {
       return $data;
    }
  
    $filetype = wp_check_filetype( $filename, $mimes );
  
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
  }
  add_action( 'admin_head', 'fix_svg' );






  
//   custom type post

/*
* Creating a function to create our CPT
*/
  
function custom_post_type() {
  
    // Set UI labels for Custom Post Type
        $labels = array(
            'name'                => _x( 'Movies', 'Post Type General Name', 'twentytwentyone' ),
            'singular_name'       => _x( 'Movie', 'Post Type Singular Name', 'twentytwentyone' ),
            'menu_name'           => __( 'Movies', 'twentytwentyone' ),
            'parent_item_colon'   => __( 'Parent Movie', 'twentytwentyone' ),
            'all_items'           => __( 'All Movies', 'twentytwentyone' ),
            'view_item'           => __( 'View Movie', 'twentytwentyone' ),
            'add_new_item'        => __( 'Add New Movie', 'twentytwentyone' ),
            'add_new'             => __( 'Add New', 'twentytwentyone' ),
            'edit_item'           => __( 'Edit Movie', 'twentytwentyone' ),
            'update_item'         => __( 'Update Movie', 'twentytwentyone' ),
            'search_items'        => __( 'Search Movie', 'twentytwentyone' ),
            'not_found'           => __( 'Not Found', 'twentytwentyone' ),
            'not_found_in_trash'  => __( 'Not found in Trash', 'twentytwentyone' ),
        );
          
    // Set other options for Custom Post Type
          
        $args = array(
            'label'               => __( 'movies', 'twentytwentyone' ),
            'description'         => __( 'Movie news and reviews', 'twentytwentyone' ),
            'labels'              => $labels,
            // Features this CPT supports in Post Editor
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
            // You can associate this CPT with a taxonomy or custom taxonomy. 
            'taxonomies'          => array( 'genres' ),
            /* A hierarchical CPT is like Pages and can have
            * Parent and child items. A non-hierarchical CPT
            * is like Posts.
            */
            'hierarchical'        => false,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'show_in_rest' => true,
      
        );
          
        // Registering your Custom Post Type
        register_post_type( 'movies', $args );
      
    }
      
    /* Hook into the 'init' action so that the function
    * Containing our post type registration is not 
    * unnecessarily executed. 
    */
      
    add_action( 'init', 'custom_post_type', 0 );
?>



