<?php
/**
 * Create A Simple Theme Options Panel
 *
 */

function theme_settings_page()
{
    ?>
<div class="wrap">
    <h1>Theme Panel</h1>
    <form class="theme-options" method="post" action="options.php">
        <?php
	            settings_fields("header-section");
	            do_settings_sections("theme-options");      
	            submit_button(); 
	        ?>
    </form>
</div>
<style>
.theme-options input[type=text], .theme-options input[type=url], .theme-options input[type=tel]  {
    max-width: 464px;
    width: 100%;
    height: 40px;
}

.theme-options textarea {
    max-width: 464px;
    width: 100%;
}
</style>
<?php
}

function add_theme_menu_item()
{
	add_menu_page("Theme Settings", "Theme Settings", "manage_options", "theme-panel", "theme_settings_page", null, 99);
}

add_action("admin_menu", "add_theme_menu_item");












function display_dark_logo_url() { ?>
	<input type="text" name="dark_logo_url" id="dark_logo_url" value="<?php echo get_option('dark_logo_url'); ?>" />
<?php }

function display_theme_panel_fields()
{
	add_settings_section("header-section", "Global Information", null, "theme-options");
		add_settings_field("dark_logo_url", "dark_logo_url", "display_dark_logo_url", "theme-options", "header-section");
		
		register_setting("header-section", "dark_logo_url");
}

add_action("admin_init", "display_theme_panel_fields");

