<?php 

  
//   custom type post working with
function work_with_post() {  
    // Set UI labels for Custom Post Type
    $labels = array(
        'name'                => _x( 'Working With', 'Post Type General Name'),
        'singular_name'       => _x( 'Working With Item', 'Post Type Singular Name'),
        'menu_name'           => __( 'Working With'),
        'parent_item_colon'   => __( 'Parent Working With Item'),
        'all_items'           => __( 'All Working With'),
        'view_item'           => __( 'View Working With Item'),
        'add_new_item'        => __( 'Add New Working With Item'),
        'add_new'             => __( 'Add New'),
        'edit_item'           => __( 'Edit Working With Item'),
        'update_item'         => __( 'Update Working With Item'),
        'search_items'        => __( 'Search Working With Item'),
        'not_found'           => __( 'Not Found'),
        'not_found_in_trash'  => __( 'Not found in Trash'),
    );
        
    // Set other options for Custom Post Type
        
    $args = array(
        'label'               => __( 'Working With'),
        'description'         => __( 'Working With Item news and reviews'),
        'labels'              => $labels,
        'menu_icon'		=> 'dashicons-plugins-checked',
        // Features this CPT supports in Post Editor
        'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
        // You can associate this CPT with a taxonomy or custom taxonomy. 
        'taxonomies'          => array( 'genres' ),
        /* A hierarchical CPT is like Pages and can have
        * Parent and child items. A non-hierarchical CPT
        * is like Posts.
        */
        'hierarchical'        => false,
        'public'              => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'show_in_nav_menus'   => true,
        'show_in_admin_bar'   => true,
        'menu_position'       => 5,
        'can_export'          => true,
        'has_archive'         => true,
        'exclude_from_search' => false,
        'publicly_queryable'  => true,
        'capability_type'     => 'post',
        'show_in_rest' => true,
    
    );
        
    // Registering your Custom Post Type
    register_post_type( 'working_with', $args );
        
    }
    add_action( 'init', 'work_with_post', 0 );
    
    // shortcodes
    // slider one "work with"   
    function avegan_shortcode_workwith(){
        $args = array(
            'post_type'      => 'working_with',
            'posts_per_page' => '10',
            'publish_status' => 'published',
            'orderby' => 'date',
            'order' => 'DESC',
            );
    
        $query = new WP_Query($args);
        if($query->have_posts()) :
        $result = '<div class="avegen_right-slide-box"><div class="slider">';
        while($query->have_posts()) : $query->the_post() ;
            // $jobtype = get_field('job_type');
            $result .= '<div class="items"><div class="item">';
                $result .= '<div class="f-item">';
                $result .= '<img src="'. get_the_post_thumbnail_url() . '" alt="Work Image">';
                $result .= '<div class="toggle-content">';
                // $result .= '<h6>' . $jobtype . '</h6>';
                $result .= '<h3>' . get_the_title() . '</h3>';
                $result .= '<p>' . get_the_content() . '</p>'; 
                // $result .= '<a href="' . get_permalink() .'" class="more-btn">Know More</a>'; 
                $result .= '</div>';
                $result .= '</div>';
            $result .= '</div></div>';
        endwhile;
        wp_reset_postdata();
        $result .= '</div></div>';
        endif;
        return $result;           
    }    
    add_shortcode( 'working_with-slider', 'avegan_shortcode_workwith' ); 
    // shortcode code ends here
    
    
    // recent work
    function recent_work_post() {  
        // Set UI labels for Custom Post Type
        $labels = array(
            'name'                => _x( 'Recent Work', 'Post Type General Name'),
            'singular_name'       => _x( 'Recent Work Item', 'Post Type Singular Name'),
            'menu_name'           => __( 'Recent Work'),
            'parent_item_colon'   => __( 'Parent Recent Work Item'),
            'all_items'           => __( 'All Recent Work'),
            'view_item'           => __( 'View Recent Work Item'),
            'add_new_item'        => __( 'Add New Recent Work Item'),
            'add_new'             => __( 'Add New'),
            'edit_item'           => __( 'Edit Recent Work Item'),
            'update_item'         => __( 'Update Recent Work Item'),
            'search_items'        => __( 'Search Recent Work Item'),
            'not_found'           => __( 'Not Found'),
            'not_found_in_trash'  => __( 'Not found in Trash'),
        );
            
        // Set other options for Custom Post Type
            
        $args = array(
            'label'               => __( 'Recent Work'),
            'description'         => __( 'Recent Work Item news and reviews'),
            'labels'              => $labels,
            'menu_icon'		=> 'dashicons-portfolio',
            // Features this CPT supports in Post Editor
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
            // You can associate this CPT with a taxonomy or custom taxonomy. 
            'taxonomies'          => array( 'genres' ),
            /* A hierarchical CPT is like Pages and can have
            * Parent and child items. A non-hierarchical CPT
            * is like Posts.
            */
            'hierarchical'        => false,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'show_in_rest' => true,
            'post_type' => 'recent_work'
        );
            
        // Registering your Custom Post Type
        register_post_type( 'recent_work', $args );
            
        }
    add_action( 'init', 'recent_work_post', 0 );
    
    // shortcodes
    // slider one "Recent Work"   
    function avegan_shortcode_recent_work(){
        $args = array(
            'post_type'      => 'recent_work',
            'posts_per_page' => '10',
            'publish_status' => 'published',
            'orderby' => 'date',
            'order' => 'DESC',
            );
    
        $query = new WP_Query($args);
        if($query->have_posts()) :
        $result = '<div class="m-r-w"><div class="slider">';
        while($query->have_posts()) : $query->the_post() ;
        $small_heading = get_field('small_heading');
            $description = get_field('description');

            
            $result .= '<div class="items"><div class="item">';
                $result .= '<div class="f-item">';
                $result .= '<div class="slider-img"><img src="'. get_the_post_thumbnail_url() . '" alt="Recent work"></div>';
                $result .= '<div class="text-content">';
                $result .= '<h3>' . get_the_title() . '</h3>';
                $result .= '<p>' . $description . '</p>'; 
                // $result .= '<a href="' . get_permalink() .'" class="Secondary-btn">Read Case Study</a>'; 
                $result .= ' <a class="btn btn-primary btn--arrow" href=" ' . get_permalink() .'">Read Case Study</a>'; 
               
                $result .= '</div>';
                $result .= '</div>';
            $result .= '</div></div>';
        endwhile;
        wp_reset_postdata();
        $result .= '</div></div>';
        endif;
        return $result;           
    }    
    add_shortcode( 'recent_work-slider', 'avegan_shortcode_recent_work' ); 


    // recent work listing
    // "Recent Work"   
    function avegan_shortcode_recent_work_list(){
        $args = array(
            'post_type'      => 'recent_work',
            'posts_per_page' => '10',
            'publish_status' => 'published',
            'orderby' => 'date',
            'order' => 'DESC',
            );
    
        $query = new WP_Query($args);
        if($query->have_posts()) :
        $result = '';
        while($query->have_posts()) : $query->the_post() ;
            $small_heading = get_field('small_heading');
            $description = get_field('description');

            $result .= '<section class="page-section elementor-section elementor-section-boxed jumbotron"><div class="elementor-container">';
                $result .= '<div class="elementor-column elementor-col-50"><img src=" '. get_the_post_thumbnail_url() .' " alt="'. get_the_title().'"></div>';
            
                $result .= ' <div class="elementor-column elementor-col-50 jumbotron-body">';
                    $result .= '<span class="small-label">' . $small_heading . '</span>';
                    $result .= '<a href="'. get_permalink() .'" class="jumbotron-title"><h2>'. get_the_title() . '</h2></a>';
                    $result .= '<div class="jumbotron-text">php '. $description .'</div>'; 
                    $result .= ' <a class="btn btn-primary btn--arrow" href=" ' . get_permalink() .'">Read Case Study</a>'; 
                $result .= '</div>';
            $result .= '</div></section>';
        endwhile;
        wp_reset_postdata();
        $result .= '';
        endif;
        return $result;           
    }    
    add_shortcode( 'recent_work-listing', 'avegan_shortcode_recent_work_list' ); 


    // recent work PDF listing
    // "Recent Work"   
    function avegan_shortcode_recent_work_pdf_list(){
        $args = array(
            'post_type'      => 'recent_work',
            'posts_per_page' => '10',
            'publish_status' => 'published',
            'orderby' => 'date',
            'order' => 'DESC',
            );
    
        $query = new WP_Query($args);
        if($query->have_posts()) :
        $result = '';
        while($query->have_posts()) : $query->the_post() ;
            $small_heading = get_field('small_heading');
            $description = get_field('description');
            $pdf = get_field('pdf');

            $result .= '<section class="page-section elementor-section elementor-section-boxed jumbotron"><div class="elementor-container">';
                $result .= '<div class="elementor-column elementor-col-50"><img src=" '. get_the_post_thumbnail_url() .' " alt="'. get_the_title().'"></div>';
            
                $result .= ' <div class="elementor-column elementor-col-50 jumbotron-body">';
                    $result .= '<span class="small-label">' . $small_heading . '</span>';
                    $result .= '<a href="'. get_permalink() .'" class="jumbotron-title"><h2>'. get_the_title() . '</h2></a>';
                    $result .= '<div class="jumbotron-text">php '. $description .'</div>'; 
                    $result .= ' <a class="btn btn-primary btn--arrow btn--arrow--down" href=" ' . $pdf .'" target="_blank">Download PDF</a>'; 
                $result .= '</div>';
            $result .= '</div></section>';
        endwhile;
        wp_reset_postdata();
        $result .= '';
        endif;
        return $result;           
    }    
    add_shortcode( 'recent_work-pdf_listing', 'avegan_shortcode_recent_work_pdf_list' );
    // shortcode code ends here
        
    
    
    // avegan_team
    function avegan_team_post() {  
        // Set UI labels for Custom Post Type
        $labels = array(
            'name'                => _x( 'Avegan Team', 'Post Type General Name'),
            'singular_name'       => _x( 'Avegan Team Item', 'Post Type Singular Name'),
            'menu_name'           => __( 'Avegan Team'),
            'parent_item_colon'   => __( 'Parent Avegan Team Item'),
            'all_items'           => __( 'All Avegan Team'),
            'view_item'           => __( 'View Avegan Team Item'),
            'add_new_item'        => __( 'Add New Avegan Team Item'),
            'add_new'             => __( 'Add New'),
            'edit_item'           => __( 'Edit Avegan Team Item'),
            'update_item'         => __( 'Update Avegan Team Item'),
            'search_items'        => __( 'Search Avegan Team Item'),
            'not_found'           => __( 'Not Found'),
            'not_found_in_trash'  => __( 'Not found in Trash'),
        );
            
        // Set other options for Custom Post Type 
            
        $args = array(
            'label'               => __( 'Avegan Team'),
            'description'         => __( 'Avegan Team Item news and reviews'),
            'labels'              => $labels,
            'menu_icon'		=> 'dashicons-groups',
            // Features this CPT supports in Post Editor
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
            // You can associate this CPT with a taxonomy or custom taxonomy. 
            'taxonomies'          => array( 'genres' ),
            /* A hierarchical CPT is like Pages and can have
            * Parent and child items. A non-hierarchical CPT
            * is like Posts.
            */
            'hierarchical'        => false,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 5,
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'show_in_rest' => true,
        
        );
            
        // Registering your Custom Post Type
        register_post_type( 'avegan_team', $args );
            
    }
    
    add_action( 'init', 'avegan_team_post', 0 );
    
    // shortcodes
    // slider one "avegan_team"   
    function avegan_shortcode_our_team(){
        $args = array(
            'post_type'      => 'avegan_team',
            'posts_per_page' => '10',
            'publish_status' => 'published',
            'orderby' => 'date',
            'order' => 'DESC',
            );
    
        $query = new WP_Query($args);
        if($query->have_posts()) :
        $result = '<div class="avegen-team-wrapper"><div class="avegen_team-slide-box"><div class="slider">';
        while($query->have_posts()) : $query->the_post() ;
    
            $designation = get_field('designation');
            $linked_url = get_field('linked_url');
            $twitter_url = get_field('twitter_url');
            $youtube_video_id = get_field('youtube_video_id');
            $video_url = get_field('video_url');
            $video_thumbnail = get_field('video_thumbnail');
    
    
            $result .= '<div class="items"><div class="item">';
            $result .= '<div class="f-item">';
            $result .= '<div class="slider-video">';
            if($video_url){
                $result .= '<div class="ratio ratio-21x9 custom-video"><video controls><source src="'. $video_url .'" type="video/mp4"></video></div>';
            } else{
                $result .= '<div class="ratio ratio-21x9 background-video" style="position: initial;background: url('. $video_thumbnail .') top center no-repeat; background-size: cover;">';
                $result .= '<iframe src="https://www.youtube.com/embed/' . $youtube_video_id .'" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen loading="lazy"></iframe>';
                $result .= '<a class="play-btn" href="#">Play Button</a>';
                $result .= '</div>';
            }
            $result .= '</div>';
                    $result .= '<div class="tem-info">';
                        $result .= '<div class="txt-box"><p>' . get_the_title() . '</p> <p>'. $designation . '</p></div>';
                        // $result .= '<p>' . get_the_content() . '</p>'; 
                        $result .= '<div class="team-media">'; 
                        $result .= '<a href="' . $linked_url .  ' "><img src="/avegen/wp-content/uploads/2022/06/linkedin.png" alt=""></a>'; 
                        $result .= '<a href="'. $twitter_url . '"><img src="/avegen/wp-content/uploads/2022/06/twitter.png" alt=""></a>'; 
                        
                        $result .= '</div>'; 
                    $result .= '</div>';
                $result .= '</div>';
            $result .= '</div></div>';
        endwhile;
        wp_reset_postdata();
        $result .= '</div></div></div>';
        endif;
        return $result;           
    }    
    add_shortcode( 'our_team-slider', 'avegan_shortcode_our_team' ); 
    // shortcode code ends here
    
    
    
// avegan life
function avegan_life_post() {  
    // Set UI labels for Custom Post Type
    $labels = array(
        'name'                => _x( 'Life at Avegen', 'Post Type General Name'),
        'singular_name'       => _x( 'Life at Avegen Item', 'Post Type Singular Name'),
        'menu_name'           => __( 'Life at Avegen'),
        'parent_item_colon'   => __( 'Parent Life at Avegen Item'),
        'all_items'           => __( 'All Life at Avegen'),
        'view_item'           => __( 'View Life at Avegen Item'),
        'add_new_item'        => __( 'Add New Life at Avegen Item'),
        'add_new'             => __( 'Add New'),
        'edit_item'           => __( 'Edit Life at Avegen Item'),
        'update_item'         => __( 'Update Life at Avegen Item'),
        'search_items'        => __( 'Search Life at Avegen Item'),
        'not_found'           => __( 'Not Found'),
        'not_found_in_trash'  => __( 'Not found in Trash'),
    );
        
    // Set other options for Custom Post Type
        
    $args = array(
        'label'               => __( 'Life at Avegen'),
        'description'         => __( 'Life at Avegen Item news and reviews'),
        'labels'              => $labels,
        'menu_icon'		=> 'dashicons-admin-home',
        // Features this CPT supports in Post Editor
        'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
        // You can associate this CPT with a taxonomy or custom taxonomy. 
        'taxonomies'          => array( 'genres' ),
        /* A hierarchical CPT is like Pages and can have
        * Parent and child items. A non-hierarchical CPT
        * is like Posts.
        */
        'hierarchical'        => false,
        'public'              => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'show_in_nav_menus'   => true,
        'show_in_admin_bar'   => true,
        'menu_position'       => 5,
        'can_export'          => true,
        'has_archive'         => true,
        'exclude_from_search' => false,
        'publicly_queryable'  => true,
        'capability_type'     => 'post',
        'show_in_rest' => true,
    
    );
        
    // Registering your Custom Post Type
    register_post_type( 'avegan_life', $args );
        
}
add_action( 'init', 'avegan_life_post', 0 );
    
// shortcodes
// slider one "avegan_life"   
function avegan_shortcode_avegan_life(){
    $args = array(
        'post_type'      => 'avegan_life',
        'posts_per_page' => '10',
        'publish_status' => 'published',
        'orderby' => 'date',
        'order' => 'DESC',
        );

    $query = new WP_Query($args);
    if($query->have_posts()) :
    $result = '<div class="life-moment-slide-box"><div class="slider">';
    while($query->have_posts()) : $query->the_post() ;
        $mobile_image = get_field('mobile_image');
        $desktop_image = get_field('desktop_image');
        $result .= '<div class="items"><div class="item">';
            $result .= '<div class="f-item">';
                $result .= '<picture>';
                    $result .= '<source media="(max-width: 767px)" srcset="'. $mobile_image .'">';
                    $result .= '<source media="(min-width: 768px)" srcset="'. $desktop_image .'">';
                    $result .= '<img src="'. $desktop_image . '" alt="avegan_life">';
                $result .= '</picture>';
            $result .= '</div>';
        $result .= '</div></div>';
    endwhile;
    wp_reset_postdata();
    $result .= '</div><div class="slider-img-btn"><a class="btn btn-primary btn--arrow" href="#" tabindex="0">Read Case Study</a></div></div>';
    endif;
    return $result;           
}    
add_shortcode( 'avegan_life-slider', 'avegan_shortcode_avegan_life' ); 
// shortcode code ends here
    

// testimonial
function avegen_testimonial_post() {  
    // Set UI labels for Custom Post Type
    $labels = array(
        'name'                => _x( 'Testimonials', 'Post Type General Name'),
        'singular_name'       => _x( 'Testimonials Item', 'Post Type Singular Name'),
        'menu_name'           => __( 'Testimonials'),
        'parent_item_colon'   => __( 'Parent Testimonials Item'),
        'all_items'           => __( 'All Testimonials'),
        'view_item'           => __( 'View Testimonials Item'),
        'add_new_item'        => __( 'Add New Testimonials Item'),
        'add_new'             => __( 'Add New'),
        'edit_item'           => __( 'Edit Testimonials Item'),
        'update_item'         => __( 'Update Testimonials Item'),
        'search_items'        => __( 'Search Testimonials Item'),
        'not_found'           => __( 'Not Found'),
        'not_found_in_trash'  => __( 'Not found in Trash'),
    );
        
    // Set other options for Custom Post Type
        
    $args = array(
        'label'               => __( 'Testimonials'),
        'description'         => __( 'Testimonials Item news and reviews'),
        'labels'              => $labels,
        'menu_icon'		=> 'dashicons-testimonial',
        // Features this CPT supports in Post Editor
        'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
        // You can associate this CPT with a taxonomy or custom taxonomy. 
        'taxonomies'          => array( 'genres' ),
        /* A hierarchical CPT is like Pages and can have
        * Parent and child items. A non-hierarchical CPT
        * is like Posts.
        */
        'hierarchical'        => false,
        'public'              => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'show_in_nav_menus'   => true,
        'show_in_admin_bar'   => true,
        'menu_position'       => 5,
        'can_export'          => true,
        'has_archive'         => true,
        'exclude_from_search' => false,
        'publicly_queryable'  => true,
        'capability_type'     => 'post',
        'show_in_rest' => true,
    
    );
        
    // Registering your Custom Post Type
    register_post_type( 'avegen_testimonial', $args );
        
}
add_action( 'init', 'avegen_testimonial_post', 0 );
    

// shortcodes
// slider one "Recent Work"   
function avegan_shortcode_avegen_testimonial(){
    $args = array(
        'post_type'      => 'avegen_testimonial',
        'posts_per_page' => '10',
        'publish_status' => 'published',
        'orderby' => 'date',
        'order' => 'DESC',
        );

    $query = new WP_Query($args);
    if($query->have_posts()) :
    $result = '<div class="avegan_slick avegan_slick--light avegen_testimonial-container"><div class="avegen_testimonial-slider"><div class="quote-box"><img src="http://localhost/avegen/wp-content/uploads/2022/06/quote.png" alt=""></div><div class="slider">';
    while($query->have_posts()) : $query->the_post() ;
        
        $result .= '<div class="items"><div class="item">';
            $result .= '<div class="f-item">';            
            $result .= '' . get_the_content() . ''; 
            $result .= '</div>';
            $result .= '<div class="slider-member-info">';
            $result .= '<div class="member-img"><img src="'. get_the_post_thumbnail_url() .'" alt=""></div>';
            $result .= '<div class="about-member"><h4>Dr. John Doe</h4><p>Director, ABC Healthcare System</p></div>';
            $result .= '</div>';

        $result .= '</div></div>';
    endwhile;
    wp_reset_postdata();
    $result .= '</div></div></div>';
    endif;
    return $result;           
}    
add_shortcode( 'avegen_testimonial-slider', 'avegan_shortcode_avegen_testimonial' ); 
// shortcode code ends here
